/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.google.common.base.Suppliers;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.item.ItemSlots;
import com.simibubi.create.foundation.mixin.accessor.MobEffectInstanceAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;

public class CreateCodecs {
    public static final Codec<Integer> INT_STR = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException ignored) {
            return DataResult.error(() -> "Not an integer: " + string);
        }
    }, String::valueOf);
    public static final Codec<ItemStackHandler> ITEM_STACK_HANDLER = ExtraCodecs.m_184415_(() -> ItemSlots.CODEC.xmap(slots -> slots.toHandler(ItemStackHandler::new), ItemSlots::fromHandler));
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(0.0, Double.MAX_VALUE, i -> "Value must be non-negative: " + i);
    public static final Codec<Double> POSITIVE_DOUBLE = CreateCodecs.doubleRangeWithMessage(1.0, Double.MAX_VALUE, i -> "Value must be positive: " + i);
    public static final Codec<Integer> UNSIGNED_BYTE = Codec.BYTE.flatComapMap(UnsignedBytes::toInt, p_324632_ -> p_324632_ > 255 ? DataResult.error(() -> "Unsigned byte was too large: " + p_324632_ + " > 255") : DataResult.success((Object)p_324632_.byteValue()));
    public static final Codec<FluidStack> FLUID_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("FluidName").forGetter(FluidStack::getFluid), (App)Codec.INT.fieldOf("Amount").forGetter(FluidStack::getAmount), (App)CompoundTag.f_128325_.optionalFieldOf("Tag").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)instance, (fluid, amount, tag) -> {
        FluidStack stack = new FluidStack(fluid, amount.intValue());
        if (!stack.isEmpty()) {
            tag.ifPresent(arg_0 -> ((FluidStack)stack).setTag(arg_0));
        }
        return stack;
    }));
    public static final MapCodec<MobEffectInstance> MOB_EFFECT_INSTANCE = CreateCodecs.recursive("MobEffectInstance", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(MobEffectInstance::m_19557_), (App)UNSIGNED_BYTE.optionalFieldOf("amplifier", (Object)0).forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(MobEffectInstance::m_19572_), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(MobEffectInstance::m_19575_), (App)codec.optionalFieldOf("hidden_effect").forGetter(i -> Optional.ofNullable(((MobEffectInstanceAccessor)i).create$getHiddenEffect())), (App)MobEffectInstance.FactorData.f_216907_.optionalFieldOf("factor_data").forGetter(MobEffectInstance::m_216895_)).apply((Applicative)instance, (effect, duration, amplifier, isAmbient, showParticles, showIcon, hiddenEffect, factorData) -> new MobEffectInstance(effect, duration.intValue(), amplifier.intValue(), isAmbient.booleanValue(), showParticles.booleanValue(), showIcon.booleanValue(), (MobEffectInstance)hiddenEffect.orElse(null), factorData))));
    public static final Codec<FoodProperties> FOOD_PROPERTIES = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("nutrition").forGetter(FoodProperties::m_38744_), (App)Codec.FLOAT.fieldOf("saturation_modifier").forGetter(FoodProperties::m_38745_), (App)Codec.BOOL.optionalFieldOf("is_meat", (Object)false).forGetter(FoodProperties::m_38746_), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodProperties::m_38747_), (App)Codec.BOOL.optionalFieldOf("is_fast_food", (Object)false).forGetter(FoodProperties::m_38748_), (App)FoodEffect.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(i -> {
        ArrayList<FoodEffect> effects = new ArrayList<FoodEffect>();
        for (Pair pair : i.m_38749_()) {
            effects.add(new FoodEffect((MobEffectInstance)pair.getFirst(), ((Float)pair.getSecond()).floatValue()));
        }
        return effects;
    })).apply((Applicative)instance, (nutrition, saturationModifier, isMeat, canAlwaysEat, isFastFood, effects) -> {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(nutrition.intValue()).m_38758_(saturationModifier.floatValue());
        if (isMeat.booleanValue()) {
            builder.m_38757_();
        }
        if (canAlwaysEat.booleanValue()) {
            builder.m_38765_();
        }
        if (isFastFood.booleanValue()) {
            builder.m_38766_();
        }
        for (FoodEffect effect : effects) {
            builder.effect(effect.effectSupplier(), effect.probability());
        }
        return builder.m_38767_();
    }));

    public static Codec<Integer> boundedIntStr(int min) {
        return ExtraCodecs.m_264370_(INT_STR, i -> i >= min ? DataResult.success((Object)i) : DataResult.error(() -> "Value under minimum of " + min));
    }

    private static Codec<Double> doubleRangeWithMessage(double min, double max, Function<Double, String> errorMessage) {
        return ExtraCodecs.m_264370_((Codec)Codec.DOUBLE, i -> i.compareTo(min) >= 0 && i.compareTo(max) <= 0 ? DataResult.success((Object)i) : DataResult.error(() -> (String)errorMessage.apply((Double)i)));
    }

    public static <A> MapCodec<A> recursive(String name, Function<Codec<A>, MapCodec<A>> wrapped) {
        return new RecursiveMapCodec<A>(name, wrapped);
    }

    private static class RecursiveMapCodec<A>
    extends MapCodec<A> {
        private final String name;
        private final Supplier<MapCodec<A>> wrapped;

        private RecursiveMapCodec(String name, Function<Codec<A>, MapCodec<A>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (MapCodec)wrapped.apply(this.codec()));
        }

        public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return this.wrapped.get().keys(ops);
        }

        public String toString() {
            return "RecursiveMapCodec[" + this.name + "]";
        }
    }

    public record FoodEffect(Supplier<MobEffectInstance> effectSupplier, float probability) {
        public static final Codec<FoodEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MOB_EFFECT_INSTANCE.fieldOf("effect").forGetter(FoodEffect::effect), (App)Codec.FLOAT.fieldOf("probability").forGetter(FoodEffect::probability)).apply((Applicative)instance, FoodEffect::new));

        private FoodEffect(MobEffectInstance effect, float probability) {
            this(() -> effect, probability);
        }

        public MobEffectInstance effect() {
            return new MobEffectInstance(this.effectSupplier.get());
        }
    }
}

