/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.util;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.util.BlastFurnaceLayer;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlastFurnaceValidator {
    private Level level;
    private BlockPos tuyerePos;
    private BlockPos outputPos;
    private BlockPos startingOutputPos;
    private static final Map<Block, Character> BLOCK_SYMBOLS = Map.of((Block)TFMGBlocks.BLAST_FURNACE_HATCH.get(), Character.valueOf('T'), (Block)TFMGBlocks.FIREPROOF_BRICKS.get(), Character.valueOf('B'), (Block)TFMGBlocks.FIREPROOF_BRICK_REINFORCEMENT.get(), Character.valueOf('F'), (Block)TFMGBlocks.BLAST_FURNACE_REINFORCEMENT.get(), Character.valueOf('R'), (Block)TFMGBlocks.RUSTED_BLAST_FURNACE_REINFORCEMENT.get(), Character.valueOf('R'), (Block)TFMGBlocks.BLAST_FURNACE_REINFORCEMENT_WALL.get(), Character.valueOf('W'), (Block)TFMGBlocks.RUSTED_BLAST_FURNACE_REINFORCEMENT_WALL.get(), Character.valueOf('W'), (Block)TFMGBlocks.BLAST_FURNACE_OUTPUT.get(), Character.valueOf('O'), Blocks.f_50016_, Character.valueOf('A'));

    public BlastFurnaceValidator(BlockPos outputPos, Level levelIn) {
        this.level = levelIn;
        this.startingOutputPos = outputPos;
    }

    public ValidationResult validateFurnace() {
        BlockState outputState = this.level.m_8055_(this.startingOutputPos);
        if (!outputState.m_60713_((Block)TFMGBlocks.BLAST_FURNACE_OUTPUT.get())) {
            return new ValidationResult(0, false);
        }
        this.resetState();
        BlockPos baseCenterPos = this.startingOutputPos.m_121945_(((Direction)this.level.m_8055_(this.startingOutputPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
        LayerScanResult layerScan = this.scanLayer(baseCenterPos);
        BlastFurnaceLayer layer = new BlastFurnaceLayer(layerScan.pattern());
        if (!layer.isBaseLayer() || !this.validSpecialBlocks(layerScan, true)) {
            return new ValidationResult(0, false);
        }
        int height = 1;
        boolean isReinforced = layer.isReinforced();
        int maxHeight = (Integer)TFMGConfigs.common().machines.blastFurnaceMaxHeight.get();
        for (int i = 1; i < maxHeight && (layer = new BlastFurnaceLayer((layerScan = this.scanLayer(baseCenterPos.m_6630_(i))).pattern())).isWallLayer() && this.validSpecialBlocks(layerScan, false); ++i) {
            ++height;
            isReinforced &= layer.isReinforced();
        }
        return new ValidationResult(height, isReinforced);
    }

    private void resetState() {
        this.tuyerePos = null;
        this.outputPos = null;
    }

    private LayerScanResult scanLayer(BlockPos center) {
        StringBuilder pattern = new StringBuilder(25);
        BlockPos tuyerePos = null;
        BlockPos outputPos = null;
        for (int dz = -2; dz <= 2; ++dz) {
            for (int dx = -2; dx <= 2; ++dx) {
                BlockPos pos = center.m_7918_(dx, 0, dz);
                char symbol = BlastFurnaceValidator.getBlockSymbol(this.level.m_8055_(pos));
                if (symbol == 'T') {
                    tuyerePos = pos;
                } else if (symbol == 'O') {
                    outputPos = pos;
                }
                pattern.append(symbol);
            }
        }
        return new LayerScanResult(pattern.toString(), tuyerePos, outputPos);
    }

    private boolean validSpecialBlocks(LayerScanResult scan, boolean isBaseLayer) {
        if (scan.outputPos() != null) {
            if (!isBaseLayer || this.outputPos != null) {
                return false;
            }
            this.outputPos = scan.outputPos();
        }
        if (scan.tuyerePos() != null) {
            if (this.tuyerePos != null) {
                return false;
            }
            this.tuyerePos = scan.tuyerePos();
        }
        return true;
    }

    public BlockPos getTuyerePos() {
        return this.tuyerePos;
    }

    public static char getBlockSymbol(BlockState state) {
        return BLOCK_SYMBOLS.getOrDefault(state.m_60734_(), Character.valueOf('*')).charValue();
    }

    public record ValidationResult(int height, boolean isReinforced) {
    }

    public record LayerScanResult(String pattern, BlockPos tuyerePos, BlockPos outputPos) {
    }
}

