/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.palettes;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.palettes.TFMGPaletteBlockPartial;
import com.simibubi.create.content.decoration.palettes.ConnectedPillarBlock;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.block.connected.RotatedPillarCTBehaviour;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class TFMGPaletteBlockPattern {
    public static final TFMGPaletteBlockPattern CUT = TFMGPaletteBlockPattern.create("cut", PatternNameType.PREFIX, TFMGPaletteBlockPartial.ALL_PARTIALS);
    public static final TFMGPaletteBlockPattern BRICKS = TFMGPaletteBlockPattern.create("cut_bricks", PatternNameType.WRAP, TFMGPaletteBlockPartial.ALL_PARTIALS).textures("brick");
    public static final TFMGPaletteBlockPattern SMALL_BRICKS = TFMGPaletteBlockPattern.create("small_bricks", PatternNameType.WRAP, TFMGPaletteBlockPartial.ALL_PARTIALS).textures("small_brick");
    public static final TFMGPaletteBlockPattern POLISHED = TFMGPaletteBlockPattern.create("polished_cut", PatternNameType.PREFIX, TFMGPaletteBlockPartial.FOR_POLISHED).textures("polished", "slab");
    public static final TFMGPaletteBlockPattern LAYERED = TFMGPaletteBlockPattern.create("layered", PatternNameType.PREFIX, new TFMGPaletteBlockPartial[0]).blockStateFactory(p -> p::cubeColumn).textures("layered", "cap").connectedTextures(v -> new HorizontalCTBehaviour(TFMGPaletteBlockPattern.ct(v, CTs.LAYERED), TFMGPaletteBlockPattern.ct(v, CTs.CAP)));
    public static final TFMGPaletteBlockPattern PILLAR = TFMGPaletteBlockPattern.create("pillar", PatternNameType.SUFFIX, new TFMGPaletteBlockPartial[0]).blockStateFactory(p -> p::pillar).block((NonNullFunction<BlockBehaviour.Properties, ? extends Block>)((NonNullFunction)ConnectedPillarBlock::new)).textures("pillar", "cap").connectedTextures(v -> new RotatedPillarCTBehaviour(TFMGPaletteBlockPattern.ct(v, CTs.PILLAR), TFMGPaletteBlockPattern.ct(v, CTs.CAP)));
    public static final TFMGPaletteBlockPattern[] VANILLA_RANGE = new TFMGPaletteBlockPattern[]{CUT, POLISHED, BRICKS, SMALL_BRICKS, LAYERED, PILLAR};
    public static final TFMGPaletteBlockPattern[] STANDARD_RANGE = new TFMGPaletteBlockPattern[]{CUT, POLISHED, BRICKS, SMALL_BRICKS, LAYERED, PILLAR};
    static final String TEXTURE_LOCATION = "block/palettes/stone_types/%s/%s";
    private PatternNameType nameType;
    private String[] textures;
    private String id;
    private boolean isTranslucent;
    private TagKey<Block>[] blockTags;
    private TagKey<Item>[] itemTags;
    private Optional<Function<String, ConnectedTextureBehaviour>> ctFactory;
    private IPatternBlockStateGenerator blockStateGenerator;
    private NonNullFunction<BlockBehaviour.Properties, ? extends Block> blockFactory;
    private NonNullFunction<NonNullSupplier<Block>, NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateRecipeProvider>> additionalRecipes;
    private TFMGPaletteBlockPartial<? extends Block>[] partials;
    @OnlyIn(value=Dist.CLIENT)
    private RenderType renderType;

    private static TFMGPaletteBlockPattern create(String name, PatternNameType nameType, TFMGPaletteBlockPartial<?> ... partials) {
        TFMGPaletteBlockPattern pattern = new TFMGPaletteBlockPattern();
        pattern.id = name;
        pattern.ctFactory = Optional.empty();
        pattern.nameType = nameType;
        pattern.partials = partials;
        pattern.additionalRecipes = $ -> NonNullBiConsumer.noop();
        pattern.isTranslucent = false;
        pattern.blockFactory = Block::new;
        pattern.textures = new String[]{name};
        pattern.blockStateGenerator = p -> p::cubeAll;
        return pattern;
    }

    public IPatternBlockStateGenerator getBlockStateGenerator() {
        return this.blockStateGenerator;
    }

    public boolean isTranslucent() {
        return this.isTranslucent;
    }

    public TagKey<Block>[] getBlockTags() {
        return this.blockTags;
    }

    public TagKey<Item>[] getItemTags() {
        return this.itemTags;
    }

    public NonNullFunction<BlockBehaviour.Properties, ? extends Block> getBlockFactory() {
        return this.blockFactory;
    }

    public TFMGPaletteBlockPartial<? extends Block>[] getPartials() {
        return this.partials;
    }

    public String getTexture(int index) {
        return this.textures[index];
    }

    public void addRecipes(NonNullSupplier<Block> baseBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
        ((NonNullBiConsumer)this.additionalRecipes.apply(baseBlock)).accept(c, (Object)p);
    }

    public Optional<Supplier<ConnectedTextureBehaviour>> createCTBehaviour(String variant) {
        return this.ctFactory.map(d -> () -> (ConnectedTextureBehaviour)d.apply(variant));
    }

    private TFMGPaletteBlockPattern blockStateFactory(IPatternBlockStateGenerator factory) {
        this.blockStateGenerator = factory;
        return this;
    }

    private TFMGPaletteBlockPattern textures(String ... textures) {
        this.textures = textures;
        return this;
    }

    private TFMGPaletteBlockPattern block(NonNullFunction<BlockBehaviour.Properties, ? extends Block> blockFactory) {
        this.blockFactory = blockFactory;
        return this;
    }

    private TFMGPaletteBlockPattern connectedTextures(Function<String, ConnectedTextureBehaviour> factory) {
        this.ctFactory = Optional.of(factory);
        return this;
    }

    public IBlockStateProvider cubeAll(String variant) {
        ResourceLocation all = TFMGPaletteBlockPattern.toLocation(variant, this.textures[0]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(this.createName(variant), all));
    }

    public IBlockStateProvider cubeBottomTop(String variant) {
        ResourceLocation side = TFMGPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation bottom = TFMGPaletteBlockPattern.toLocation(variant, this.textures[1]);
        ResourceLocation top = TFMGPaletteBlockPattern.toLocation(variant, this.textures[2]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(this.createName(variant), side, bottom, top));
    }

    public IBlockStateProvider pillar(String variant) {
        ResourceLocation side = TFMGPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation end = TFMGPaletteBlockPattern.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            if (axis == Direction.Axis.Y) {
                return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumn(this.createName(variant), side, end)).uvLock(false).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumnHorizontal(this.createName(variant) + "_horizontal", side, end)).uvLock(false).rotationX(90).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        }, new Property[]{BlockStateProperties.f_61362_, ConnectedPillarBlock.NORTH, ConnectedPillarBlock.SOUTH, ConnectedPillarBlock.EAST, ConnectedPillarBlock.WEST});
    }

    public IBlockStateProvider cubeColumn(String variant) {
        ResourceLocation side = TFMGPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation end = TFMGPaletteBlockPattern.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeColumn(this.createName(variant), side, end));
    }

    public String createName(String variant) {
        String[] split;
        if (this.nameType == PatternNameType.WRAP && (split = this.id.split("_")).length == 2) {
            String formatString = "%s_%s_%s";
            return String.format(formatString, split[0], variant, split[1]);
        }
        String formatString = "%s_%s";
        return this.nameType == PatternNameType.SUFFIX ? String.format(formatString, variant, this.id) : String.format(formatString, this.id, variant);
    }

    protected static ResourceLocation toLocation(String variant, String texture) {
        return TFMG.asResource(String.format(TEXTURE_LOCATION, texture, variant + (texture.equals("cut") ? "_" : "_cut_") + texture));
    }

    protected static CTSpriteShiftEntry ct(String variant, CTs texture) {
        ResourceLocation resLoc = texture.srcFactory.apply(variant);
        ResourceLocation resLocTarget = texture.targetFactory.apply(variant);
        return CTSpriteShifter.getCT((CTType)texture.type, (ResourceLocation)resLoc, (ResourceLocation)new ResourceLocation(resLocTarget.m_135827_(), resLocTarget.m_135815_() + "_connected"));
    }

    static enum PatternNameType {
        PREFIX,
        SUFFIX,
        WRAP;

    }

    @FunctionalInterface
    static interface IPatternBlockStateGenerator
    extends Function<TFMGPaletteBlockPattern, Function<String, IBlockStateProvider>> {
    }

    @FunctionalInterface
    static interface IBlockStateProvider
    extends NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateBlockstateProvider> {
    }

    public static enum CTs {
        PILLAR((CTType)AllCTTypes.RECTANGLE, s -> TFMGPaletteBlockPattern.toLocation(s, "pillar")),
        CAP((CTType)AllCTTypes.OMNIDIRECTIONAL, s -> TFMGPaletteBlockPattern.toLocation(s, "cap")),
        LAYERED((CTType)AllCTTypes.HORIZONTAL_KRYPPERS, s -> TFMGPaletteBlockPattern.toLocation(s, "layered"));

        public CTType type;
        private Function<String, ResourceLocation> srcFactory;
        private Function<String, ResourceLocation> targetFactory;

        private CTs(CTType type, Function<String, ResourceLocation> factory) {
            this(type, factory, factory);
        }

        private CTs(CTType type, Function<String, ResourceLocation> srcFactory, Function<String, ResourceLocation> targetFactory) {
            this.type = type;
            this.srcFactory = srcFactory;
            this.targetFactory = targetFactory;
        }
    }
}

