/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.fluid;

import com.drmangotea.tfmg.registry.TFMGFluids;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tterrag.registrate.builders.FluidBuilder;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GasFluidType
extends TFMGFluids.SolidRenderedPlaceableFluidType {
    final int color;

    public GasFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, int color) {
        super(properties, stillTexture, flowingTexture);
        this.color = color;
    }

    public static FluidBuilder.FluidTypeFactory create(int color) {
        return (p, s, f) -> {
            GasFluidType fluidType = new GasFluidType(p, s, f, color);
            return fluidType;
        };
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return TFMGFluids.getGasTexture();
            }

            public ResourceLocation getFlowingTexture() {
                return TFMGFluids.getGasTexture();
            }

            public int getTintColor(FluidStack stack) {
                return GasFluidType.this.color;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return -6688209;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                Vector3f customFogColor = GasFluidType.this.getCustomFogColor();
                return customFogColor == null ? fluidFogColor : customFogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                float modifier = GasFluidType.this.getFogDistanceModifier();
                float baseWaterFog = 96.0f;
                if (modifier != 1.0f) {
                    RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                    RenderSystem.setShaderFogStart((float)-8.0f);
                    RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                }
            }
        });
    }

    public int getDensity() {
        return -1;
    }
}

