/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.sound;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\u0004R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/util/sound/PropellerSoundInstance;", "Lnet/minecraft/client/resources/sounds/AbstractTickableSoundInstance;", "", "stopNow", "()V", "", "canStartSilent", "()Z", "tick", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "propeller", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "getPropeller", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "brass", "Z", "getBrass", "Lnet/minecraft/util/RandomSource;", "randomSource", "<init>", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;Lnet/minecraft/util/RandomSource;)V", "clockwork"})
public final class PropellerSoundInstance
extends AbstractTickableSoundInstance {
    @NotNull
    private final PropellerBearingBlockEntity propeller;
    private final boolean brass;

    public PropellerSoundInstance(@NotNull PropellerBearingBlockEntity propeller, @NotNull RandomSource randomSource) {
        SoundEvent soundEvent;
        Intrinsics.checkNotNullParameter((Object)propeller, (String)"propeller");
        Intrinsics.checkNotNullParameter((Object)randomSource, (String)"randomSource");
        if (propeller.getBrass()) {
            SoundEvent soundEvent2 = ClockworkSounds.INSTANCE.getPROPELLER().getMainEvent();
            soundEvent = soundEvent2;
            Intrinsics.checkNotNull((Object)soundEvent2);
        } else {
            SoundEvent soundEvent3 = ClockworkSounds.INSTANCE.getJUNK_PROPELLER().getMainEvent();
            soundEvent = soundEvent3;
            Intrinsics.checkNotNull((Object)soundEvent3);
        }
        super(soundEvent, SoundSource.BLOCKS, randomSource);
        this.propeller = propeller;
        this.brass = this.propeller.getBrass();
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.0f;
        this.f_119575_ = this.propeller.m_58899_().m_123341_();
        this.f_119576_ = this.propeller.m_58899_().m_123342_();
        this.f_119577_ = this.propeller.m_58899_().m_123343_();
    }

    @NotNull
    public final PropellerBearingBlockEntity getPropeller() {
        return this.propeller;
    }

    public final boolean getBrass() {
        return this.brass;
    }

    public final void stopNow() {
        this.m_119609_();
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        if (this.propeller.m_58901_()) {
            this.m_119609_();
            return;
        }
        if (!this.propeller.getRunning() || this.propeller.getStarting()) {
            this.f_119573_ = 0.0f;
            this.f_119574_ = 0.01f;
            this.m_119609_();
            return;
        }
        float proportionedSpeed = (float)Math.abs(this.propeller.getCurrentOmega()) / KineticBlockEntity.convertToAngular((float)256.0f);
        if (proportionedSpeed < 0.01f) {
            this.f_119573_ = 0.0f;
            this.f_119574_ = 0.01f;
            return;
        }
        this.f_119573_ = Mth.m_14036_((float)(0.1f + proportionedSpeed * (this.brass ? 0.7f : 0.8f)), (float)0.0f, (float)2.0f);
        this.f_119574_ = Mth.m_14036_((float)(0.1f + proportionedSpeed * (this.brass ? 0.7f : 0.9f)), (float)0.1f, (float)1.2f);
        this.f_119575_ = this.propeller.m_58899_().m_123341_();
        this.f_119576_ = this.propeller.m_58899_().m_123342_();
        this.f_119577_ = this.propeller.m_58899_().m_123343_();
    }
}

