/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.client.DuctNetworkClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/valkyrienskies/clockwork/util/KelvinParticleHelper;", "", "Lnet/minecraft/client/multiplayer/ClientLevel;", "level", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "ductNodePos", "Lorg/joml/Vector3dc;", "pos", "speed", "", "spawnParticleWithRatio", "(Lnet/minecraft/client/multiplayer/ClientLevel;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)V", "<init>", "()V", "clockwork"})
public final class KelvinParticleHelper {
    @NotNull
    public static final KelvinParticleHelper INSTANCE = new KelvinParticleHelper();

    private KelvinParticleHelper() {
    }

    public final void spawnParticleWithRatio(@NotNull ClientLevel level, @NotNull DuctNodePos ductNodePos, @NotNull Vector3dc pos, @NotNull Vector3dc speed) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ductNodePos, (String)"ductNodePos");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        DuctNetworkClient network = ClockworkModClient.getKelvin();
        HashMap gasMasses = network.getGasMassAt(ductNodePos);
        if (gasMasses.isEmpty()) {
            return;
        }
        Collection collection = gasMasses.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double sum = CollectionsKt.sumOfDouble((Iterable)collection);
        double cumulative = 0.0;
        Set set = gasMasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Object object = CollectionsKt.first((Iterable)set);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        GasType particleGas = (GasType)object;
        for (Map.Entry entry : ((Map)gasMasses).entrySet()) {
            GasType gas = (GasType)entry.getKey();
            double value = ((Number)entry.getValue()).doubleValue();
            cumulative += value;
            if (!(level.f_46441_.m_188500_() <= cumulative / sum)) continue;
            particleGas = gas;
            break;
        }
        network.createGasParticle(level, particleGas, ductNodePos, pos.x(), pos.y(), pos.z(), speed.x(), speed.y(), speed.z());
    }
}

