/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.logistics.gas.filter.edges.ClockworkFilteredDuctEdge;
import org.valkyrienskies.clockwork.content.logistics.gas.oneway.ClockworkOnewayDuct;
import org.valkyrienskies.clockwork.content.logistics.gas.smart.ClockworkSmartEdge;
import org.valkyrienskies.core.util.VSCoreUtilKt;
import org.valkyrienskies.kelvin.api.ConnectionType;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.NodeBehaviorType;
import org.valkyrienskies.kelvin.api.edges.OneWayDuctEdge;
import org.valkyrienskies.kelvin.api.edges.PipeDuctEdge;
import org.valkyrienskies.kelvin.api.nodes.PipeDuctNode;
import org.valkyrienskies.kelvin.api.nodes.PumpDuctNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0019\u001a\u00020\u0018*\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lorg/valkyrienskies/clockwork/util/DuctNetworkUtils;", "", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "pos", "Lorg/valkyrienskies/kelvin/api/nodes/PipeDuctNode;", "createPipeNode", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/kelvin/api/nodes/PipeDuctNode;", "Lorg/valkyrienskies/kelvin/api/nodes/PumpDuctNode;", "createPumpNode", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/kelvin/api/nodes/PumpDuctNode;", "nodeA", "nodeB", "Lorg/valkyrienskies/kelvin/api/edges/PipeDuctEdge;", "createPipeEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/kelvin/api/edges/PipeDuctEdge;", "Lorg/valkyrienskies/kelvin/api/edges/OneWayDuctEdge;", "createOneWayEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/kelvin/api/edges/OneWayDuctEdge;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/filter/edges/ClockworkFilteredDuctEdge;", "createFilteredEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/clockwork/content/logistics/gas/filter/edges/ClockworkFilteredDuctEdge;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/smart/ClockworkSmartEdge;", "createSmartEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/clockwork/content/logistics/gas/smart/ClockworkSmartEdge;", "", "magnitudeSqr", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;)D", "<init>", "()V", "clockwork"})
public final class DuctNetworkUtils {
    @NotNull
    public static final DuctNetworkUtils INSTANCE = new DuctNetworkUtils();

    private DuctNetworkUtils() {
    }

    @NotNull
    public final PipeDuctNode createPipeNode(@NotNull DuctNodePos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new PipeDuctNode(pos, NodeBehaviorType.PIPE, null, 0.25, 1.6375049E7, 1478.0, 4, null);
    }

    @NotNull
    public final PumpDuctNode createPumpNode(@NotNull DuctNodePos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new PumpDuctNode(pos, NodeBehaviorType.PUMP, null, 0.25, 1.6375049E7, 1478.0, 0.0, null, 196, null);
    }

    @NotNull
    public final PipeDuctEdge createPipeEdge(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        return new PipeDuctEdge(ConnectionType.PIPE, nodeA, nodeB, 0.3125, 0.375, 0.0, false, 64, null);
    }

    @NotNull
    public final OneWayDuctEdge createOneWayEdge(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        return new ClockworkOnewayDuct(ConnectionType.ONEWAY, nodeA, nodeB);
    }

    @NotNull
    public final ClockworkFilteredDuctEdge createFilteredEdge(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        return new ClockworkFilteredDuctEdge(ConnectionType.FILTERED, nodeA, nodeB, 0.3125, 0.375, 0.0, null, false, false, 448, null);
    }

    @NotNull
    public final ClockworkSmartEdge createSmartEdge(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        return new ClockworkSmartEdge(ConnectionType.PIPE, nodeA, nodeB, 0.3125, 0.375, 0.0);
    }

    public final double magnitudeSqr(@NotNull DuctNodePos $this$magnitudeSqr) {
        Intrinsics.checkNotNullParameter((Object)$this$magnitudeSqr, (String)"<this>");
        return VSCoreUtilKt.squared((double)$this$magnitudeSqr.getX()) + VSCoreUtilKt.squared((double)$this$magnitudeSqr.getY()) + VSCoreUtilKt.squared((double)$this$magnitudeSqr.getZ());
    }
}

