/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.ClockworkAugmentations;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.SelectedAreaToolkit;
import org.valkyrienskies.clockwork.content.forces.WanderShipControl;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.MathFunctions;
import org.valkyrienskies.core.api.attachment.AttachmentHolder;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.world.ServerShipWorld;
import org.valkyrienskies.core.api.world.connectivity.DoubleComponentAugmentation;
import org.valkyrienskies.core.impl.util.serialization.VSJacksonUtil;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.util.INodeBlockEntity;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.MassDatapackResolver;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bT\u0010UJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010$\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010&\u001a\u00020#2\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b&\u0010*J\u001b\u0010/\u001a\u0004\u0018\u00010.*\u00020+2\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b/\u00100J\u001d\u0010$\u001a\u00020\u00042\u0006\u0010)\u001a\u00020(2\u0006\u00101\u001a\u00020#\u00a2\u0006\u0004\b$\u00102J\u0017\u00105\u001a\u0002042\b\u00103\u001a\u0004\u0018\u00010+\u00a2\u0006\u0004\b5\u00106J\u001f\u00108\u001a\u00020+2\u0006\u00103\u001a\u00020+2\b\u00107\u001a\u0004\u0018\u000104\u00a2\u0006\u0004\b8\u00109JE\u0010@\u001a*\u0012 \u0012\u001e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>0<j\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>`?\u0012\u0004\u0012\u00020>0;2\u0006\u0010:\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b@\u0010AJ\u001f\u0010B\u001a\u00020.2\b\u0010\u0003\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bB\u0010CJC\u0010J\u001a\u001e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I0<j\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I`?2\u0006\u0010E\u001a\u00020D2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010G\u001a\u00020FH\u0007\u00a2\u0006\u0004\bJ\u0010KJC\u0010L\u001a\u001e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I0<j\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I`?2\u0006\u0010E\u001a\u00020D2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010G\u001a\u00020FH\u0007\u00a2\u0006\u0004\bL\u0010KR3\u0010M\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020>0<j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020>`?8\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00190Q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bR\u0010S\u00a8\u0006V"}, d2={"Lorg/valkyrienskies/clockwork/util/ClockworkUtils;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/Level;", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePos", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Lnet/minecraft/world/phys/Vec3;", "vec", "Lnet/minecraft/nbt/ListTag;", "writeVec3", "(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/nbt/ListTag;", "tag", "readVec3", "(Lnet/minecraft/nbt/ListTag;)Lnet/minecraft/world/phys/Vec3;", "", "x", "y", "z", "Lnet/minecraft/core/Direction;", "fromNormal", "(III)Lnet/minecraft/core/Direction;", "Lorg/joml/primitives/AABBic;", "bb", "writeAABBi", "(Lorg/joml/primitives/AABBic;)Lnet/minecraft/nbt/ListTag;", "bbtag", "readAABBi", "(Lnet/minecraft/nbt/ListTag;)Lorg/joml/primitives/AABBic;", "Lorg/joml/Vector3ic;", "writeVector3i", "(Lorg/joml/Vector3ic;)Lnet/minecraft/nbt/ListTag;", "readVector3i", "(Lnet/minecraft/nbt/ListTag;)Lorg/joml/Vector3ic;", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "(Lnet/minecraft/network/FriendlyByteBuf;)Lorg/joml/Vector3ic;", "Lnet/minecraft/nbt/CompoundTag;", "", "prefix", "Lorg/joml/Vector3d;", "getVector3d", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;)Lorg/joml/Vector3d;", "vector3f", "(Lnet/minecraft/network/FriendlyByteBuf;Lorg/joml/Vector3ic;)V", "nbt", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/SelectedAreaToolkit;", "loadArea", "(Lnet/minecraft/nbt/CompoundTag;)Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/SelectedAreaToolkit;", "area", "saveArea", "(Lnet/minecraft/nbt/CompoundTag;Lorg/valkyrienskies/clockwork/content/curiosities/tools/wanderwand/SelectedAreaToolkit;)Lnet/minecraft/nbt/CompoundTag;", "pos", "Lkotlin/Pair;", "Ljava/util/HashMap;", "Lorg/valkyrienskies/kelvin/api/GasType;", "", "Lkotlin/collections/HashMap;", "retrieveGasInfoFromPocket", "(Lorg/joml/Vector3ic;Lnet/minecraft/server/level/ServerLevel;)Lkotlin/Pair;", "getRealPos", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lorg/joml/Vector3d;", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "claim", "Lorg/valkyrienskies/core/api/world/connectivity/DoubleComponentAugmentation;", "referenceKey", "Lorg/joml/Vector3i;", "", "getAirComponentsInChunkClaim", "(Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/world/connectivity/DoubleComponentAugmentation;)Ljava/util/HashMap;", "getSolidComponentsInChunkClaim", "wanderliteNodesToAdd", "Ljava/util/HashMap;", "getWanderliteNodesToAdd", "()Ljava/util/HashMap;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "BY_NORMAL", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nClockworkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClockworkUtils.kt\norg/valkyrienskies/clockwork/util/ClockworkUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,385:1\n216#2:386\n217#2:388\n66#3:387\n1863#4,2:389\n1863#4,2:391\n1863#4,2:400\n560#5:393\n545#5,6:394\n560#5:402\n545#5,6:403\n*S KotlinDebug\n*F\n+ 1 ClockworkUtils.kt\norg/valkyrienskies/clockwork/util/ClockworkUtils\n*L\n62#1:386\n62#1:388\n66#1:387\n70#1:389,2\n350#1:391,2\n373#1:400,2\n362#1:393\n362#1:394,6\n382#1:402\n382#1:403,6\n*E\n"})
public final class ClockworkUtils {
    @NotNull
    public static final ClockworkUtils INSTANCE = new ClockworkUtils();
    @NotNull
    private static final HashMap<BlockPos, Double> wanderliteNodesToAdd = new HashMap();
    @NotNull
    private static final Long2ObjectMap<Direction> BY_NORMAL;

    private ClockworkUtils() {
    }

    @NotNull
    public final HashMap<BlockPos, Double> getWanderliteNodesToAdd() {
        return wanderliteNodesToAdd;
    }

    @JvmStatic
    public static final void tick(@NotNull ServerLevel level) {
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        HashSet<BlockPos> successfullyAdded = new HashSet<BlockPos>();
        Object $this$forEach$iv = wanderliteNodesToAdd;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            BlockPos pos = (BlockPos)entry.getKey();
            double force = ((Number)entry.getValue()).doubleValue();
            LoadedServerShip ship = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)level, (Vec3i)((Vec3i)new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
            if (ship == null) continue;
            BlockState blockState = level.m_8055_(pos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Double d = MassDatapackResolver.INSTANCE.getBlockStateMass(blockState);
            if (d == null) continue;
            double weight = d;
            AttachmentHolder $this$getAttachment$iv = (AttachmentHolder)ship;
            boolean $i$f$getAttachment = false;
            WanderShipControl wanderShipControl = (WanderShipControl)$this$getAttachment$iv.getAttachment(WanderShipControl.class);
            if (wanderShipControl == null) continue;
            wanderShipControl.addBlock(pos, weight);
            successfullyAdded.add(pos);
        }
        $this$forEach$iv = successfullyAdded;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            wanderliteNodesToAdd.remove(it);
        }
    }

    @NotNull
    public final DuctNodePos getDuctNodePos(@NotNull BlockPos blockPos, @Nullable Level level) {
        INodeBlockEntity be;
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (level == null) {
            return new DuctNodePos((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), null, 8, null);
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        INodeBlockEntity iNodeBlockEntity = be = blockEntity instanceof INodeBlockEntity ? (INodeBlockEntity)blockEntity : null;
        if (iNodeBlockEntity != null) {
            return iNodeBlockEntity.getDuctNodePosition();
        }
        double d = blockPos.m_123341_();
        double d2 = blockPos.m_123342_();
        double d3 = blockPos.m_123343_();
        ResourceLocation resourceLocation = level.m_46472_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        return new DuctNodePos(d, d2, d3, resourceLocation);
    }

    @JvmStatic
    @NotNull
    public static final ListTag writeVec3(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        ListTag tag = new ListTag();
        tag.add((Object)DoubleTag.m_128500_((double)vec.f_82479_));
        tag.add((Object)DoubleTag.m_128500_((double)vec.f_82480_));
        tag.add((Object)DoubleTag.m_128500_((double)vec.f_82481_));
        return tag;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 readVec3(@NotNull ListTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new Vec3(tag.m_128772_(0), tag.m_128772_(1), tag.m_128772_(2));
    }

    @NotNull
    public final Direction fromNormal(int x, int y, int z) {
        Object object = BY_NORMAL.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        return (Direction)object;
    }

    @NotNull
    public final ListTag writeAABBi(@NotNull AABBic bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        ListTag bbtag = new ListTag();
        bbtag.add((Object)FloatTag.m_128566_((float)bb.minX()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.minY()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.minZ()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.maxX()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.maxY()));
        bbtag.add((Object)FloatTag.m_128566_((float)bb.maxZ()));
        return bbtag;
    }

    @Nullable
    public final AABBic readAABBi(@Nullable ListTag bbtag) {
        if (bbtag == null || bbtag.isEmpty()) {
            return null;
        }
        return (AABBic)new AABBi((int)bbtag.m_128775_(0), (int)bbtag.m_128775_(1), (int)bbtag.m_128775_(2), (int)bbtag.m_128775_(3), (int)bbtag.m_128775_(4), (int)bbtag.m_128775_(5));
    }

    @NotNull
    public final ListTag writeVector3i(@NotNull Vector3ic vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        ListTag tag = new ListTag();
        tag.add((Object)IntTag.m_128679_((int)vec.x()));
        tag.add((Object)IntTag.m_128679_((int)vec.y()));
        tag.add((Object)IntTag.m_128679_((int)vec.z()));
        return tag;
    }

    @NotNull
    public final Vector3ic readVector3i(@NotNull ListTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (Vector3ic)new Vector3i(tag.m_128763_(0), tag.m_128763_(1), tag.m_128763_(2));
    }

    @NotNull
    public final Vector3ic readVector3i(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return (Vector3ic)new Vector3i(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Nullable
    public final Vector3d getVector3d(@NotNull CompoundTag $this$getVector3d, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$getVector3d, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return !$this$getVector3d.m_128441_(prefix + "x") || !$this$getVector3d.m_128441_(prefix + "y") || !$this$getVector3d.m_128441_(prefix + "z") ? null : new Vector3d($this$getVector3d.m_128459_(prefix + "x"), $this$getVector3d.m_128459_(prefix + "y"), $this$getVector3d.m_128459_(prefix + "z"));
    }

    public final void writeVector3i(@NotNull FriendlyByteBuf buf, @NotNull Vector3ic vector3f) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"vector3f");
        buf.writeInt(vector3f.x());
        buf.writeInt(vector3f.y());
        buf.writeInt(vector3f.z());
    }

    @NotNull
    public final SelectedAreaToolkit loadArea(@Nullable CompoundTag nbt) {
        SelectedAreaToolkit toolKit = new SelectedAreaToolkit();
        if (nbt != null) {
            byte[] nb = nbt.m_128463_(ClockworkConstants.Nbt.INSTANCE.getSELECTED_DATA());
            try {
                Object object = VSJacksonUtil.INSTANCE.getDefaultMapper().readValue(nb, SelectedAreaToolkit.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                toolKit.overwriteFrom((SelectedAreaToolkit)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return toolKit;
    }

    @NotNull
    public final CompoundTag saveArea(@NotNull CompoundTag nbt, @Nullable SelectedAreaToolkit area) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        try {
            nbt.m_128382_(ClockworkConstants.Nbt.INSTANCE.getSELECTED_DATA(), VSJacksonUtil.INSTANCE.getDefaultMapper().writeValueAsBytes((Object)area));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return nbt;
    }

    @NotNull
    public final Pair<HashMap<GasType, Double>, Double> retrieveGasInfoFromPocket(@NotNull Vector3ic pos, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        HashMap gasMap = new HashMap();
        for (GasType type : GasTypeRegistry.INSTANCE.getGAS_TYPES().values()) {
            DoubleComponentAugmentation key = ClockworkAugmentations.INSTANCE.getComponentAugmentation("gas/" + type.getResourceLocation());
            double gas = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAirComponentAugmentation(key, pos.x(), pos.y(), pos.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            if (Double.isNaN(gas) || gas < 1.0E-4) continue;
            Double d = gas;
            ((Map)gasMap).put(type, d);
        }
        double heatEnergy = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAirComponentAugmentation(ClockworkAugmentations.INSTANCE.getComponentAugmentation("heatEnergy"), pos.x(), pos.y(), pos.z(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        return new Pair(gasMap, (Object)heatEnergy);
    }

    @NotNull
    public final Vector3d getRealPos(@Nullable Level level, @NotNull BlockPos blockPos) {
        Ship ship;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
                ship = ValkyrienSkies.api().getShipManagingBlock(level, blockPos);
                if (ship == null) break block2;
                Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos)).add(0.5, 0.5, 0.5);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
                if ((ship = ValkyrienSkies.positionToWorld((Ship)ship, (Vector3d)vector3d)) != null) break block3;
            }
            Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos)).add(0.5, 0.5, 0.5);
            ship = vector3d;
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        }
        return ship;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated. Replaced with proper implementation in VS Core.")
    @NotNull
    public final HashMap<Vector3i, Long> getAirComponentsInChunkClaim(@NotNull ChunkClaim claim, @NotNull ServerLevel level, @NotNull DoubleComponentAugmentation referenceKey) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)claim, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)referenceKey, (String)"referenceKey");
        HashMap map = new HashMap();
        Iterable $this$forEach$iv = ServerShipWorld.getFromEachAirComponentRoot$default((ServerShipWorld)((ServerShipWorld)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level)), (DoubleComponentAugmentation)referenceKey, (String)VSGameUtilsKt.getDimensionId((Level)((Level)level)), null, (int)4, null).keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long l;
            Triple pos = (Triple)element$iv;
            boolean bl = false;
            if (!claim.contains(MathFunctions.INSTANCE.chunkPos((Triple<Integer, Integer, Integer>)pos).f_45578_, MathFunctions.INSTANCE.chunkPos((Triple<Integer, Integer, Integer>)pos).f_45579_)) continue;
            Map map2 = map;
            Vector3i vector3i = MathFunctions.INSTANCE.toVector3i((Triple<Integer, Integer, Integer>)pos);
            try {
                l = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAirComponentSize(((Number)pos.getFirst()).intValue(), ((Number)pos.getSecond()).intValue(), ((Number)pos.getThird()).intValue(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            }
            catch (IllegalArgumentException e) {
                l = -1L;
            }
            Long l2 = l;
            map2.put(vector3i, l2);
            Long l3 = (Long)map.get(MathFunctions.INSTANCE.toVector3i((Triple<Integer, Integer, Integer>)pos));
            long l4 = -1L;
            if (l3 == null || l3 != l4) continue;
            ClockworkMod.INSTANCE.getLOGGER().warn("Failed to get air component size at " + pos);
        }
        Map $this$filterNot$iv = map;
        boolean $i$f$filterNot = false;
        Map map3 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (((Number)it.getValue()).longValue() == -1L) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map4 = destination$iv$iv;
        return new HashMap<Vector3i, Long>(map4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Deprecated. Replaced with proper implementation in VS Core.")
    @NotNull
    public final HashMap<Vector3i, Long> getSolidComponentsInChunkClaim(@NotNull ChunkClaim claim, @NotNull ServerLevel level, @NotNull DoubleComponentAugmentation referenceKey) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)claim, (String)"claim");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)referenceKey, (String)"referenceKey");
        HashMap map = new HashMap();
        Iterable $this$forEach$iv = ServerShipWorld.getFromEachSolidComponentRoot$default((ServerShipWorld)((ServerShipWorld)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level)), (DoubleComponentAugmentation)referenceKey, (String)VSGameUtilsKt.getDimensionId((Level)((Level)level)), null, (int)4, null).keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long l;
            Triple pos = (Triple)element$iv;
            boolean bl = false;
            if (!claim.contains(MathFunctions.INSTANCE.chunkPos((Triple<Integer, Integer, Integer>)pos).f_45578_, MathFunctions.INSTANCE.chunkPos((Triple<Integer, Integer, Integer>)pos).f_45579_)) continue;
            Map map2 = map;
            Vector3i vector3i = MathFunctions.INSTANCE.toVector3i((Triple<Integer, Integer, Integer>)pos);
            try {
                l = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getSolidComponentSize(((Number)pos.getFirst()).intValue(), ((Number)pos.getSecond()).intValue(), ((Number)pos.getThird()).intValue(), VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            }
            catch (IllegalArgumentException e) {
                l = -1L;
            }
            Long l2 = l;
            map2.put(vector3i, l2);
        }
        Map $this$filterNot$iv = map;
        boolean $i$f$filterNot = false;
        Map map3 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (((Number)it.getValue()).longValue() == -1L) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map4 = destination$iv$iv;
        return new HashMap<Vector3i, Long>(map4);
    }

    private static final Long BY_NORMAL$lambda$2(Direction direction) {
        return new BlockPos(direction.m_122436_()).m_121878_();
    }

    private static final Long BY_NORMAL$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0);
    }

    private static final Direction BY_NORMAL$lambda$4(Direction direction) {
        return direction;
    }

    private static final Direction BY_NORMAL$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Direction)$tmp0.invoke(p0);
    }

    private static final Direction BY_NORMAL$lambda$6(Direction direction, Direction direction2) {
        throw new IllegalArgumentException("Duplicate keys");
    }

    private static final Long2ObjectOpenHashMap BY_NORMAL$lambda$7() {
        return new Long2ObjectOpenHashMap();
    }

    static {
        Long2ObjectOpenHashMap long2ObjectOpenHashMap = Arrays.stream(Direction.values()).collect(Collectors.toMap(arg_0 -> ClockworkUtils.BY_NORMAL$lambda$3(ClockworkUtils::BY_NORMAL$lambda$2, arg_0), arg_0 -> ClockworkUtils.BY_NORMAL$lambda$5(ClockworkUtils::BY_NORMAL$lambda$4, arg_0), ClockworkUtils::BY_NORMAL$lambda$6, ClockworkUtils::BY_NORMAL$lambda$7));
        Intrinsics.checkNotNullExpressionValue((Object)long2ObjectOpenHashMap, (String)"collect(...)");
        BY_NORMAL = (Long2ObjectMap)long2ObjectOpenHashMap;
    }
}

