/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.util.AerodynamicUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u000b\u001a\u00020\n2\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/valkyrienskies/clockwork/util/AtmosphereParametersResolver;", "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;", "", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/google/gson/JsonElement;", "objects", "Lnet/minecraft/server/packs/resources/ResourceManager;", "resourceManager", "Lnet/minecraft/util/profiling/ProfilerFiller;", "profiler", "", "apply", "(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V", "element", "", "", "Lorg/valkyrienskies/clockwork/util/AerodynamicUtils$Parameters;", "map", "parse", "(Lcom/google/gson/JsonElement;Ljava/util/Map;)V", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nAerodynamicUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AerodynamicUtils.kt\norg/valkyrienskies/clockwork/util/AtmosphereParametersResolver\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,577:1\n216#2:578\n217#2:581\n1863#3,2:579\n381#4,7:582\n*S KotlinDebug\n*F\n+ 1 AerodynamicUtils.kt\norg/valkyrienskies/clockwork/util/AtmosphereParametersResolver\n*L\n27#1:578\n27#1:581\n31#1:579,2\n50#1:582,7\n*E\n"})
public final class AtmosphereParametersResolver
extends SimpleJsonResourceReloadListener {
    @NotNull
    public static final AtmosphereParametersResolver INSTANCE = new AtmosphereParametersResolver();

    private AtmosphereParametersResolver() {
        super(new Gson(), "atmosphere_parameters");
    }

    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> objects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        HashMap<String, AerodynamicUtils.Parameters> temp = new HashMap<String, AerodynamicUtils.Parameters>();
        Map<ResourceLocation, ? extends JsonElement> $this$forEach$iv = objects;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, ? extends JsonElement> element$iv;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation key = entry.getKey();
            JsonElement value = entry.getValue();
            if (key == null || value == null) continue;
            try {
                if (value.isJsonArray()) {
                    JsonArray jsonArray = value.getAsJsonArray();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                    Iterable $this$forEach$iv2 = (Iterable)jsonArray;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        JsonElement it = (JsonElement)element$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        INSTANCE.parse(it, (Map<String, AerodynamicUtils.Parameters>)temp);
                    }
                    continue;
                }
                if (value.isJsonObject()) {
                    INSTANCE.parse(value, (Map<String, AerodynamicUtils.Parameters>)temp);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                ClockworkMod.INSTANCE.getLOGGER().error(ExceptionsKt.stackTraceToString((Throwable)e));
            }
        }
        AerodynamicUtils.INSTANCE.setDimensionMap(temp);
    }

    private final void parse(JsonElement element, Map<String, AerodynamicUtils.Parameters> map) {
        AerodynamicUtils.Parameters parameters;
        AerodynamicUtils.Parameters parameters2;
        JsonElement jsonElement = element.getAsJsonObject().get("maxYPos");
        if (jsonElement == null) {
            throw new NoSuchElementException("Parameter \"maxYPos\" wasn't filled");
        }
        double maxYPos = jsonElement.getAsDouble();
        JsonElement jsonElement2 = element.getAsJsonObject().get("seaLevel");
        if (jsonElement2 == null) {
            throw new NoSuchElementException("Parameter \"seaLevel\" wasn't filled");
        }
        double seaLevel = jsonElement2.getAsDouble();
        Object object = element.getAsJsonObject().get("dimensionId");
        if (object == null || (object = object.getAsString()) == null) {
            throw new NoSuchElementException("Parameter \"dimensionId\" wasn't filled");
        }
        Object dimensionId = object;
        JsonElement jsonElement3 = element.getAsJsonObject().get("priority");
        int priority = jsonElement3 != null ? jsonElement3.getAsInt() : 0;
        Map<String, AerodynamicUtils.Parameters> $this$getOrPut$iv = map;
        boolean $i$f$getOrPut = false;
        AerodynamicUtils.Parameters value$iv = $this$getOrPut$iv.get(dimensionId);
        if (value$iv == null) {
            boolean bl = false;
            AerodynamicUtils.Parameters answer$iv = new AerodynamicUtils.Parameters(maxYPos, seaLevel, priority);
            $this$getOrPut$iv.put((String)dimensionId, answer$iv);
            parameters2 = answer$iv;
        } else {
            parameters2 = value$iv;
        }
        AerodynamicUtils.Parameters it = parameters = parameters2;
        boolean bl = false;
        if (it.getPriority() < priority) {
            map.put((String)dimensionId, new AerodynamicUtils.Parameters(maxYPos, seaLevel, priority));
        }
    }
}

