/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.platform.forge;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkParticles;
import org.valkyrienskies.clockwork.forge.util.DuctStatsForge;
import org.valkyrienskies.clockwork.util.gui.DuctStats;

public class PlatformUtilsImpl {
    public static void getEnvExecutor(Supplier<Runnable> toRun) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, toRun);
    }

    public static <D extends ParticleOptions> void registerParticleOnPlatform(ClockworkParticles.ParticleEntry<D> particleEntry, @Nullable Object event) {
        if (event instanceof RegisterParticleProvidersEvent) {
            RegisterParticleProvidersEvent pEvent = (RegisterParticleProvidersEvent)event;
            particleEntry.typeFactory.get().register(particleEntry.object, pEvent);
            ClockworkMod.INSTANCE.getLOGGER().info("Registered particle factory for " + particleEntry.name + " on Forge");
        }
    }

    public static double getReachDistance(Player player) {
        return player.getEntityReach();
    }

    public static Packet<?> createExtraDataSpawnPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static CompoundTag getExtraData(SmartBlockEntity be) {
        return be.getPersistentData();
    }

    public static CreativeModeTab getCreativeTab() {
        return CreativeModeTab.builder().m_257941_((Component)Component.m_237110_((String)"vs_clockwork:creative_mode_tab", (Object[])new Object[]{"VS: Clockwork"})).m_257737_(() -> new ItemStack((ItemLike)ClockworkBlocks.PHYSICS_INFUSER.get())).m_257652_();
    }

    public static DuctStats getDuctStats(Block block) {
        return new DuctStatsForge(block);
    }
}

