/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.platform.forge;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.platform.api.network.C2SCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.CWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ClientNetworkContext;
import org.valkyrienskies.clockwork.platform.api.network.PacketChannel;
import org.valkyrienskies.clockwork.platform.api.network.S2CCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ServerNetworkContext;

public class PacketChannelImpl
implements PacketChannel {
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)ClockworkMod.INSTANCE.getNETWORK_CHANNEL(), () -> "1", "1"::equals, "1"::equals);
    private int id = 0;

    @Override
    public <T extends CWPacket> void registerPacket(Class<T> clazz, Function<FriendlyByteBuf, T> decode) {
        this.channel.registerMessage(this.id++, clazz, CWPacket::write, decode, (packet, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                ((C2SCWPacket)packet).handle(this.serverContext((NetworkEvent.Context)ctx.get()));
            } else {
                ((S2CCWPacket)packet).handle(this.clientContext((NetworkEvent.Context)ctx.get()));
            }
        });
    }

    private ClientNetworkContext clientContext(final NetworkEvent.Context ctx) {
        return new ClientNetworkContext(){

            @Override
            public void handled() {
            }

            @Override
            public void enqueueWork(Runnable runnable) {
                ctx.enqueueWork(runnable);
            }

            @Override
            public void setPacketHandled(boolean value) {
                ctx.setPacketHandled(value);
            }
        };
    }

    private ServerNetworkContext serverContext(final NetworkEvent.Context ctx) {
        return new ServerNetworkContext(){

            @Override
            public void handled() {
            }

            @Override
            public ServerPlayer getSender() {
                return ctx.getSender();
            }

            @Override
            public void enqueueWork(Runnable runnable) {
                ctx.enqueueWork(runnable);
            }

            @Override
            public void setPacketHandled(boolean value) {
                ctx.setPacketHandled(value);
            }
        };
    }

    @Override
    public void sendToNear(Level world, BlockPos pos, int range, S2CCWPacket message) {
        this.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), (Object)message);
    }

    @Override
    public void sendToServer(C2SCWPacket packet) {
        this.channel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    @Override
    public void sendToClientsTracking(S2CCWPacket packet, Entity entity) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)packet);
    }

    @Override
    public void sendToClientsTrackingAndSelf(S2CCWPacket packet, ServerPlayer player) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)packet);
    }

    @Override
    public void sendTo(@NotNull S2CCWPacket packet, @NotNull ServerPlayer player) {
        packet.setPlayer((Player)player);
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }
}

