/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.mixin.content.gas_engine;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.clockwork.content.logistics.gas.engine.GasEngineBlockEntity;

@Mixin(value={SteamEngineBlockEntity.class})
public abstract class MixinSteamEngineBlockEntity
extends SmartBlockEntity {
    @Unique
    public WeakReference<GasEngineBlockEntity> gasSource = new WeakReference<Object>(null);
    @Unique
    private boolean generating = false;
    @Shadow
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    @Shadow
    private float prevAngle;

    public MixinSteamEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private void vs_clockwork$tick(CallbackInfo ci) {
        int conveyedSpeedLevel;
        float efficiency;
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null) {
            return;
        }
        PoweredShaftBlockEntity shaft = this.getShaft();
        GasEngineBlockEntity engine = this.getEngine();
        if (engine == null || shaft == null) {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            if (shaft == null) {
                return;
            }
            if (!shaft.m_58899_().m_121996_((Vec3i)this.f_58858_).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            Direction facing = SteamEngineBlock.getFacing((BlockState)this.m_58900_());
            if (this.f_58857_.m_46749_(this.f_58858_.m_121945_(facing.m_122424_()))) {
                shaft.update(this.f_58858_, 0, 0.0f);
            }
            return;
        }
        BlockState shaftState = shaft.m_58900_();
        Direction.Axis targetAxis = Direction.Axis.X;
        Block block = shaftState.m_60734_();
        if (block instanceof IRotate) {
            IRotate ir = (IRotate)block;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        boolean verticalTarget = targetAxis == Direction.Axis.Y;
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.STEAM_ENGINE.has(blockState)) {
            return;
        }
        Direction facing = SteamEngineBlock.getFacing((BlockState)blockState);
        if (facing.m_122434_() == Direction.Axis.Y) {
            facing = (Direction)blockState.m_61143_((Property)SteamEngineBlock.f_54117_);
        }
        if ((efficiency = engine.getEngineEfficiency()) > 0.0f) {
            this.award(AllAdvancements.STEAM_ENGINE);
        }
        int n = efficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection((float)1.0f, (Direction)facing));
        if (targetAxis == Direction.Axis.Z) {
            conveyedSpeedLevel *= -1;
        }
        if (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            this.movementDirection.setValue(1 - ((WindmillBearingBlockEntity.RotationDirection)this.movementDirection.get()).ordinal());
            conveyedSpeedLevel *= -1;
        }
        shaft.update(this.f_58858_, conveyedSpeedLevel, efficiency);
        if (!this.f_58857_.f_46443_) {
            return;
        }
        if (efficiency > 0.0f) {
            engine.spawnParticles(this.f_58857_, (Vector3dc)new Vector3d((double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.m_58899_().m_123342_() + this.f_58857_.f_46441_.m_188500_(), (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.m_188500_()), (Vector3dc)new Vector3d(0.0, 0.0, 0.0));
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isLoaded(Lnet/minecraft/core/BlockPos;)Z")}, cancellable=true)
    private void cancelShaftUpdate(CallbackInfo ci) {
        if (this.getEngine() != null) {
            ci.cancel();
        }
    }

    @Shadow
    public abstract PoweredShaftBlockEntity getShaft();

    @Shadow
    public abstract FluidTankBlockEntity getTank();

    @Unique
    public GasEngineBlockEntity getEngine() {
        GasEngineBlockEntity engine = (GasEngineBlockEntity)this.gasSource.get();
        if (engine == null || engine.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (engine != null) {
                this.gasSource = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = SteamEngineBlock.getFacing((BlockState)this.m_58900_())).m_122424_()))) instanceof GasEngineBlockEntity) {
                GasEngineBlockEntity engineBe = (GasEngineBlockEntity)be;
                this.gasSource = new WeakReference<GasEngineBlockEntity>(engineBe);
            }
        }
        return engine;
    }
}

