/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities.gyro;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.physicalities.gyro.GyroBlockEntity;
import org.valkyrienskies.clockwork.util.render.RenderUtil;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010%\u001a\u0004\u0018\u00010$\u00a2\u0006\u0004\b&\u0010'JA\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0014JA\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018JA\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006("}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntityRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntity;", "be", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "angle", "coolKineticRotationTransform", "(Lnet/createmod/catnip/render/SuperByteBuffer;Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;FI)Lnet/createmod/catnip/render/SuperByteBuffer;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "renderCore", "(Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;ILnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vb", "renderGyro", "(Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;ILnet/minecraft/world/level/block/state/BlockState;DLcom/mojang/blaze3d/vertex/VertexConsumer;)V", "te", "state", "getRotatedModel", "(Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntity;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/createmod/catnip/render/SuperByteBuffer;", "crystalAngle", "F", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class GyroBlockEntityRenderer
extends KineticBlockEntityRenderer<GyroBlockEntity> {
    private float crystalAngle;

    public GyroBlockEntityRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(@NotNull GyroBlockEntity be, float partialTicks, @NotNull PoseStack ms, @Nullable MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.m_58900_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState blockState2 = blockState;
        float speed = be.getVisualSpeed().getValue(partialTicks) * (float)3 / 10.0f;
        double angle = be.getAngle() + (double)(speed * partialTicks);
        MultiBufferSource multiBufferSource = buffer;
        Intrinsics.checkNotNull((Object)multiBufferSource);
        VertexConsumer vb = multiBufferSource.m_6299_(RenderType.m_110451_());
        Intrinsics.checkNotNull((Object)vb);
        this.renderGyro(be, ms, light, blockState2, angle, vb);
        this.renderCore(be, ms, light, blockState2, buffer, overlay);
        SuperByteBuffer indicator = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getGYRO_BASE(), (BlockState)blockState2);
        indicator.light(light).color(255, 255, 255, 255).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85836_();
        SuperByteBuffer shaf = this.getRotatedModel(be, blockState2);
        this.coolKineticRotationTransform(shaf, be, KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.m_58899_(), (Direction.Axis)Direction.Axis.Y), light).renderInto(ms, vb);
        ms.m_85849_();
    }

    @NotNull
    public final SuperByteBuffer coolKineticRotationTransform(@NotNull SuperByteBuffer buffer, @NotNull KineticBlockEntity be, float angle, int light) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        buffer.light(light);
        buffer.rotateDegrees(-90.0f, Direction.Axis.X);
        buffer.translate(0.0, -1.0, 0.0);
        Direction.AxisDirection axlDir = Direction.AxisDirection.POSITIVE;
        Direction.Axis axl = Direction.Axis.Z;
        buffer.rotateCentered(angle, Direction.m_122390_((Direction.AxisDirection)axlDir, (Direction.Axis)axl));
        return buffer;
    }

    private final void renderCore(GyroBlockEntity be, PoseStack ms, int light, BlockState blockState, MultiBufferSource buffer, int overlay) {
        float interpolatedAngle = be.getInterpolatedCoreAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        TransformData innerData = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(interpolatedAngle, interpolatedAngle, 0.0f));
        TransformData data = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(interpolatedAngle, 0.0f, -interpolatedAngle));
        TransformData outerData = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(interpolatedAngle, 0.0f, -interpolatedAngle));
        PoseStack poseStack = ms;
        Intrinsics.checkNotNull((Object)poseStack);
        RenderUtil.INSTANCE.renderCubeMatrix(poseStack, buffer, blockState, innerData, data, outerData, 1.5f, light, overlay);
    }

    private final void renderGyro(GyroBlockEntity be, PoseStack ms, int light, BlockState blockState, double angle, VertexConsumer vb) {
        SuperByteBuffer wheel = CachedBuffers.block((BlockState)blockState);
        wheel.translate(0.45, 0.0, 0.45);
        wheel.translate(-0.45, 0.0, -0.45);
        KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)be, (Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.translate(0.0, 1.0, 0.0);
        wheel.renderInto(ms, vb);
    }

    @NotNull
    protected SuperByteBuffer getRotatedModel(@NotNull GyroBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)te, (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)ClockworkPartials.INSTANCE.getPHYS_SHAFT(), (BlockState)state, (Direction)Direction.DOWN);
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }
}

