/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities.gyro;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.physicalities.IClockworkWheelBE;
import org.valkyrienskies.clockwork.content.physicalities.gyro.GyroShipControl;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010E\u001a\b\u0012\u0002\b\u0003\u0018\u00010D\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010G\u001a\u00020F\u00a2\u0006\u0004\bH\u0010IJ\u0015\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010,\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00102\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010-\u001a\u0004\b3\u0010/\"\u0004\b4\u00101R\"\u00106\u001a\u0002058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0016\u0010?\u001a\u0004\u0018\u00010<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0016\u0010C\u001a\u0004\u0018\u00010@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006J"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lorg/valkyrienskies/clockwork/content/physicalities/IClockworkWheelBE;", "", "partialTicks", "getInterpolatedCoreAngle", "(F)F", "", "tick", "()V", "Lnet/minecraft/world/level/Level;", "worldIn", "Lnet/minecraft/core/BlockPos;", "pos", "updatePower", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "Ljava/awt/Point;", "redstonePower", "Ljava/awt/Point;", "getRedstonePower", "()Ljava/awt/Point;", "setRedstonePower", "(Ljava/awt/Point;)V", "Lnet/createmod/catnip/animation/LerpedFloat;", "visualSpeed", "Lnet/createmod/catnip/animation/LerpedFloat;", "getVisualSpeed", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setVisualSpeed", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "", "angle", "D", "getAngle", "()D", "setAngle", "(D)V", "coreAngle", "F", "getCoreAngle", "()F", "setCoreAngle", "(F)V", "previousCoreAngle", "getPreviousCoreAngle", "setPreviousCoreAngle", "Lorg/joml/Vector3d;", "shipUpVec", "Lorg/joml/Vector3d;", "getShipUpVec", "()Lorg/joml/Vector3d;", "setShipUpVec", "(Lorg/joml/Vector3d;)V", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "getShip", "()Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl;", "getControl", "()Lorg/valkyrienskies/clockwork/content/physicalities/gyro/GyroShipControl;", "control", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class GyroBlockEntity
extends KineticBlockEntity
implements IClockworkWheelBE {
    @NotNull
    private Point redstonePower;
    @NotNull
    private LerpedFloat visualSpeed;
    private double angle;
    private float coreAngle;
    private float previousCoreAngle;
    @NotNull
    private Vector3d shipUpVec;

    public GyroBlockEntity(@Nullable BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        this.redstonePower = new Point(0, 0);
        LerpedFloat lerpedFloat = LerpedFloat.linear();
        Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"linear(...)");
        this.visualSpeed = lerpedFloat;
        this.shipUpVec = new Vector3d(0.0, 1.0, 0.0);
    }

    @NotNull
    public final Point getRedstonePower() {
        return this.redstonePower;
    }

    public final void setRedstonePower(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
        this.redstonePower = point;
    }

    @Override
    @NotNull
    public LerpedFloat getVisualSpeed() {
        return this.visualSpeed;
    }

    @Override
    public void setVisualSpeed(@NotNull LerpedFloat lerpedFloat) {
        Intrinsics.checkNotNullParameter((Object)lerpedFloat, (String)"<set-?>");
        this.visualSpeed = lerpedFloat;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double d) {
        this.angle = d;
    }

    public final float getCoreAngle() {
        return this.coreAngle;
    }

    public final void setCoreAngle(float f) {
        this.coreAngle = f;
    }

    public final float getPreviousCoreAngle() {
        return this.previousCoreAngle;
    }

    public final void setPreviousCoreAngle(float f) {
        this.previousCoreAngle = f;
    }

    @NotNull
    public final Vector3d getShipUpVec() {
        return this.shipUpVec;
    }

    public final void setShipUpVec(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.shipUpVec = vector3d;
    }

    private final LoadedServerShip getShip() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
    }

    private final GyroShipControl getControl() {
        LoadedServerShip loadedServerShip = this.getShip();
        return loadedServerShip != null ? (GyroShipControl)loadedServerShip.getAttachment(GyroShipControl.class) : null;
    }

    public final float getInterpolatedCoreAngle(float partialTicks) {
        this.previousCoreAngle = this.coreAngle;
        float f = this.coreAngle;
        this.coreAngle = f + 1.0f;
        if (this.coreAngle == 360.0f) {
            this.coreAngle = 0.0f;
        }
        return Mth.m_14179_((float)partialTicks, (float)this.coreAngle, (float)(this.coreAngle + 4.0f));
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        this.updatePower(level, blockPos);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        up.rotateX((double)this.redstonePower.x / 15.0 * Math.PI / (double)2);
        up.rotateZ((double)this.redstonePower.y / 15.0 * Math.PI / (double)2);
        this.shipUpVec = up;
        if (this.f_58857_ instanceof ServerLevel) {
            GyroShipControl gyroShipControl = this.getControl();
            if (gyroShipControl != null) {
                gyroShipControl.setShip$clockwork(this.getShip());
            }
            GyroShipControl gyroShipControl2 = this.getControl();
            if (gyroShipControl2 != null) {
                gyroShipControl2.setSpeed$clockwork(this.getSpeed());
            }
            GyroShipControl gyroShipControl3 = this.getControl();
            if (gyroShipControl3 != null) {
                gyroShipControl3.pointTowards((Vector3dc)this.shipUpVec, 1.0f);
            }
        }
        float targetSpeed = this.getSpeed();
        this.getVisualSpeed().updateChaseTarget(targetSpeed);
        this.getVisualSpeed().tickChaser();
        this.setAngle(this.getAngle() + (double)(this.getVisualSpeed().getValue() * (float)3 / 10.0f));
        this.setAngle(this.getAngle() % (double)360.0f);
    }

    private final void updatePower(Level worldIn, BlockPos pos) {
        int powerZP = worldIn.m_277185_(pos.m_121945_(Direction.SOUTH), Direction.SOUTH);
        int powerZN = worldIn.m_277185_(pos.m_121945_(Direction.NORTH), Direction.NORTH);
        int powerXP = worldIn.m_277185_(pos.m_121945_(Direction.EAST), Direction.EAST);
        int powerXN = worldIn.m_277185_(pos.m_121945_(Direction.WEST), Direction.WEST);
        this.redstonePower = new Point(powerZN - powerZP, powerXN - powerXP);
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.write(compound, clientPacket);
        compound.m_128347_("X", this.shipUpVec.x());
        compound.m_128347_("Y", this.shipUpVec.y());
        compound.m_128347_("Z", this.shipUpVec.z());
        compound.m_128405_("PowerX", this.redstonePower.x);
        compound.m_128405_("PowerZ", this.redstonePower.y);
    }

    public void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (compound.m_128441_("X")) {
            this.shipUpVec = new Vector3d(compound.m_128459_("X"), compound.m_128459_("Y"), compound.m_128459_("Z"));
        }
        if (compound.m_128441_("PowerX")) {
            this.redstonePower = new Point(compound.m_128451_("PowerX"), compound.m_128451_("PowerXZ"));
        }
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.getVisualSpeed().chase((double)this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
    }
}

