/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.physicalities.extendon;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkGasses;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.util.AerodynamicUtils;
import org.valkyrienskies.clockwork.util.GetGTFAKt;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.clockwork.util.universal_joint.IUniversalJoint;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.internal.joints.VSD6Joint;
import org.valkyrienskies.core.internal.joints.VSDistanceJoint;
import org.valkyrienskies.core.internal.joints.VSJoint;
import org.valkyrienskies.core.internal.joints.VSJointAndId;
import org.valkyrienskies.core.internal.joints.VSJointPose;
import org.valkyrienskies.kelvin.api.ConnectionType;
import org.valkyrienskies.kelvin.api.DuctEdge;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.api.edges.PipeDuctEdge;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.DuctNodeInfo;
import org.valkyrienskies.kelvin.util.KelvinExtensions;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.GameToPhysicsAdapter;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 r2\u00020\u00012\u00020\u0002:\u0001rB%\u0012\f\u0010m\u001a\b\u0012\u0002\b\u0003\u0018\u00010l\u0012\u0006\u00104\u001a\u000203\u0012\u0006\u0010o\u001a\u00020n\u00a2\u0006\u0004\bp\u0010qJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0005J\u001f\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0005J\u0011\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0005J\u000f\u0010\u0019\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0005J\u0015\u0010\u001c\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\"\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010$\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b$\u0010#J%\u0010(\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u00062\u0006\u0010'\u001a\u00020 H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J#\u0010-\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u00062\u0006\u0010'\u001a\u00020 \u00a2\u0006\u0004\b-\u0010)R$\u0010.\u001a\u0004\u0018\u00010\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u0010\rR\"\u00104\u001a\u0002038\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R$\u0010A\u001a\u0004\u0018\u00010@8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR$\u0010H\u001a\u0004\u0018\u00010G8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR$\u0010O\u001a\u0004\u0018\u00010N8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR$\u0010V\u001a\u0004\u0018\u00010U8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R$\u0010\\\u001a\u0004\u0018\u00010N8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010P\u001a\u0004\b]\u0010R\"\u0004\b^\u0010TR\"\u0010_\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010`\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR*\u0010f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bf\u0010g\u001a\u0004\bh\u0010i\"\u0004\bj\u0010k\u00a8\u0006s"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lorg/valkyrienskies/clockwork/util/universal_joint/IUniversalJoint;", "", "tick", "()V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "other", "connectTo", "(Lorg/valkyrienskies/clockwork/util/universal_joint/IUniversalJoint;)V", "disconnect", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "nodeA", "nodeB", "createEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)V", "removeEdge", "Lnet/minecraft/world/phys/AABB;", "getRenderBoundingBox", "()Lnet/minecraft/world/phys/AABB;", "createJoint", "removeJoint", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "getShipID", "()Ljava/lang/Long;", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "Lnet/minecraft/network/chat/Component;", "tooltip", "isPlayerSneaking", "heatableGoggleTooltip", "(Ljava/util/List;Z)Z", "Lnet/minecraft/world/item/ItemStack;", "getConnectionItem", "()Lnet/minecraft/world/item/ItemStack;", "safeHeatableGoggleTooltip", "connectedJoint", "Lorg/valkyrienskies/clockwork/util/universal_joint/IUniversalJoint;", "getConnectedJoint", "()Lorg/valkyrienskies/clockwork/util/universal_joint/IUniversalJoint;", "setConnectedJoint", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "setPos", "(Lnet/minecraft/core/BlockPos;)V", "connectedBe", "Lorg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity;", "getConnectedBe", "()Lorg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity;", "setConnectedBe", "(Lorg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity;)V", "Lorg/valkyrienskies/kelvin/api/DuctEdge;", "edge", "Lorg/valkyrienskies/kelvin/api/DuctEdge;", "getEdge", "()Lorg/valkyrienskies/kelvin/api/DuctEdge;", "setEdge", "(Lorg/valkyrienskies/kelvin/api/DuctEdge;)V", "Lorg/valkyrienskies/core/internal/joints/VSDistanceJoint;", "distanceJoint", "Lorg/valkyrienskies/core/internal/joints/VSDistanceJoint;", "getDistanceJoint", "()Lorg/valkyrienskies/core/internal/joints/VSDistanceJoint;", "setDistanceJoint", "(Lorg/valkyrienskies/core/internal/joints/VSDistanceJoint;)V", "", "distanceJointId", "Ljava/lang/Integer;", "getDistanceJointId", "()Ljava/lang/Integer;", "setDistanceJointId", "(Ljava/lang/Integer;)V", "Lorg/valkyrienskies/core/internal/joints/VSD6Joint;", "sphericalJoint", "Lorg/valkyrienskies/core/internal/joints/VSD6Joint;", "getSphericalJoint", "()Lorg/valkyrienskies/core/internal/joints/VSD6Joint;", "setSphericalJoint", "(Lorg/valkyrienskies/core/internal/joints/VSD6Joint;)V", "sphericalJointId", "getSphericalJointId", "setSphericalJointId", "main", "Z", "getMain", "()Z", "setMain", "(Z)V", "Lkotlin/Function0;", "loadFn", "Lkotlin/jvm/functions/Function0;", "getLoadFn", "()Lkotlin/jvm/functions/Function0;", "setLoadFn", "(Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nExtendonBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendonBlockEntity.kt\norg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,421:1\n1062#2:422\n*S KotlinDebug\n*F\n+ 1 ExtendonBlockEntity.kt\norg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity\n*L\n311#1:422\n*E\n"})
public final class ExtendonBlockEntity
extends KNodeBlockEntity
implements IUniversalJoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private IUniversalJoint connectedJoint;
    @NotNull
    private BlockPos pos;
    @Nullable
    private ExtendonBlockEntity connectedBe;
    @Nullable
    private DuctEdge edge;
    @Nullable
    private VSDistanceJoint distanceJoint;
    @Nullable
    private Integer distanceJointId;
    @Nullable
    private VSD6Joint sphericalJoint;
    @Nullable
    private Integer sphericalJointId;
    private boolean main;
    @Nullable
    private Function0<Unit> loadFn;

    public ExtendonBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.pos = pos;
    }

    @Override
    @Nullable
    public IUniversalJoint getConnectedJoint() {
        return this.connectedJoint;
    }

    @Override
    public void setConnectedJoint(@Nullable IUniversalJoint iUniversalJoint) {
        this.connectedJoint = iUniversalJoint;
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.pos = blockPos;
    }

    @Nullable
    public final ExtendonBlockEntity getConnectedBe() {
        return this.connectedBe;
    }

    public final void setConnectedBe(@Nullable ExtendonBlockEntity extendonBlockEntity) {
        this.connectedBe = extendonBlockEntity;
    }

    @Nullable
    public final DuctEdge getEdge() {
        return this.edge;
    }

    public final void setEdge(@Nullable DuctEdge ductEdge) {
        this.edge = ductEdge;
    }

    @Nullable
    public final VSDistanceJoint getDistanceJoint() {
        return this.distanceJoint;
    }

    public final void setDistanceJoint(@Nullable VSDistanceJoint vSDistanceJoint) {
        this.distanceJoint = vSDistanceJoint;
    }

    @Nullable
    public final Integer getDistanceJointId() {
        return this.distanceJointId;
    }

    public final void setDistanceJointId(@Nullable Integer n) {
        this.distanceJointId = n;
    }

    @Nullable
    public final VSD6Joint getSphericalJoint() {
        return this.sphericalJoint;
    }

    public final void setSphericalJoint(@Nullable VSD6Joint vSD6Joint) {
        this.sphericalJoint = vSD6Joint;
    }

    @Nullable
    public final Integer getSphericalJointId() {
        return this.sphericalJointId;
    }

    public final void setSphericalJointId(@Nullable Integer n) {
        this.sphericalJointId = n;
    }

    public final boolean getMain() {
        return this.main;
    }

    public final void setMain(boolean bl) {
        this.main = bl;
    }

    @Nullable
    public final Function0<Unit> getLoadFn() {
        return this.loadFn;
    }

    public final void setLoadFn(@Nullable Function0<Unit> function0) {
        this.loadFn = function0;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        Function0<Unit> function0 = this.loadFn;
        if (function0 != null) {
            Function0<Unit> function02;
            Function0<Unit> it = function02 = function0;
            boolean bl = false;
            it.invoke();
            this.loadFn = null;
        }
        if (this.connectedBe == null || this.getConnectedJoint() == null || this.distanceJoint == null || this.distanceJointId == null || !this.main) {
            return;
        }
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level2;
        VSDistanceJoint vSDistanceJoint = this.distanceJoint;
        Intrinsics.checkNotNull((Object)vSDistanceJoint);
        Float f = vSDistanceJoint.getMinDistance();
        Intrinsics.checkNotNull((Object)f);
        float previousDistance = f.floatValue();
        DuctNetwork ductNetwork = (DuctNetwork)kelvin;
        DuctNodePos ductNodePos = this.getDuctNodePosition();
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        float f2 = Companion.gasToDistance(ductNetwork, ductNodePos, VSGameUtilsKt.getDimensionId((Level)level3));
        DuctNetwork ductNetwork2 = (DuctNetwork)kelvin;
        ExtendonBlockEntity extendonBlockEntity = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity);
        DuctNodePos ductNodePos2 = extendonBlockEntity.getDuctNodePosition();
        Level level4 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level4);
        float distance = Math.max(1.5f, f2 + Companion.gasToDistance(ductNetwork2, ductNodePos2, VSGameUtilsKt.getDimensionId((Level)level4)));
        if (distance == previousDistance) {
            return;
        }
        if (Math.abs(distance - previousDistance) < 0.01f) {
            return;
        }
        float lerpedDistance = previousDistance + (distance - previousDistance) * 0.1f;
        if (Float.isInfinite(lerpedDistance) || Float.isNaN(lerpedDistance)) {
            lerpedDistance = previousDistance;
        }
        if (Math.abs(lerpedDistance - distance) < 0.001f) {
            lerpedDistance = distance;
        }
        Integer n = this.distanceJointId;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        VSDistanceJoint vSDistanceJoint2 = this.distanceJoint;
        Intrinsics.checkNotNull((Object)vSDistanceJoint2);
        Long l = vSDistanceJoint2.getShipId0();
        VSDistanceJoint vSDistanceJoint3 = this.distanceJoint;
        Intrinsics.checkNotNull((Object)vSDistanceJoint3);
        VSJointPose vSJointPose = vSDistanceJoint3.getPose0();
        VSDistanceJoint vSDistanceJoint4 = this.distanceJoint;
        Intrinsics.checkNotNull((Object)vSDistanceJoint4);
        Long l2 = vSDistanceJoint4.getShipId1();
        VSDistanceJoint vSDistanceJoint5 = this.distanceJoint;
        Intrinsics.checkNotNull((Object)vSDistanceJoint5);
        VSJointAndId tempJoint = new VSJointAndId(n2, (VSJoint)new VSDistanceJoint(l, vSJointPose, l2, vSDistanceJoint5.getPose1(), null, 0.0, Float.valueOf(lerpedDistance), Float.valueOf(lerpedDistance), null, null, null, 1840, null));
        GameToPhysicsAdapter gameToPhysicsAdapter = GetGTFAKt.getGtpa(serverLevel);
        Integer n3 = this.distanceJointId;
        Intrinsics.checkNotNull((Object)n3);
        GetGTFAKt.updateJoint(gameToPhysicsAdapter, n3, tempJoint.getJoint());
        VSJoint vSJoint = tempJoint.getJoint();
        Intrinsics.checkNotNull((Object)vSJoint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.internal.joints.VSDistanceJoint");
        this.distanceJoint = (VSDistanceJoint)vSJoint;
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public void connectTo(@NotNull IUniversalJoint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getConnectedJoint() != null) {
            return;
        }
        ExtendonBlockEntity extendonBlockEntity = other instanceof ExtendonBlockEntity ? (ExtendonBlockEntity)other : null;
        if (extendonBlockEntity == null) {
            return;
        }
        ExtendonBlockEntity extendonBlockEntity2 = this.connectedBe = extendonBlockEntity;
        Intrinsics.checkNotNull((Object)extendonBlockEntity2);
        if (extendonBlockEntity2.edge != null) {
            ExtendonBlockEntity extendonBlockEntity3 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity3);
            this.edge = extendonBlockEntity3.edge;
        } else {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            DuctNodePos ductNodePos = KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
            BlockPos blockPos2 = ((ExtendonBlockEntity)other).getPos();
            ExtendonBlockEntity extendonBlockEntity4 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity4);
            Level level2 = extendonBlockEntity4.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            ResourceLocation resourceLocation2 = level2.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
            this.createEdge(ductNodePos, KelvinExtensions.INSTANCE.toDuctNodePos(blockPos2, resourceLocation2));
        }
        ExtendonBlockEntity extendonBlockEntity5 = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity5);
        if (extendonBlockEntity5.distanceJoint != null) {
            ExtendonBlockEntity extendonBlockEntity6 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity6);
            this.distanceJoint = extendonBlockEntity6.distanceJoint;
            ExtendonBlockEntity extendonBlockEntity7 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity7);
            this.distanceJointId = extendonBlockEntity7.distanceJointId;
            ExtendonBlockEntity extendonBlockEntity8 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity8);
            this.sphericalJoint = extendonBlockEntity8.sphericalJoint;
            ExtendonBlockEntity extendonBlockEntity9 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity9);
            this.sphericalJointId = extendonBlockEntity9.sphericalJointId;
            this.main = false;
        } else {
            this.createJoint();
        }
        Level level = this.f_58857_;
        if (level != null) {
            level.m_5594_(null, this.m_58899_(), ClockworkSounds.INSTANCE.getHOSE_ATTACH().getMainEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        IUniversalJoint.super.connectTo(other);
        this.sendData();
    }

    @Override
    public void disconnect() {
        if (this.getConnectedJoint() == null) {
            return;
        }
        ExtendonBlockEntity extendonBlockEntity = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity);
        if (extendonBlockEntity.edge == null) {
            this.edge = null;
        } else if (this.edge != null) {
            this.removeEdge();
        }
        ExtendonBlockEntity extendonBlockEntity2 = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity2);
        if (extendonBlockEntity2.distanceJoint == null) {
            this.distanceJoint = null;
            this.distanceJointId = null;
            this.sphericalJoint = null;
            this.sphericalJointId = null;
        } else if (this.distanceJointId != null) {
            this.removeJoint();
        }
        this.connectedBe = null;
        this.main = false;
        Level level = this.f_58857_;
        if (level != null) {
            level.m_5594_(null, this.m_58899_(), ClockworkSounds.INSTANCE.getHOSE_RELEASE().getMainEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        IUniversalJoint.super.disconnect();
        this.sendData();
    }

    private final void createEdge(DuctNodePos nodeA, DuctNodePos nodeB) {
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        ConnectionType connectionType = ConnectionType.PIPE;
        DuctEdge ductEdge = this.edge = (DuctEdge)new PipeDuctEdge(connectionType, nodeA, nodeB, 0.0, 0.0, 0.0, false, 120, null);
        Intrinsics.checkNotNull((Object)ductEdge);
        kelvin.addEdge(nodeA, nodeB, ductEdge);
    }

    private final void removeEdge() {
        DuctNetworkServer kelvin = ClockworkMod.getKelvin();
        DuctEdge ductEdge = this.edge;
        Intrinsics.checkNotNull((Object)ductEdge);
        DuctNodePos ductNodePos = ductEdge.getNodeA();
        DuctEdge ductEdge2 = this.edge;
        Intrinsics.checkNotNull((Object)ductEdge2);
        kelvin.removeEdge(ductNodePos, ductEdge2.getNodeB());
        this.edge = null;
    }

    @Nullable
    public AABB getRenderBoundingBox() {
        return SmartBlockEntity.INFINITE_EXTENT_AABB;
    }

    private final void createJoint() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        if (this.connectedBe == null) {
            throw new IllegalStateException("Null connected block entity");
        }
        Long shipId0 = this.getShipID();
        ExtendonBlockEntity extendonBlockEntity = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity);
        Long shipId1 = extendonBlockEntity.getShipID();
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vector3d pos0 = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos)).add(0.5, 0.5, 0.5);
        ExtendonBlockEntity extendonBlockEntity2 = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity2);
        BlockPos blockPos2 = extendonBlockEntity2.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        Vector3d pos1 = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2)).add(0.5, 0.5, 0.5);
        Comparable comparable = level2.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        Quaterniond quater0 = Companion.getQuaterniond((Direction)comparable);
        ExtendonBlockEntity extendonBlockEntity3 = this.connectedBe;
        Intrinsics.checkNotNull((Object)extendonBlockEntity3);
        Comparable comparable2 = level2.m_8055_(extendonBlockEntity3.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_);
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getValue(...)");
        Quaterniond quater1 = Companion.getQuaterniond((Direction)comparable2);
        Intrinsics.checkNotNull((Object)pos0);
        VSJointPose vSJointPose = new VSJointPose((Vector3dc)pos0, (Quaterniondc)quater0);
        Intrinsics.checkNotNull((Object)pos1);
        VSJointPose vSJointPose2 = new VSJointPose((Vector3dc)pos1, (Quaterniondc)quater1);
        this.distanceJoint = new VSDistanceJoint(shipId0, vSJointPose, shipId1, vSJointPose2, null, 0.0, Float.valueOf(0.5f), Float.valueOf(1000.0f), null, null, Float.valueOf(1000.0f), 816, null);
        GameToPhysicsAdapter gameToPhysicsAdapter = GetGTFAKt.getGtpa(level2);
        VSDistanceJoint vSDistanceJoint = this.distanceJoint;
        Intrinsics.checkNotNull((Object)vSDistanceJoint);
        GameToPhysicsAdapter.addJoint$default((GameToPhysicsAdapter)gameToPhysicsAdapter, (VSJoint)((VSJoint)vSDistanceJoint), (int)0, arg_0 -> ExtendonBlockEntity.createJoint$lambda$1(this, arg_0), (int)2, null);
        VSD6Joint.LimitCone limit = new VSD6Joint.LimitCone(0.7853982f, 0.7853982f, null, null, null, null, 60, null);
        EnumMap motions = new EnumMap(VSD6Joint.D6Axis.class);
        ((Map)motions).put(VSD6Joint.D6Axis.X, VSD6Joint.D6Motion.FREE);
        ((Map)motions).put(VSD6Joint.D6Axis.Y, VSD6Joint.D6Motion.FREE);
        ((Map)motions).put(VSD6Joint.D6Axis.Z, VSD6Joint.D6Motion.FREE);
        ((Map)motions).put(VSD6Joint.D6Axis.TWIST, VSD6Joint.D6Motion.LOCKED);
        ((Map)motions).put(VSD6Joint.D6Axis.SWING1, VSD6Joint.D6Motion.LIMITED);
        ((Map)motions).put(VSD6Joint.D6Axis.SWING2, VSD6Joint.D6Motion.LIMITED);
        VSJointPose vSJointPose3 = new VSJointPose((Vector3dc)pos0, (Quaterniondc)quater0);
        VSJointPose vSJointPose4 = new VSJointPose((Vector3dc)pos1, (Quaterniondc)quater1);
        this.sphericalJoint = new VSD6Joint(shipId0, vSJointPose3, shipId1, vSJointPose4, null, 0.0, motions, null, null, null, limit, null, null, null, null, 31664, null);
        GameToPhysicsAdapter gameToPhysicsAdapter2 = GetGTFAKt.getGtpa(level2);
        VSD6Joint vSD6Joint = this.sphericalJoint;
        Intrinsics.checkNotNull((Object)vSD6Joint);
        GameToPhysicsAdapter.addJoint$default((GameToPhysicsAdapter)gameToPhysicsAdapter2, (VSJoint)((VSJoint)vSD6Joint), (int)0, arg_0 -> ExtendonBlockEntity.createJoint$lambda$2(this, arg_0), (int)2, null);
        this.main = true;
    }

    private final void removeJoint() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        if (this.distanceJointId != null) {
            GameToPhysicsAdapter gameToPhysicsAdapter = GetGTFAKt.getGtpa(level2);
            Integer n = this.distanceJointId;
            Intrinsics.checkNotNull((Object)n);
            gameToPhysicsAdapter.removeJoint(n.intValue());
        }
        if (this.sphericalJointId != null) {
            GameToPhysicsAdapter gameToPhysicsAdapter = GetGTFAKt.getGtpa(level2);
            Integer n = this.sphericalJointId;
            Intrinsics.checkNotNull((Object)n);
            gameToPhysicsAdapter.removeJoint(n.intValue());
        }
        this.distanceJoint = null;
        this.distanceJointId = null;
        this.sphericalJoint = null;
        this.sphericalJointId = null;
        this.main = false;
    }

    @Nullable
    public final Long getShipID() {
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.f_58857_, (BlockPos)blockPos);
        if (ship == null) {
            return -1L;
        }
        return ship.getId();
    }

    @Override
    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (this.connectedBe != null) {
            ExtendonBlockEntity extendonBlockEntity = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity);
            compound.m_128405_("ConnectedPosX", extendonBlockEntity.getPos().m_123341_());
            ExtendonBlockEntity extendonBlockEntity2 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity2);
            compound.m_128405_("ConnectedPosY", extendonBlockEntity2.getPos().m_123342_());
            ExtendonBlockEntity extendonBlockEntity3 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity3);
            compound.m_128405_("ConnectedPosZ", extendonBlockEntity3.getPos().m_123343_());
            compound.m_128379_("IsMain", this.main);
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (compound.m_128441_("ConnectedPosX")) {
            BlockPos bpos = new BlockPos(compound.m_128451_("ConnectedPosX"), compound.m_128451_("ConnectedPosY"), compound.m_128451_("ConnectedPosZ"));
            if (!clientPacket) {
                this.loadFn = () -> ExtendonBlockEntity.read$lambda$4(this, bpos);
            } else {
                Level level = this.f_58857_;
                BlockEntity blockEntity = level != null ? level.m_7702_(new BlockPos(compound.m_128451_("ConnectedPosX"), compound.m_128451_("ConnectedPosY"), compound.m_128451_("ConnectedPosZ"))) : null;
                this.connectedBe = blockEntity instanceof ExtendonBlockEntity ? (ExtendonBlockEntity)blockEntity : null;
                this.setConnectedJoint(this.connectedBe);
                ExtendonBlockEntity extendonBlockEntity = this.connectedBe;
                if (extendonBlockEntity != null) {
                    extendonBlockEntity.setConnectedJoint(this);
                }
                if (this.connectedBe != null) {
                    this.connectedBe.connectedBe = this;
                }
            }
            this.main = compound.m_128471_("IsMain");
        } else {
            this.disconnect();
        }
        super.read(compound, clientPacket);
    }

    @Override
    public boolean heatableGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        boolean bl;
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        boolean og = super.heatableGoggleTooltip(tooltip, isPlayerSneaking);
        MutableComponent mutableComponent = Component.m_237119_();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty(...)");
        tooltip.add((Component)mutableComponent);
        if (this.connectedBe != null) {
            MutableComponent mutableComponent2 = Component.m_237115_((String)"vs_clockwork.hose_port.connected");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            tooltip.add((Component)mutableComponent2);
            Object[] objectArray = new Object[1];
            ExtendonBlockEntity extendonBlockEntity = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity);
            int n = extendonBlockEntity.m_58899_().m_123341_();
            ExtendonBlockEntity extendonBlockEntity2 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity2);
            int n2 = extendonBlockEntity2.m_58899_().m_123342_();
            ExtendonBlockEntity extendonBlockEntity3 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity3);
            objectArray[0] = Component.m_237113_((String)(n + ", " + n2 + ", " + extendonBlockEntity3.m_58899_().m_123343_())).m_130940_(ChatFormatting.AQUA);
            MutableComponent mutableComponent3 = Component.m_237110_((String)"vs_clockwork.hose_port.connected_to", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            tooltip.add((Component)mutableComponent3);
            DuctNetwork kelvin = Minecraft.m_91087_().m_91090_() && Platform.isFabric() ? (DuctNetwork)ClockworkMod.getKelvin() : (DuctNetwork)ClockworkModClient.getKelvin();
            DuctNodePos ductNodePos = this.getDuctNodePosition();
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            float f = Companion.gasToDistance(kelvin, ductNodePos, VSGameUtilsKt.getDimensionId((Level)level));
            ExtendonBlockEntity extendonBlockEntity4 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity4);
            DuctNodePos ductNodePos2 = extendonBlockEntity4.getDuctNodePosition();
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            float currentLength = (float)MathKt.roundToInt((float)(Math.max(1.5f, f + Companion.gasToDistance(kelvin, ductNodePos2, VSGameUtilsKt.getDimensionId((Level)level2))) * 10.0f)) / 10.0f;
            MutableComponent mutableComponent4 = Component.m_237115_((String)"vs_clockwork.extendon.current_length").m_7220_((Component)Component.m_237113_((String)String.valueOf(currentLength)).m_130946_("m").m_130940_(ChatFormatting.YELLOW));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"append(...)");
            tooltip.add((Component)mutableComponent4);
            MutableComponent mutableComponent5 = Component.m_237115_((String)"vs_clockwork.hose_port.other_port_info").m_130940_(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"withStyle(...)");
            tooltip.add((Component)mutableComponent5);
            ExtendonBlockEntity extendonBlockEntity5 = this.connectedBe;
            Intrinsics.checkNotNull((Object)extendonBlockEntity5);
            bl = extendonBlockEntity5.safeHeatableGoggleTooltip(tooltip, isPlayerSneaking);
        } else {
            MutableComponent mutableComponent6 = Component.m_237115_((String)"vs_clockwork.hose_port.disconnected");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"translatable(...)");
            bl = tooltip.add((Component)mutableComponent6);
        }
        boolean other = bl;
        return og || other;
    }

    @Override
    @NotNull
    public ItemStack getConnectionItem() {
        ItemStack itemStack = ClockworkItems.EXTENDON_HOSE.asStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"asStack(...)");
        return itemStack;
    }

    public final boolean safeHeatableGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        DuctNetwork kelvin;
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        boolean found = false;
        DuctNetwork ductNetwork = kelvin = Minecraft.m_91087_().m_91090_() && Platform.isFabric() ? (DuctNetwork)ClockworkMod.getKelvin() : (DuctNetwork)ClockworkModClient.getKelvin();
        if (kelvin.getTemperatureAt(this.getDuctNodePosition()) > 0.0) {
            MutableComponent mutableComponent = Component.m_237113_((String)("Temperature: " + (int)kelvin.getTemperatureAt(this.getDuctNodePosition()) + " K")).m_130940_(ChatFormatting.GOLD);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltip.add((Component)mutableComponent);
            found = true;
        }
        if (kelvin.getNodeInfo().get(this.getDuctNodePosition()) != null) {
            Object v = kelvin.getNodeInfo().get(this.getDuctNodePosition());
            Intrinsics.checkNotNull(v);
            if (((DuctNodeInfo)v).getCurrentEnergy() > 0.0 && isPlayerSneaking) {
                Object v2 = kelvin.getNodeInfo().get(this.getDuctNodePosition());
                Intrinsics.checkNotNull(v2);
                double currentEnergy = ((DuctNodeInfo)v2).getCurrentEnergy();
                if (currentEnergy < 100000.0) {
                    MutableComponent mutableComponent = Component.m_237113_((String)("Thermal Energy: " + MathKt.roundToInt((double)currentEnergy) + " J")).m_130940_(ChatFormatting.RED);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                    v5 = tooltip.add((Component)mutableComponent);
                } else {
                    MutableComponent mutableComponent = Component.m_237113_((String)("Thermal Energy: " + MathKt.roundToInt((double)(currentEnergy / 1000.0)) + " kJ")).m_130940_(ChatFormatting.RED);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                    v5 = tooltip.add((Component)mutableComponent);
                }
            }
        }
        if (kelvin.getPressureAt(this.getDuctNodePosition()) > 0.0) {
            double currentPressure = kelvin.getPressureAt(this.getDuctNodePosition());
            if (currentPressure < 100000.0) {
                MutableComponent mutableComponent = Component.m_237113_((String)("Pressure: " + MathKt.roundToInt((double)currentPressure) + " Pa")).m_130940_(ChatFormatting.BLUE);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                v8 = tooltip.add((Component)mutableComponent);
            } else {
                MutableComponent mutableComponent = Component.m_237113_((String)("Pressure: " + MathKt.roundToInt((double)(currentPressure / 1000.0)) + " kPa")).m_130940_(ChatFormatting.BLUE);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                v8 = tooltip.add((Component)mutableComponent);
            }
            found = true;
        }
        if (!((Map)kelvin.getGasMassAt(this.getDuctNodePosition())).isEmpty()) {
            Set set = kelvin.getGasMassAt(this.getDuctNodePosition()).entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$sortedByDescending$iv = set;
            boolean $i$f$sortedByDescending = false;
            List sortedByAmount = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
                }
            });
            List rows = new ArrayList();
            List finishedComponents = new ArrayList();
            for (Object e : sortedByAmount) {
                MutableComponent nameComponent;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Map.Entry entry = (Map.Entry)e;
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                MutableComponent iconComponent = Component.m_237113_((String)ClockworkGasses.getDisplayCharacterCode((GasType)k)).m_130938_(ExtendonBlockEntity::safeHeatableGoggleTooltip$lambda$6);
                MutableComponent mutableComponent = nameComponent = isPlayerSneaking ? Component.m_237113_((String)(" " + ((GasType)entry.getKey()).getName() + " ")).m_130940_(ChatFormatting.GRAY) : Component.m_237113_((String)" ");
                MutableComponent amtComponent = ((Number)entry.getValue()).doubleValue() > 0.0 && ((Number)entry.getValue()).doubleValue() < 1.0 ? Component.m_237113_((String)(MathKt.roundToInt((double)(((Number)entry.getValue()).doubleValue() * 1000.0)) + "g")) : (((Number)entry.getValue()).doubleValue() >= 1.0 ? Component.m_237113_((String)((double)MathKt.roundToInt((double)(((Number)entry.getValue()).doubleValue() * 1000.0)) / 1000.0 + "kg")) : null);
                if (amtComponent == null) continue;
                MutableComponent finalComponent = Component.m_237119_().m_7220_((Component)iconComponent).m_7220_((Component)nameComponent).m_7220_((Component)amtComponent);
                Intrinsics.checkNotNull((Object)finalComponent);
                finishedComponents.add(finalComponent);
            }
            int num = 0;
            int n = ((Collection)finishedComponents).size() + -1;
            int iconComponent = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
            if (num <= iconComponent) {
                while (true) {
                    boolean bl = num + 1 < finishedComponents.size() ? rows.add(new Pair(finishedComponents.get(num), finishedComponents.get(num + 1))) : rows.add(new Pair(finishedComponents.get(num), (Object)Component.m_237119_()));
                    if (num == iconComponent) break;
                    num += 2;
                }
            }
            for (Pair row : rows) {
                MutableComponent rowComponent = Component.m_237119_().m_7220_((Component)row.getFirst()).m_7220_((Component)Component.m_237113_((String)"  ")).m_7220_((Component)row.getSecond());
                Intrinsics.checkNotNull((Object)rowComponent);
                tooltip.add((Component)rowComponent);
            }
            found = true;
        }
        if (!found) {
            MutableComponent mutableComponent = Component.m_237113_((String)"Connected node is empty.").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            tooltip.add((Component)mutableComponent);
        }
        return found;
    }

    private static final void createJoint$lambda$1(ExtendonBlockEntity this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.distanceJointId = it;
    }

    private static final void createJoint$lambda$2(ExtendonBlockEntity this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sphericalJointId = it;
    }

    private static final Unit read$lambda$4(ExtendonBlockEntity this$0, BlockPos $bpos) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bpos, (String)"$bpos");
            Level level = this$0.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            Object object = level.m_7702_($bpos);
            ExtendonBlockEntity extendonBlockEntity = object instanceof ExtendonBlockEntity ? (ExtendonBlockEntity)object : null;
            if (extendonBlockEntity == null) break block0;
            Object it = object = extendonBlockEntity;
            boolean bl = false;
            ((ExtendonBlockEntity)it).disconnect();
            this$0.connectTo((IUniversalJoint)it);
        }
        return Unit.INSTANCE;
    }

    private static final Style safeHeatableGoggleTooltip$lambda$6(Style it) {
        return it.m_131150_(ClockworkGasses.getICON_FONT_LOCATION());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\n\u001a\u00020\t2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/clockwork/content/physicalities/extendon/ExtendonBlockEntity$Companion;", "", "Lorg/valkyrienskies/kelvin/api/DuctNetwork;", "network", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "pos", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "dimensionId", "", "gasToDistance", "(Lorg/valkyrienskies/kelvin/api/DuctNetwork;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Ljava/lang/String;)F", "Lnet/minecraft/core/Direction;", "direction", "Lorg/joml/Quaterniond;", "getQuaterniond", "(Lnet/minecraft/core/Direction;)Lorg/joml/Quaterniond;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final float gasToDistance(@NotNull DuctNetwork<?> network, @NotNull DuctNodePos pos, @NotNull String dimensionId) {
            Intrinsics.checkNotNullParameter(network, (String)"network");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
            double moles = 0.0;
            for (Map.Entry entry : ((Map)network.getGasMassAt(pos)).entrySet()) {
                GasType gas = (GasType)entry.getKey();
                double mass = ((Number)entry.getValue()).doubleValue();
                moles += gas.massToMoles(mass);
            }
            double pressure = AerodynamicUtils.INSTANCE.getAirPressureForY(pos.getY(), dimensionId);
            double temperature = network.getTemperatureAt(pos);
            double volume = temperature * 8.314 * moles / pressure;
            double height = (double)4 * volume / Math.PI;
            return (float)height;
        }

        @NotNull
        public final Quaterniond getQuaterniond(@NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> new Quaterniond(new AxisAngle4d(Math.PI, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)));
                case 2 -> {
                    Quaterniond var2_2 = new Quaterniond(new AxisAngle4d(Math.PI, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                    Intrinsics.checkNotNull((Object)var2_2);
                    yield var2_2;
                }
                case 3 -> {
                    Quaterniond var2_3 = new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                    Intrinsics.checkNotNull((Object)var2_3);
                    yield var2_3;
                }
                case 4 -> {
                    Quaterniond var2_4 = new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0))).normalize();
                    Intrinsics.checkNotNull((Object)var2_4);
                    yield var2_4;
                }
                case 5 -> {
                    Quaterniond var2_5 = new Quaterniond(new AxisAngle4d(4.71238898038469, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                    Intrinsics.checkNotNull((Object)var2_5);
                    yield var2_5;
                }
                default -> new Quaterniond();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                try {
                    nArray[Direction.DOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.NORTH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.EAST.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.SOUTH.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.WEST.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

