/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.solid.delivery;

import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.chute.DeliveryChuteBlockEntity;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\nJ)\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eR3\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004`\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u0010R3\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004`\u000e8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010 \u001a\u0004\b#\u0010\u0010R'\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u00020$j\b\u0012\u0004\u0012\u00020\u0002`%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/ActiveChutes;", "", "Lnet/minecraft/core/BlockPos;", "pos", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;", "chute", "", "addChute", "(Lnet/minecraft/core/BlockPos;Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;)V", "removeChute", "(Lnet/minecraft/core/BlockPos;)V", "unloadChute", "loadChute", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getChutes", "()Ljava/util/HashMap;", "", "maxDistance", "getNearestChute", "(Lnet/minecraft/core/BlockPos;D)Lnet/minecraft/core/BlockPos;", "Lorg/joml/Vector3d;", "Lcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler$Frequency;", "frequency", "", "getSortedChuteWithFrequency", "(Lorg/joml/Vector3d;DLcom/simibubi/create/content/redstone/link/RedstoneLinkNetworkHandler$Frequency;)Ljava/util/List;", "Lnet/minecraft/server/level/ServerLevel;", "level", "tick", "(Lnet/minecraft/server/level/ServerLevel;)V", "actives", "Ljava/util/HashMap;", "getActives", "unloaded", "getUnloaded", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "chutesToRemove", "Ljava/util/ArrayList;", "getChutesToRemove", "()Ljava/util/ArrayList;", "<init>", "()V", "clockwork"})
public final class ActiveChutes {
    @NotNull
    public static final ActiveChutes INSTANCE = new ActiveChutes();
    @NotNull
    private static final HashMap<BlockPos, DeliveryChuteBlockEntity> actives = new HashMap();
    @NotNull
    private static final HashMap<BlockPos, DeliveryChuteBlockEntity> unloaded = new HashMap();
    @NotNull
    private static final ArrayList<BlockPos> chutesToRemove = new ArrayList();

    private ActiveChutes() {
    }

    @NotNull
    public final HashMap<BlockPos, DeliveryChuteBlockEntity> getActives() {
        return actives;
    }

    @NotNull
    public final HashMap<BlockPos, DeliveryChuteBlockEntity> getUnloaded() {
        return unloaded;
    }

    @NotNull
    public final ArrayList<BlockPos> getChutesToRemove() {
        return chutesToRemove;
    }

    public final void addChute(@NotNull BlockPos pos, @NotNull DeliveryChuteBlockEntity chute) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)((Object)chute), (String)"chute");
        ((Map)actives).put(pos, chute);
    }

    public final void removeChute(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        chutesToRemove.add(pos);
    }

    private final void unloadChute(BlockPos pos) {
        Map map = unloaded;
        DeliveryChuteBlockEntity deliveryChuteBlockEntity = actives.get(pos);
        Intrinsics.checkNotNull((Object)((Object)deliveryChuteBlockEntity));
        map.put(pos, deliveryChuteBlockEntity);
        actives.remove(pos);
    }

    private final void loadChute(BlockPos pos) {
        Map map = actives;
        DeliveryChuteBlockEntity deliveryChuteBlockEntity = unloaded.get(pos);
        Intrinsics.checkNotNull((Object)((Object)deliveryChuteBlockEntity));
        map.put(pos, deliveryChuteBlockEntity);
        unloaded.remove(pos);
    }

    @NotNull
    public final HashMap<BlockPos, DeliveryChuteBlockEntity> getChutes() {
        return actives;
    }

    @Nullable
    public final BlockPos getNearestChute(@NotNull BlockPos pos, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        Iterator<BlockPos> iterator = actives.keySet().iterator();
        while (iterator.hasNext()) {
            Vector3d realPos;
            BlockPos chute;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            DeliveryChuteBlockEntity deliveryChuteBlockEntity = actives.get(chute);
            Intrinsics.checkNotNull((Object)((Object)deliveryChuteBlockEntity));
            Intrinsics.checkNotNull((Object)deliveryChuteBlockEntity.getRealPos());
            BlockPos realBlockPos = new BlockPos((int)realPos.x(), (int)realPos.y(), (int)realPos.z());
            if (!realBlockPos.m_123314_((Vec3i)pos, maxDistance) || !(realPos.distance((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos))) < closestDistance)) continue;
            closest = chute;
            closestDistance = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)chute)).distance((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)));
        }
        return closest;
    }

    @NotNull
    public final List<BlockPos> getSortedChuteWithFrequency(@NotNull Vector3d pos, double maxDistance, @NotNull RedstoneLinkNetworkHandler.Frequency frequency) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"frequency");
        List inRange = new ArrayList();
        for (Map.Entry entry : ((Map)actives).entrySet()) {
            Vector3d realChutePos;
            if (((DeliveryChuteBlockEntity)((Object)entry.getValue())).getRealPos() == null || realChutePos.distance((Vector3dc)pos) > maxDistance || !Intrinsics.areEqual((Object)((DeliveryChuteBlockEntity)((Object)entry.getValue())).getFrequencySlotBehaviour().getFrequency(), (Object)frequency)) continue;
            inRange.add(entry.getKey());
        }
        CollectionsKt.sortWith((List)inRange, (Comparator)new Comparator(pos){
            final /* synthetic */ Vector3d $pos$inlined;
            {
                this.$pos$inlined = vector3d;
            }

            public final int compare(T a, T b) {
                BlockPos it = (BlockPos)a;
                boolean bl = false;
                DeliveryChuteBlockEntity deliveryChuteBlockEntity = ActiveChutes.INSTANCE.getActives().get(it);
                Intrinsics.checkNotNull((Object)((Object)deliveryChuteBlockEntity));
                Vector3d vector3d = deliveryChuteBlockEntity.getRealPos();
                Intrinsics.checkNotNull((Object)vector3d);
                it = (BlockPos)b;
                Comparable comparable = Double.valueOf(vector3d.distance((Vector3dc)this.$pos$inlined));
                bl = false;
                DeliveryChuteBlockEntity deliveryChuteBlockEntity2 = ActiveChutes.INSTANCE.getActives().get(it);
                Intrinsics.checkNotNull((Object)((Object)deliveryChuteBlockEntity2));
                Vector3d vector3d2 = deliveryChuteBlockEntity2.getRealPos();
                Intrinsics.checkNotNull((Object)vector3d2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(vector3d2.distance((Vector3dc)this.$pos$inlined)));
            }
        });
        return inRange;
    }

    public final void tick(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Iterator<BlockPos> iterator = chutesToRemove.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<BlockPos> iterator2 = iterator;
        while (iterator2.hasNext()) {
            BlockPos pos;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            actives.remove(pos);
        }
        chutesToRemove.clear();
    }
}

