/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.pump;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.IConnectable;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.clockwork.util.KNodeKineticBlockEntity;
import org.valkyrienskies.kelvin.api.DuctEdge;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.edges.PumpDuctEdge;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B#\u0012\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001f\u0012\u0006\u0010!\u001a\u00020\u0014\u0012\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/pump/PumpDuctBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeKineticBlockEntity;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/IConnectable;", "", "lazyTick", "()V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "", "previousSpeed", "onSpeedChanged", "(F)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "nodeA", "nodeB", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/core/Direction;", "direction", "Lorg/valkyrienskies/kelvin/api/DuctEdge;", "getEdge", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Lorg/valkyrienskies/kelvin/api/DuctEdge;", "", "getPumpPressure", "()D", "pumpPressure", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
public final class PumpDuctBlockEntity
extends KNodeKineticBlockEntity
implements IConnectable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final double maxPumpPressure = 1023440.0;

    public PumpDuctBlockEntity(@NotNull BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(typeIn, (String)"typeIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
    }

    public final double getPumpPressure() {
        return (double)Math.abs(this.getSpeed()) / 256.0 * 1023440.0;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Intrinsics.checkNotNull((Object)dir);
        this.updateConnection(level2, blockPos, dir);
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        BlockPos blockPos2 = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        Direction direction = dir.m_122424_();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getOpposite(...)");
        this.updateConnection(level3, blockPos2, direction);
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehavioursDeferred(behaviours);
    }

    public void onSpeedChanged(float previousSpeed) {
        block2: {
            super.onSpeedChanged(previousSpeed);
            BlockPos front = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_));
            BlockPos back = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_());
            if (this.f_58857_ == null) {
                return;
            }
            DuctNetworkServer ductNetworkServer = ClockworkMod.getKelvin();
            DuctNodePos ductNodePos = this.getDuctNodePosition();
            Intrinsics.checkNotNull((Object)back);
            DuctEdge backEdge = ductNetworkServer.getEdgeBetween(ductNodePos, ClockworkUtils.INSTANCE.getDuctNodePos(back, this.f_58857_));
            DuctNetworkServer ductNetworkServer2 = ClockworkMod.getKelvin();
            DuctNodePos ductNodePos2 = this.getDuctNodePosition();
            Intrinsics.checkNotNull((Object)front);
            DuctEdge frontEdge = ductNetworkServer2.getEdgeBetween(ductNodePos2, ClockworkUtils.INSTANCE.getDuctNodePos(front, this.f_58857_));
            PumpDuctEdge pumpDuctEdge = backEdge instanceof PumpDuctEdge ? (PumpDuctEdge)backEdge : null;
            if (pumpDuctEdge != null) {
                pumpDuctEdge.setPumpPressure(this.getPumpPressure());
            }
            PumpDuctEdge pumpDuctEdge2 = frontEdge instanceof PumpDuctEdge ? (PumpDuctEdge)frontEdge : null;
            if (pumpDuctEdge2 == null) break block2;
            pumpDuctEdge2.setPumpPressure(this.getPumpPressure());
        }
    }

    @Override
    @NotNull
    public DuctEdge getEdge(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        BlockState facing;
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        BlockState blockState = this.m_58900_();
        if (blockState == null || (blockState = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)) == null) {
            blockState = Direction.UP;
        }
        if (direction == (facing = blockState)) {
            return (DuctEdge)new PumpDuctEdge(nodeA, nodeB, nodeB, this.getPumpPressure(), null, 0.0, 0.0, 0.0, false, 496, null);
        }
        return (DuctEdge)new PumpDuctEdge(nodeA, nodeB, nodeA, this.getPumpPressure(), null, 0.0, 0.0, 0.0, false, 496, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/pump/PumpDuctBlockEntity$Companion;", "", "", "maxPumpPressure", "D", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

