/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.GasNozzleBlockEntity;
import org.valkyrienskies.kelvin.impl.client.DuctNetworkClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\u0004R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleSoundInstance;", "Lnet/minecraft/client/resources/sounds/AbstractTickableSoundInstance;", "", "stopNow", "()V", "", "canStartSilent", "()Z", "tick", "Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;", "nozzle", "Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;", "getNozzle", "()Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;", "Lnet/minecraft/util/RandomSource;", "randomSource", "<init>", "(Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/GasNozzleBlockEntity;Lnet/minecraft/util/RandomSource;)V", "clockwork"})
public final class GasNozzleSoundInstance
extends AbstractTickableSoundInstance {
    @NotNull
    private final GasNozzleBlockEntity nozzle;

    public GasNozzleSoundInstance(@NotNull GasNozzleBlockEntity nozzle, @NotNull RandomSource randomSource) {
        Intrinsics.checkNotNullParameter((Object)nozzle, (String)"nozzle");
        Intrinsics.checkNotNullParameter((Object)randomSource, (String)"randomSource");
        SoundEvent soundEvent = ClockworkSounds.INSTANCE.getGAS_NOZZLE_LOOP().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent);
        super(soundEvent, SoundSource.BLOCKS, randomSource);
        this.nozzle = nozzle;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.0f;
        this.f_119575_ = this.nozzle.m_58899_().m_123341_();
        this.f_119576_ = this.nozzle.m_58899_().m_123342_();
        this.f_119577_ = this.nozzle.m_58899_().m_123343_();
    }

    @NotNull
    public final GasNozzleBlockEntity getNozzle() {
        return this.nozzle;
    }

    public final void stopNow() {
        this.m_119609_();
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        if (this.nozzle.m_58901_()) {
            this.m_119609_();
            return;
        }
        if (!this.nozzle.getHasPocket()) {
            this.f_119573_ = 0.0f;
            this.f_119574_ = 0.01f;
            this.m_119609_();
            return;
        }
        float dial = this.nozzle.getPointer().getValue();
        if (dial < 0.01f) {
            this.f_119573_ = 0.0f;
            this.f_119574_ = 0.01f;
            return;
        }
        DuctNetworkClient kelvin = ClockworkModClient.getKelvin();
        double pressure = kelvin.getPressureAt(this.nozzle.getDuctNodePosition());
        if (pressure <= 0.01) {
            this.f_119573_ = 0.0f;
            this.f_119574_ = 0.01f;
            return;
        }
        float modifier = Math.min((float)pressure * 10.0f / 1.6375049E7f, 2.0f) * dial;
        this.f_119573_ = Mth.m_14036_((float)(0.4f + modifier * 0.8f), (float)0.0f, (float)2.0f);
        this.f_119574_ = Mth.m_14036_((float)(0.1f + modifier * 0.9f), (float)0.1f, (float)1.2f);
        this.f_119575_ = this.nozzle.m_58899_().m_123341_();
        this.f_119576_ = this.nozzle.m_58899_().m_123342_();
        this.f_119577_ = this.nozzle.m_58899_().m_123343_();
    }
}

