/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.generation.creative_generator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.content.logistics.gas.generation.creative_generator.CreativeGeneratorBlockEntity;
import org.valkyrienskies.clockwork.platform.api.network.C2SCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ServerNetworkContext;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B;\u0012\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000e\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b#\u0010$B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b#\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nR>\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/creative_generator/CreativeGeneratorPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/C2SCWPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;", "context", "", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Ljava/util/HashMap;", "Lorg/valkyrienskies/kelvin/api/GasType;", "", "Lkotlin/collections/HashMap;", "gasValues", "Ljava/util/HashMap;", "getGasValues", "()Ljava/util/HashMap;", "setGasValues", "(Ljava/util/HashMap;)V", "", "temperature", "D", "getTemperature", "()D", "setTemperature", "(D)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "setBlockPos", "(Lnet/minecraft/core/BlockPos;)V", "<init>", "(Ljava/util/HashMap;DLnet/minecraft/core/BlockPos;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nCreativeGeneratorPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreativeGeneratorPacket.kt\norg/valkyrienskies/clockwork/content/logistics/gas/generation/creative_generator/CreativeGeneratorPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1279#2,2:54\n1293#2,4:56\n*S KotlinDebug\n*F\n+ 1 CreativeGeneratorPacket.kt\norg/valkyrienskies/clockwork/content/logistics/gas/generation/creative_generator/CreativeGeneratorPacket\n*L\n20#1:54,2\n20#1:56,4\n*E\n"})
public final class CreativeGeneratorPacket
implements C2SCWPacket {
    @NotNull
    private HashMap<GasType, Integer> gasValues;
    private double temperature;
    @NotNull
    private BlockPos blockPos;

    public CreativeGeneratorPacket(@NotNull HashMap<GasType, Integer> gasValues, double temperature, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter(gasValues, (String)"gasValues");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.gasValues = gasValues;
        this.temperature = temperature;
        this.blockPos = blockPos;
    }

    @NotNull
    public final HashMap<GasType, Integer> getGasValues() {
        return this.gasValues;
    }

    public final void setGasValues(@NotNull HashMap<GasType, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.gasValues = hashMap;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public final void setTemperature(double d) {
        this.temperature = d;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        return this.blockPos;
    }

    public final void setBlockPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.blockPos = blockPos;
    }

    /*
     * WARNING - void declaration
     */
    public CreativeGeneratorPacket(@NotNull FriendlyByteBuf buffer) {
        void it;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        CompoundTag compoundTag = buffer.m_130260_();
        Intrinsics.checkNotNull((Object)compoundTag);
        CompoundTag compoundTag2 = compoundTag;
        CreativeGeneratorPacket creativeGeneratorPacket = this;
        boolean bl = false;
        Iterable $this$associateWith$iv = GasTypeRegistry.INSTANCE.getGAS_TYPES().values();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GasType gasType = (GasType)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl2 = false;
            Integer n = 0;
            map.put(t, n);
        }
        Map map = result$iv;
        HashMap<GasType, Integer> map2 = new HashMap<GasType, Integer>(map);
        for (String key : it.m_128431_()) {
            Map map3 = map2;
            GasType gasType = GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(key));
            Intrinsics.checkNotNull((Object)gasType);
            map3.put(gasType, it.m_128451_(key));
        }
        double d = buffer.readDouble();
        BlockPos blockPos = buffer.m_130135_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"readBlockPos(...)");
        creativeGeneratorPacket(map2, d, blockPos);
    }

    @Override
    public void handle(@NotNull ServerNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> CreativeGeneratorPacket.handle$lambda$2(context, this));
        context.setPacketHandled(true);
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        CompoundTag compound = new CompoundTag();
        Iterator<GasType> iterator = this.gasValues.keySet().iterator();
        while (iterator.hasNext()) {
            GasType gas;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Integer n = this.gasValues.get(gas);
            compound.m_128405_(gas.getResourceLocation().toString(), n != null ? n : 0);
        }
        buffer.m_130079_(compound);
        buffer.writeDouble(this.temperature);
        buffer.m_130064_(this.blockPos);
    }

    private static final void handle$lambda$2(ServerNetworkContext $context, CreativeGeneratorPacket this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BlockEntity blockEntity = $context.getSender().m_9236_().m_7702_(this$0.blockPos);
        if (blockEntity == null) {
            return;
        }
        BlockEntity be = blockEntity;
        CreativeGeneratorBlockEntity cBe = (CreativeGeneratorBlockEntity)be;
        cBe.setGasValues(this$0.gasValues);
        cBe.setTemperature(this$0.temperature);
    }
}

