/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.resistor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.AbstractEncasedShaftBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002:;B%\u0012\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u000105\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010$\u001a\u000207\u00a2\u0006\u0004\b8\u00109J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00032\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010!\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010%\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R(\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006<"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity;", "Lcom/simibubi/create/content/kinetics/transmission/SplitShaftBlockEntity;", "Lcom/simibubi/create/api/equipment/goggles/IHaveGoggleInformation;", "", "tick", "()V", "detachKinetics", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "Lnet/minecraft/world/level/Level;", "worldIn", "Lnet/minecraft/core/BlockPos;", "pos", "", "getPower", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/core/Direction;", "face", "", "getRotationSpeedModifier", "(Lnet/minecraft/core/Direction;)F", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "Lnet/minecraft/network/chat/Component;", "tooltip", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "state", "I", "getState", "()I", "setState", "(I)V", "lastChange", "getLastChange", "setLastChange", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity$ResistDirection;", "resistDirection", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "getResistDirection", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "setResistDirection", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "ResistDirection", "ResistorValueBox", "clockwork"})
public class RedstoneResistorBlockEntity
extends SplitShaftBlockEntity
implements IHaveGoggleInformation {
    private int state;
    private int lastChange;
    public ScrollOptionBehaviour<ResistDirection> resistDirection;

    public RedstoneResistorBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final int getLastChange() {
        return this.lastChange;
    }

    public final void setLastChange(int n) {
        this.lastChange = n;
    }

    @NotNull
    public final ScrollOptionBehaviour<ResistDirection> getResistDirection() {
        ScrollOptionBehaviour<ResistDirection> scrollOptionBehaviour = this.resistDirection;
        if (scrollOptionBehaviour != null) {
            return scrollOptionBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resistDirection");
        return null;
    }

    public final void setResistDirection(@NotNull ScrollOptionBehaviour<ResistDirection> scrollOptionBehaviour) {
        Intrinsics.checkNotNullParameter(scrollOptionBehaviour, (String)"<set-?>");
        this.resistDirection = scrollOptionBehaviour;
    }

    public void tick() {
        super.tick();
        this.lastChange = this.state;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        this.state = this.getPower(level, blockPos);
        if (this.state != this.lastChange) {
            this.detachKinetics();
        }
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.f_58858_, (KineticBlockEntity)((KineticBlockEntity)this));
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        level.m_186464_(this.f_58858_, this.m_58900_().m_60734_(), 0, TickPriority.EXTREMELY_HIGH);
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL(), this.state);
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER(), this.lastChange);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.state = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL());
        this.lastChange = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER());
        super.read(compound, clientPacket);
    }

    private final int getPower(Level worldIn, BlockPos pos) {
        Direction direction;
        int power = 0;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])Iterate.directions);
        while (iterator.hasNext()) {
            direction = (Direction)iterator.next();
            power = RangesKt.coerceAtLeast((int)worldIn.m_277185_(pos.m_121945_(direction), direction), (int)power);
        }
        iterator = ArrayIteratorKt.iterator((Object[])Iterate.directions);
        while (iterator.hasNext()) {
            direction = (Direction)iterator.next();
            power = RangesKt.coerceAtLeast((int)worldIn.m_277185_(pos.m_121945_(direction), Direction.UP), (int)power);
        }
        return power;
    }

    public float getRotationSpeedModifier(@NotNull Direction face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        if (this.hasSource() && face != this.getSourceFacing()) {
            double i = this.getResistDirection().get() == ResistDirection.MAX_TO_NONE ? (double)Math.abs(this.state - 15) / 15.0 : (double)Math.abs(this.state) / 15.0;
            i = Math.rint(i * (double)10) / (double)10;
            return (float)i;
        }
        return 1.0f;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
        this.setResistDirection((ScrollOptionBehaviour<ResistDirection>)new ScrollOptionBehaviour(ResistDirection.class, (Component)ClockworkLang.translateDirect("contraptions.resistor.resist_direction", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ResistorValueBox()));
        behaviours.add((BlockEntityBehaviour)this.getResistDirection());
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Object[] objectArray = new Object[]{this.state};
        MutableComponent mutableComponent = CreateLang.translateDirect((String)"tooltip.analogStrength", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translateDirect(...)");
        tooltip.add((Component)mutableComponent);
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fj\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity$ResistDirection;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/INamedIconOptions;", "", "Lcom/simibubi/create/foundation/gui/AllIcons;", "getIcon", "()Lcom/simibubi/create/foundation/gui/AllIcons;", "", "getTranslationKey", "()Ljava/lang/String;", "icon", "Lcom/simibubi/create/foundation/gui/AllIcons;", "translationKey", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;ILcom/simibubi/create/foundation/gui/AllIcons;)V", "MAX_TO_NONE", "NONE_TO_MAX", "clockwork"})
    public static final class ResistDirection
    extends Enum<ResistDirection>
    implements INamedIconOptions {
        @NotNull
        private final AllIcons icon;
        @NotNull
        private final String translationKey;
        public static final /* enum */ ResistDirection MAX_TO_NONE;
        public static final /* enum */ ResistDirection NONE_TO_MAX;
        private static final /* synthetic */ ResistDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ResistDirection(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "resistor.resist_direction." + Lang.asId((String)this.name());
        }

        @NotNull
        public AllIcons getIcon() {
            return this.icon;
        }

        @NotNull
        public String getTranslationKey() {
            return this.translationKey;
        }

        public static ResistDirection[] values() {
            return (ResistDirection[])$VALUES.clone();
        }

        public static ResistDirection valueOf(String value) {
            return Enum.valueOf(ResistDirection.class, value);
        }

        @NotNull
        public static EnumEntries<ResistDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            AllIcons allIcons = AllIcons.I_REFRESH;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons, (String)"I_REFRESH");
            MAX_TO_NONE = new ResistDirection(allIcons);
            AllIcons allIcons2 = AllIcons.I_ROTATE_CCW;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons2, (String)"I_ROTATE_CCW");
            NONE_TO_MAX = new ResistDirection(allIcons2);
            $VALUES = resistDirectionArray = new ResistDirection[]{ResistDirection.MAX_TO_NONE, ResistDirection.NONE_TO_MAX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J5\u0010\u000e\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity$ResistorValueBox;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform$Sided;", "Lnet/minecraft/world/phys/Vec3;", "getSouthLocation", "()Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/level/LevelAccessor;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "rotate", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "Lnet/minecraft/core/Direction;", "direction", "", "isSideActive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z", "<init>", "()V", "clockwork"})
    public static final class ResistorValueBox
    extends ValueBoxTransform.Sided {
        @Nullable
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        public void rotate(@Nullable LevelAccessor level, @Nullable BlockPos pos, @NotNull BlockState state, @Nullable PoseStack ms) {
            float f;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super.rotate(level, pos, state, ms);
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AbstractEncasedShaftBlock.AXIS);
            if (axis == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            Direction.Axis axis2 = axis;
            switch (axis2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[axis2.ordinal()]) {
                case 1: {
                    f = 90.0f;
                    break;
                }
                case 2: {
                    f = 0.0f;
                    break;
                }
                default: {
                    return;
                }
            }
            float horizontalAngle = f;
            TransformStack.of((PoseStack)ms).rotateZDegrees(-horizontalAngle + 180.0f);
        }

        protected boolean isSideActive(@NotNull BlockState state, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AbstractEncasedShaftBlock.AXIS);
            return direction.m_122434_() != axis;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.Axis.values().length];
                try {
                    nArray[Direction.Axis.X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Direction.Axis.Z.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

