/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.util.Vector3icKeyDeserializer;
import org.valkyrienskies.clockwork.util.Vector3icKeySerializer;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010R&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/WanderShipControl;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "", "weight", "addBlock", "(Lnet/minecraft/core/BlockPos;D)V", "removeBlock", "(Lnet/minecraft/core/BlockPos;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/joml/Vector3i;", "wanderBlocks", "Ljava/util/concurrent/ConcurrentHashMap;", "getWanderBlocks", "()Ljava/util/concurrent/ConcurrentHashMap;", "<init>", "()V", "Companion", "clockwork"})
public final class WanderShipControl
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonSerialize(keyUsing=Vector3icKeySerializer.class)
    @JsonDeserialize(keyUsing=Vector3icKeyDeserializer.class)
    @NotNull
    private final ConcurrentHashMap<Vector3i, Double> wanderBlocks = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<Vector3i, Double> getWanderBlocks() {
        return this.wanderBlocks;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        Vector3d meanPos = new Vector3d();
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.wanderBlocks.keySet()).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Vector3i vector3i = (Vector3i)iterator2.next();
            Intrinsics.checkNotNull((Object)vector3i);
            Vec3 vec3 = VectorConversionsMCKt.toBlockPos((Vector3ic)((Vector3ic)vector3i)).m_252807_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            meanPos.add((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec3));
        }
        meanPos.div((double)this.wanderBlocks.size());
        Collection<Double> collection = this.wanderBlocks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        double sumForce = CollectionsKt.sumOfDouble((Iterable)collection);
        double gravity = ((Number)physLevel.getAerodynamicUtils().getAtmosphereForDimension(physLevel.getDimension()).component3()).doubleValue();
        double yForce = sumForce * gravity * ClockworkConfig.SERVER.getWanderOreForceMultiplier();
        Vector3d force = new Vector3d(0.0, yForce, 0.0);
        if (meanPos.isFinite() && !Double.isNaN(meanPos.length()) && force.isFinite() && !Double.isNaN(force.length())) {
            physShip.applyWorldForceToModelPos((Vector3dc)force, (Vector3dc)meanPos);
        }
    }

    public final void addBlock(@NotNull BlockPos blockPos, double weight) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Double d = weight;
        ((Map)this.wanderBlocks).put(VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)blockPos)), d);
    }

    public final void removeBlock(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.wanderBlocks.remove(VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)blockPos)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/WanderShipControl$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/WanderShipControl;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/WanderShipControl;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WanderShipControl getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            if (ship.getAttachment(WanderShipControl.class) == null) {
                ship.setAttachment((Object)new WanderShipControl());
            }
            Object object = ship.getAttachment(WanderShipControl.class);
            Intrinsics.checkNotNull((Object)object);
            return (WanderShipControl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

