/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.WanderwandItem;
import org.valkyrienskies.clockwork.content.forces.data.BalloonData;
import org.valkyrienskies.clockwork.util.AABBHelper;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0002@?B\u0007\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J'\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0016\u00a2\u0006\u0004\b'\u0010(J)\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020!2\b\b\u0002\u0010*\u001a\u00020\u0016\u00a2\u0006\u0004\b+\u0010,J+\u00101\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020!\u00a2\u0006\u0004\b1\u00102R#\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R&\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\t038\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b8\u00105\u001a\u0004\b9\u00107R\u0011\u0010<\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006A"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/BalloonController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "physLevel", "", "physTick", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;)V", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$PhysBalloonData;", "physBalloon", "", "calculateBuoyancyForce", "(Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/valkyrienskies/core/api/world/PhysLevel;Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData$PhysBalloonData;)D", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "gameTick", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)V", "Lnet/minecraft/core/BlockPos;", "pos", "", "getExistingBalloon", "(Lnet/minecraft/core/BlockPos;)I", "id", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "getBalloonById", "(I)Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "balloonData", "addBalloon", "(Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;)V", "startPos", "Lnet/minecraft/world/level/Level;", "tryGetOrCreateBalloon", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)I", "startShell", "maxShellBlocks", "Lorg/valkyrienskies/clockwork/content/forces/BalloonController$ShellInfo;", "scanShell", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;I)Lorg/valkyrienskies/clockwork/content/forces/BalloonController$ShellInfo;", "shellTop", "maxStepsDown", "findInteriorSeedFromTop", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;I)Lnet/minecraft/core/BlockPos;", "shell", "seed", "", "Lorg/joml/primitives/AABBic;", "tryFillBalloonFromShell", "(Lorg/valkyrienskies/clockwork/content/forces/BalloonController$ShellInfo;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Ljava/util/List;", "Ljava/util/concurrent/ConcurrentHashMap;", "balloons", "Ljava/util/concurrent/ConcurrentHashMap;", "getBalloons", "()Ljava/util/concurrent/ConcurrentHashMap;", "forcefulBalloons", "getForcefulBalloons", "getNextBalloonID", "()I", "nextBalloonID", "<init>", "()V", "Companion", "ShellInfo", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBalloonController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonController.kt\norg/valkyrienskies/clockwork/content/forces/BalloonController\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,403:1\n535#2:404\n520#2,6:405\n*S KotlinDebug\n*F\n+ 1 BalloonController.kt\norg/valkyrienskies/clockwork/content/forces/BalloonController\n*L\n149#1:404\n149#1:405,6\n*E\n"})
public final class BalloonController
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Integer, BalloonData> balloons = new ConcurrentHashMap();
    @JsonIgnore
    @NotNull
    private final ConcurrentHashMap<Integer, BalloonData.PhysBalloonData> forcefulBalloons = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<Integer, BalloonData> getBalloons() {
        return this.balloons;
    }

    @NotNull
    public final ConcurrentHashMap<Integer, BalloonData.PhysBalloonData> getForcefulBalloons() {
        return this.forcefulBalloons;
    }

    public final int getNextBalloonID() {
        Set set = this.balloons.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)set);
        return (n != null ? n : 0) + 1;
    }

    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        Iterator iterator = ((Map)this.forcefulBalloons).entrySet().iterator();
        while (iterator.hasNext()) {
            BalloonData.PhysBalloonData balloonData = (BalloonData.PhysBalloonData)iterator.next().getValue();
            double buoyancyForce = this.calculateBuoyancyForce(physShip, physLevel, balloonData);
            if (!(buoyancyForce > 0.0)) continue;
            Vector3dc forceVector = (Vector3dc)new Vector3d(0.0, buoyancyForce, 0.0);
            physShip.applyWorldForceToModelPos(forceVector, balloonData.getCenter());
        }
    }

    public final double calculateBuoyancyForce(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel, @NotNull BalloonData.PhysBalloonData physBalloon) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        Intrinsics.checkNotNullParameter((Object)physBalloon, (String)"physBalloon");
        double gravity = ((Number)physLevel.getAerodynamicUtils().getAtmosphereForDimension(physLevel.getDimension()).component3()).doubleValue();
        double yHeight = physShip.getTransform().getShipToWorld().transformPosition(physBalloon.getCenter(), new Vector3d()).y();
        double atmoDensity = physLevel.getAerodynamicUtils().getAirDensityForY(yHeight, physLevel.getDimension());
        double buoyantForce = physBalloon.getVolume() * (atmoDensity - physBalloon.getInternalDensity()) * gravity * ClockworkConfig.SERVER.getBalloonForceMult() * 100.0;
        if (Double.isInfinite(buoyantForce) || Double.isNaN(buoyantForce)) {
            return 0.0;
        }
        return Math.max(buoyantForce, 0.0);
    }

    public final void gameTick(@NotNull ServerLevel level, @NotNull LoadedServerShip ship) {
        Map.Entry $this$filterTo$iv$iv2;
        BlockPos seed;
        Object balloon;
        int id;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        if (!Intrinsics.areEqual((Object)VSGameUtilsKt.getDimensionId((Level)((Level)level)), (Object)ship.getChunkClaimDimension())) {
            return;
        }
        List toRemove = new ArrayList();
        for (Map.Entry entry : ((Map)this.balloons).entrySet()) {
            id = ((Number)entry.getKey()).intValue();
            balloon = (BalloonData)entry.getValue();
            if (!((BalloonData)balloon).getShouldRemove()) continue;
            toRemove.add(id);
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int id2 = ((Number)((Object)iterator.next())).intValue();
            this.balloons.remove(id2);
        }
        for (Map.Entry id2 : ((Map)this.balloons).entrySet()) {
            id = ((Number)id2.getKey()).intValue();
            balloon = (BalloonData)id2.getValue();
            if (((BalloonData)balloon).getShouldValidate()) {
                BalloonData.EnclosureStatus status = ((BalloonData)balloon).validate((Level)level);
                ((BalloonData)balloon).setShouldValidate(false);
            }
            if (((BalloonData)balloon).getShouldReScan()) {
                BlockPos validScanStart = ((BalloonData)balloon).getFirstValidExternalPosition((Level)level);
                if (validScanStart == null) {
                    ((BalloonData)balloon).setShouldReScan(false);
                    ((BalloonData)balloon).setShouldRemove(true);
                    continue;
                }
                ShellInfo shell = this.scanShell(validScanStart, (Level)level, (int)ClockworkConfig.SERVER.getHotAirBalloonMaxScanSurface());
                if (shell == null) {
                    ((BalloonData)balloon).setShouldReScan(false);
                    ((BalloonData)balloon).setShouldRemove(true);
                    continue;
                }
                seed = BalloonController.findInteriorSeedFromTop$default(this, shell.getTopShellPos(), (Level)level, 0, 4, null);
                if (seed == null) {
                    ((BalloonData)balloon).setShouldReScan(false);
                    ((BalloonData)balloon).setShouldRemove(true);
                    continue;
                }
                List<AABBic> newRegions = this.tryFillBalloonFromShell(shell, seed, (Level)level);
                if (!((Collection)newRegions).isEmpty()) {
                    ((BalloonData)balloon).updateRegionsNoValidation(newRegions, (Level)level);
                    ((BalloonData)balloon).setShouldReScan(false);
                } else {
                    ((BalloonData)balloon).setShouldReScan(false);
                    if (((BalloonData)balloon).isNearlyAtmospheric(level)) {
                        ((BalloonData)balloon).setShouldRemove(true);
                    } else {
                        ((BalloonData)balloon).setShouldRemove(((BalloonData)balloon).validate((Level)level) == BalloonData.EnclosureStatus.INVALID);
                    }
                }
            }
            if (((BalloonData)balloon).isLeaking() && ((BalloonData)balloon).isNearlyAtmospheric(level)) {
                ((BalloonData)balloon).setShouldRemove(true);
            }
            if (!((BalloonData)balloon).getRegions().isEmpty() && !(((BalloonData)balloon).getCurrentVolume() <= 0.0)) continue;
            ((BalloonData)balloon).setShouldRemove(true);
        }
        Map $this$filter$iv = this.balloons;
        boolean $i$f$filter = false;
        balloon = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        seed = $this$filterTo$iv$iv2.entrySet().iterator();
        while (seed.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = seed.next();
            boolean bl = false;
            if (!(!((BalloonData)it.getValue()).getShouldRemove())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map tickableBloons = destination$iv$iv;
        ArrayList<Integer> shouldApplyForces = new ArrayList<Integer>();
        for (Map.Entry $this$filterTo$iv$iv2 : tickableBloons.entrySet()) {
            int id3 = ((Number)$this$filterTo$iv$iv2.getKey()).intValue();
            BalloonData balloon2 = (BalloonData)$this$filterTo$iv$iv2.getValue();
            boolean result = balloon2.tick(level, ship);
            if (!result) continue;
            shouldApplyForces.add(id3);
        }
        this.forcefulBalloons.clear();
        Iterator iterator2 = shouldApplyForces.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            BalloonData balloon3;
            Map.Entry entry = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
            int id4 = ((Number)((Object)entry)).intValue();
            if (this.balloons.get(id4) == null) continue;
            Integer n = id4;
            ((Map)this.forcefulBalloons).put(n, balloon3.makeForceData());
        }
    }

    public final int getExistingBalloon(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        for (Map.Entry entry : ((Map)this.balloons).entrySet()) {
            int id = ((Number)entry.getKey()).intValue();
            BalloonData balloon = (BalloonData)entry.getValue();
            if (!balloon.containsPosition(pos)) continue;
            return id;
        }
        return -1;
    }

    @Nullable
    public final BalloonData getBalloonById(int id) {
        return this.balloons.get(id);
    }

    public final void addBalloon(@NotNull BalloonData balloonData) {
        Intrinsics.checkNotNullParameter((Object)balloonData, (String)"balloonData");
        ((Map)this.balloons).put(this.getNextBalloonID(), balloonData);
    }

    public final int tryGetOrCreateBalloon(@NotNull BlockPos startPos, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        BlockHitResult result = level.m_45547_(new ClipContext(startPos.m_252807_().m_82520_(0.0, 0.5, 0.0), startPos.m_252807_().m_82520_(0.0, ClockworkConfig.SERVER.getHotAirBalloonMaxRaycastDistance(), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return -1;
        }
        BlockPos blockPos = result.m_82425_();
        if (blockPos == null) {
            return -1;
        }
        BlockPos hitPos = blockPos;
        if (hitPos.m_123333_((Vec3i)startPos) < 2) {
            return -1;
        }
        BlockPos shellStart = hitPos;
        BlockPos blockPos2 = shellStart.m_121945_(Direction.DOWN);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"relative(...)");
        int existingBalloonID = this.getExistingBalloon(blockPos2);
        if (existingBalloonID != -1) {
            return existingBalloonID;
        }
        ShellInfo shellInfo = this.scanShell(shellStart, level, (int)ClockworkConfig.SERVER.getHotAirBalloonMaxScanSurface());
        if (shellInfo == null) {
            return -1;
        }
        ShellInfo shell = shellInfo;
        BlockPos blockPos3 = BalloonController.findInteriorSeedFromTop$default(this, shell.getTopShellPos(), level, 0, 4, null);
        if (blockPos3 == null) {
            return -1;
        }
        BlockPos seed = blockPos3;
        List<AABBic> filled = this.tryFillBalloonFromShell(shell, seed, level);
        if (filled.isEmpty()) {
            return -1;
        }
        int newBalloonID = this.getNextBalloonID();
        BalloonData newBalloon = new BalloonData(new ArrayList<AABBic>((Collection)filled), new HashMap<String, Double>(), 0.0, 0.0, false);
        Integer n = newBalloonID;
        ((Map)this.balloons).put(n, newBalloon);
        newBalloon.recalculateVolume();
        return newBalloonID;
    }

    @Nullable
    public final ShellInfo scanShell(@NotNull BlockPos startShell, @NotNull Level level, int maxShellBlocks) {
        Intrinsics.checkNotNullParameter((Object)startShell, (String)"startShell");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        BlockState blockState = level.m_8055_(startShell);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        if (!Companion.isValidBalloonEnclosure(blockState, level, startShell)) {
            return null;
        }
        HashSet<Long> visited = new HashSet<Long>(4096);
        ArrayDeque q = new ArrayDeque();
        q.add((Object)startShell.m_121878_());
        int minY = startShell.m_123342_();
        int maxY = startShell.m_123342_();
        BlockPos topPos = startShell;
        int minX = startShell.m_123341_();
        int maxX = startShell.m_123341_();
        int minZ = startShell.m_123343_();
        int maxZ = startShell.m_123343_();
        while (!((Collection)q).isEmpty() && visited.size() < maxShellBlocks) {
            long curL = ((Number)q.removeFirst()).longValue();
            if (!visited.add(curL)) continue;
            BlockPos cur2 = BlockPos.m_122022_((long)curL);
            int y = cur2.m_123342_();
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
                topPos = cur2;
            }
            int x = cur2.m_123341_();
            int z = cur2.m_123343_();
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (z > maxZ) {
                maxZ = z;
            }
            for (Direction dir : Direction.values()) {
                long nl;
                BlockPos n = cur2.m_121945_(dir);
                for (Direction diag : Direction.values()) {
                    long ndl;
                    if (dir.m_122434_() == diag.m_122434_()) continue;
                    BlockPos nd = n.m_121945_(diag);
                    for (Direction corner : Direction.values()) {
                        long nlc;
                        if (corner.m_122434_() == diag.m_122434_() || corner.m_122434_() == dir.m_122434_()) continue;
                        BlockPos nc = nd.m_121945_(corner);
                        BlockState blockState2 = level.m_8055_(nc);
                        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
                        Intrinsics.checkNotNull((Object)nc);
                        if (!Companion.isValidBalloonEnclosure(blockState2, level, nc) || visited.contains(nlc = nc.m_121878_())) continue;
                        q.add((Object)nlc);
                    }
                    BlockState blockState3 = level.m_8055_(nd);
                    Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"getBlockState(...)");
                    Intrinsics.checkNotNull((Object)nd);
                    if (!Companion.isValidBalloonEnclosure(blockState3, level, nd) || visited.contains(ndl = nd.m_121878_())) continue;
                    q.add((Object)ndl);
                }
                BlockState blockState4 = level.m_8055_(n);
                Intrinsics.checkNotNullExpressionValue((Object)blockState4, (String)"getBlockState(...)");
                Intrinsics.checkNotNull((Object)n);
                if (!Companion.isValidBalloonEnclosure(blockState4, level, n) || visited.contains(nl = n.m_121878_())) continue;
                q.add((Object)nl);
            }
            if (visited.size() < maxShellBlocks) continue;
            return null;
        }
        return new ShellInfo(minY, maxY, topPos, minX, maxX, minZ, maxZ);
    }

    @Nullable
    public final BlockPos findInteriorSeedFromTop(@NotNull BlockPos shellTop, @NotNull Level level, int maxStepsDown) {
        Intrinsics.checkNotNullParameter((Object)shellTop, (String)"shellTop");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        BlockPos p = shellTop.m_7495_();
        int steps = 0;
        while (steps++ < maxStepsDown) {
            BlockState blockState = level.m_8055_(p);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockPos blockPos = p;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!Companion.isValidBalloonEnclosure(blockState, level, blockPos)) {
                return p;
            }
            p = p.m_7495_();
        }
        return null;
    }

    public static /* synthetic */ BlockPos findInteriorSeedFromTop$default(BalloonController balloonController, BlockPos blockPos, Level level, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 64;
        }
        return balloonController.findInteriorSeedFromTop(blockPos, level, n);
    }

    @NotNull
    public final List<AABBic> tryFillBalloonFromShell(@NotNull ShellInfo shell, @NotNull BlockPos seed, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        double maxScan = ClockworkConfig.SERVER.getHotAirBalloonMaxScanVolume();
        int minYInterior = shell.getMinY() + 1;
        int minX = shell.getMinX() - 1;
        int maxX = shell.getMaxX() + 1;
        int minZ = shell.getMinZ() - 1;
        int maxZ = shell.getMaxZ() + 1;
        HashSet<Long> visited = new HashSet<Long>((int)maxScan * 2);
        ArrayDeque q = new ArrayDeque();
        q.add((Object)seed.m_121878_());
        ArrayList<AABBic> toFill = new ArrayList<AABBic>(Math.min((int)maxScan, 4096));
        while (!((Collection)q).isEmpty() && visited.size() < (int)maxScan) {
            BlockPos cur2;
            block6: {
                block5: {
                    long curL = ((Number)q.removeFirst()).longValue();
                    if (!visited.add(curL) || (cur2 = BlockPos.m_122022_((long)curL)).m_123342_() <= minYInterior) continue;
                    BlockState state = level.m_8055_(cur2);
                    Intrinsics.checkNotNull((Object)state);
                    Intrinsics.checkNotNull((Object)cur2);
                    if (Companion.isValidBalloonEnclosure(state, level, cur2)) continue;
                    int n = cur2.m_123341_();
                    boolean bl = minX <= n ? n <= maxX : false;
                    if (!bl) break block5;
                    n = cur2.m_123343_();
                    if (minZ <= n ? n <= maxZ : false) break block6;
                }
                return CollectionsKt.emptyList();
            }
            toFill.add(WanderwandItem.Companion.toAABBic(cur2));
            for (Direction dir : Direction.values()) {
                long nl;
                BlockPos n = cur2.m_121945_(dir);
                BlockState blockState = level.m_8055_(n);
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                Intrinsics.checkNotNull((Object)n);
                if (Companion.isValidBalloonEnclosure(blockState, level, n) || visited.contains(nl = n.m_121878_())) continue;
                q.add((Object)nl);
            }
        }
        return AABBHelper.INSTANCE.mergeAdjacentFast((Iterable<? extends AABBic>)toFill);
    }

    @JvmStatic
    public static final boolean isValidBalloonEnclosure(@NotNull BlockState $this$isValidBalloonEnclosure, @NotNull Level level, @NotNull BlockPos pos) {
        return Companion.isValidBalloonEnclosure($this$isValidBalloonEnclosure, level, pos);
    }

    @JvmStatic
    public static final boolean isValidBalloonEnclosureDirectional(@NotNull BlockState $this$isValidBalloonEnclosureDirectional, @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return Companion.isValidBalloonEnclosureDirectional($this$isValidBalloonEnclosureDirectional, level, pos, direction);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\r\u001a\u00020\f*\u00020\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ+\u0010\u0011\u001a\u00020\f*\u00020\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/BalloonController$Companion;", "", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/forces/BalloonController;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/LoadedServerShip;)Lorg/valkyrienskies/clockwork/content/forces/BalloonController;", "Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "", "isValidBalloonEnclosure", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/core/Direction;", "direction", "isValidBalloonEnclosureDirectional", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BalloonController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            BalloonController existing = (BalloonController)ship.getAttachment(BalloonController.class);
            if (existing != null) {
                return existing;
            }
            BalloonController controller = new BalloonController();
            ship.setAttachment((Object)controller);
            return controller;
        }

        @JvmStatic
        public final boolean isValidBalloonEnclosure(@NotNull BlockState $this$isValidBalloonEnclosure, @NotNull Level level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)$this$isValidBalloonEnclosure, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return !$this$isValidBalloonEnclosure.m_60795_() && $this$isValidBalloonEnclosure.m_60838_((BlockGetter)level, pos);
        }

        @JvmStatic
        public final boolean isValidBalloonEnclosureDirectional(@NotNull BlockState $this$isValidBalloonEnclosureDirectional, @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)$this$isValidBalloonEnclosureDirectional, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return !$this$isValidBalloonEnclosureDirectional.m_60795_() && !$this$isValidBalloonEnclosureDirectional.m_60783_((BlockGetter)level, pos, direction.m_122424_());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u0012\u0006\u0010\u0011\u001a\u00020\u0002\u0012\u0006\u0010\u0012\u001a\u00020\u0002\u0012\u0006\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0004J\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\u0004J\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u0004JV\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0013\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001e\u001a\u0004\b\u001f\u0010\u0004R\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001e\u001a\u0004\b \u0010\u0004R\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010!\u001a\u0004\b\"\u0010\bR\u0017\u0010\u0010\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001e\u001a\u0004\b#\u0010\u0004R\u0017\u0010\u0011\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u001e\u001a\u0004\b$\u0010\u0004R\u0017\u0010\u0012\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u001e\u001a\u0004\b%\u0010\u0004R\u0017\u0010\u0013\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u001e\u001a\u0004\b&\u0010\u0004\u00a8\u0006)"}, d2={"Lorg/valkyrienskies/clockwork/content/forces/BalloonController$ShellInfo;", "", "", "component1", "()I", "component2", "Lnet/minecraft/core/BlockPos;", "component3", "()Lnet/minecraft/core/BlockPos;", "component4", "component5", "component6", "component7", "minY", "maxY", "topShellPos", "minX", "maxX", "minZ", "maxZ", "copy", "(IILnet/minecraft/core/BlockPos;IIII)Lorg/valkyrienskies/clockwork/content/forces/BalloonController$ShellInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getMinY", "getMaxY", "Lnet/minecraft/core/BlockPos;", "getTopShellPos", "getMinX", "getMaxX", "getMinZ", "getMaxZ", "<init>", "(IILnet/minecraft/core/BlockPos;IIII)V", "clockwork"})
    public static final class ShellInfo {
        private final int minY;
        private final int maxY;
        @NotNull
        private final BlockPos topShellPos;
        private final int minX;
        private final int maxX;
        private final int minZ;
        private final int maxZ;

        public ShellInfo(int minY, int maxY, @NotNull BlockPos topShellPos, int minX, int maxX, int minZ, int maxZ) {
            Intrinsics.checkNotNullParameter((Object)topShellPos, (String)"topShellPos");
            this.minY = minY;
            this.maxY = maxY;
            this.topShellPos = topShellPos;
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        public final int getMinY() {
            return this.minY;
        }

        public final int getMaxY() {
            return this.maxY;
        }

        @NotNull
        public final BlockPos getTopShellPos() {
            return this.topShellPos;
        }

        public final int getMinX() {
            return this.minX;
        }

        public final int getMaxX() {
            return this.maxX;
        }

        public final int getMinZ() {
            return this.minZ;
        }

        public final int getMaxZ() {
            return this.maxZ;
        }

        public final int component1() {
            return this.minY;
        }

        public final int component2() {
            return this.maxY;
        }

        @NotNull
        public final BlockPos component3() {
            return this.topShellPos;
        }

        public final int component4() {
            return this.minX;
        }

        public final int component5() {
            return this.maxX;
        }

        public final int component6() {
            return this.minZ;
        }

        public final int component7() {
            return this.maxZ;
        }

        @NotNull
        public final ShellInfo copy(int minY, int maxY, @NotNull BlockPos topShellPos, int minX, int maxX, int minZ, int maxZ) {
            Intrinsics.checkNotNullParameter((Object)topShellPos, (String)"topShellPos");
            return new ShellInfo(minY, maxY, topShellPos, minX, maxX, minZ, maxZ);
        }

        public static /* synthetic */ ShellInfo copy$default(ShellInfo shellInfo, int n, int n2, BlockPos blockPos, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = shellInfo.minY;
            }
            if ((n7 & 2) != 0) {
                n2 = shellInfo.maxY;
            }
            if ((n7 & 4) != 0) {
                blockPos = shellInfo.topShellPos;
            }
            if ((n7 & 8) != 0) {
                n3 = shellInfo.minX;
            }
            if ((n7 & 0x10) != 0) {
                n4 = shellInfo.maxX;
            }
            if ((n7 & 0x20) != 0) {
                n5 = shellInfo.minZ;
            }
            if ((n7 & 0x40) != 0) {
                n6 = shellInfo.maxZ;
            }
            return shellInfo.copy(n, n2, blockPos, n3, n4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "ShellInfo(minY=" + this.minY + ", maxY=" + this.maxY + ", topShellPos=" + this.topShellPos + ", minX=" + this.minX + ", maxX=" + this.maxX + ", minZ=" + this.minZ + ", maxZ=" + this.maxZ + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.minY);
            result = result * 31 + Integer.hashCode(this.maxY);
            result = result * 31 + this.topShellPos.hashCode();
            result = result * 31 + Integer.hashCode(this.minX);
            result = result * 31 + Integer.hashCode(this.maxX);
            result = result * 31 + Integer.hashCode(this.minZ);
            result = result * 31 + Integer.hashCode(this.maxZ);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShellInfo)) {
                return false;
            }
            ShellInfo shellInfo = (ShellInfo)other;
            if (this.minY != shellInfo.minY) {
                return false;
            }
            if (this.maxY != shellInfo.maxY) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.topShellPos, (Object)shellInfo.topShellPos)) {
                return false;
            }
            if (this.minX != shellInfo.minX) {
                return false;
            }
            if (this.maxX != shellInfo.maxX) {
                return false;
            }
            if (this.minZ != shellInfo.minZ) {
                return false;
            }
            return this.maxZ == shellInfo.maxZ;
        }
    }
}

