/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.solver;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkRenderTypes;
import org.valkyrienskies.clockwork.content.curiosities.solver.SolverBlockEntity;
import org.valkyrienskies.clockwork.util.beam.BeamRenderer;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJA\u0010\u0016\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/solver/SolverRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/curiosities/solver/SolverBlockEntity;", "blockEntity", "", "shouldRenderOffScreen", "(Lorg/valkyrienskies/clockwork/content/curiosities/solver/SolverBlockEntity;)Z", "Lnet/minecraft/world/phys/Vec3;", "cameraPos", "shouldRender", "(Lorg/valkyrienskies/clockwork/content/curiosities/solver/SolverBlockEntity;Lnet/minecraft/world/phys/Vec3;)Z", "be", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/curiosities/solver/SolverBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class SolverRenderer
extends SmartBlockEntityRenderer<SolverBlockEntity> {
    public SolverRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public boolean shouldRenderOffScreen(@NotNull SolverBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        return true;
    }

    public boolean shouldRender(@NotNull SolverBlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        return true;
    }

    protected void renderSafe(@Nullable SolverBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        BlockHitResult hitNormalWorld;
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (be == null) {
            return;
        }
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        Level level2 = level;
        Vec3 startWorld = be.getWorldPos();
        Vec3 dirWorld = be.getWorldFacing().m_82541_();
        Vec3 desiredEndWorld = startWorld.m_82549_(dirWorld.m_82490_(64.0));
        Intrinsics.checkNotNull((Object)desiredEndWorld);
        BlockHitResult hit = be.raycastBeam(level2, startWorld, desiredEndWorld, null);
        BlockHitResult blockHitResult = hit;
        if (blockHitResult == null || (blockHitResult = blockHitResult.m_82450_()) == null) {
            blockHitResult = desiredEndWorld;
        }
        BlockHitResult endWorld = blockHitResult;
        BlockPos blockPos = be.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        LoadedShip shipOn = VSGameUtilsKt.getLoadedShipManagingPos((Level)level2, (Vec3i)((Vec3i)blockPos));
        Vec3 blockOriginWorld = Vec3.m_82528_((Vec3i)((Vec3i)be.m_58899_()));
        BlockHitResult blockHitResult2 = hit;
        if (blockHitResult2 == null || (blockHitResult2 = blockHitResult2.m_82434_()) == null || (blockHitResult2 = blockHitResult2.m_122436_()) == null || (blockHitResult2 = VectorConversionsMCKt.toDoubles((Vec3i)blockHitResult2)) == null) {
            blockHitResult2 = hitNormalWorld = Vec3.f_82478_;
        }
        if (shipOn != null) {
            Matrix4dc matrix4dc = ((ClientShip)shipOn).getRenderTransform().getShipToWorld();
            Vec3 vec3 = blockOriginWorld;
            Intrinsics.checkNotNull((Object)vec3);
            Vector3d vector3d = matrix4dc.transformPosition((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec3), new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
            blockOriginWorld = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d));
            Quaterniondc quaterniondc = ((ClientShip)shipOn).getRenderTransform().getRotation();
            vec3 = hitNormalWorld;
            Intrinsics.checkNotNull((Object)vec3);
            Vector3d vector3d2 = quaterniondc.transform(VectorConversionsMCKt.toJOML((Vec3)vec3));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transform(...)");
            hitNormalWorld = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)vector3d2));
        }
        Vec3 start = startWorld.m_82546_(blockOriginWorld);
        Vec3 end = endWorld.m_82546_(blockOriginWorld);
        float time = be.getClientTime() + partialTicks / 20.0f;
        VertexConsumer vc = buffer.m_6299_(ClockworkRenderTypes.Companion.getBEAM());
        ms.m_85836_();
        if (shipOn != null) {
            Quaterniond quaterniond = ((ClientShip)shipOn).getRenderTransform().getRotation().invert(new Quaterniond());
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"invert(...)");
            ms.m_252781_(VectorConversionsMCKt.toFloat((Quaterniondc)((Quaterniondc)quaterniond)));
        }
        Intrinsics.checkNotNull((Object)vc);
        Vec3 vec3 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        Vec3 vec32 = blockOriginWorld;
        Intrinsics.checkNotNull((Object)vec32);
        Intrinsics.checkNotNull((Object)start);
        Intrinsics.checkNotNull((Object)end);
        BeamRenderer.renderBeamTube$default(BeamRenderer.INSTANCE, ms, vc, vec3, vec32, start, end, 1.0f, -1, Math.max(32, (int)(start.m_82554_(end) * 12.0)), 4, 0.15f, 0, 1.0f, -4.0f, time, 1.0f, be.getBeamSeed-s-VKNKU(), 2048, null);
        if (hit != null) {
            Vec3 hitLocal = end;
            Vec3 vec33 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getPosition(...)");
            Vec3 vec34 = blockOriginWorld;
            Intrinsics.checkNotNull((Object)vec34);
            Vec3 vec35 = vec34;
            vec34 = hitNormalWorld;
            Intrinsics.checkNotNull((Object)vec34);
            BeamRenderer.INSTANCE.renderImpactBurst(ms, vc, vec33, vec35, hitLocal, vec34, ULong.constructor-impl((long)(be.getBeamSeed-s-VKNKU() ^ 0xBADC0FFEEL)), time, 14, 1.45f, 0.12f, -1);
        }
        ms.m_85849_();
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
    }
}

