/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.meteor;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh;", "", "", "longSegs", "latSegs", "Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh$Mesh;", "buildUvSphere", "(II)Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh$Mesh;", "mesh", "Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh$Mesh;", "getMesh", "()Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh$Mesh;", "<init>", "()V", "Mesh", "clockwork"})
public final class SphereMesh {
    @NotNull
    public static final SphereMesh INSTANCE = new SphereMesh();
    @NotNull
    private static final Mesh mesh = INSTANCE.buildUvSphere(16, 10);

    private SphereMesh() {
    }

    @NotNull
    public final Mesh getMesh() {
        return mesh;
    }

    @NotNull
    public final Mesh buildUvSphere(int longSegs, int latSegs) {
        if (!(longSegs >= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(latSegs >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int cols = longSegs + 1;
        int rows = latSegs + 1;
        int vertCount = cols * rows;
        float[] pos = new float[vertCount * 3];
        float[] nrm = new float[vertCount * 3];
        float[] uv = new float[vertCount * 2];
        int vtx = 0;
        int iy = 0;
        if (iy <= latSegs) {
            while (true) {
                double t = (double)iy / (double)latSegs;
                double theta = Math.PI * t;
                double sinT = Math.sin(theta);
                double cosT = Math.cos(theta);
                int ix = 0;
                if (ix <= longSegs) {
                    while (true) {
                        double s = (double)ix / (double)longSegs;
                        double phi = Math.PI * 2 * s;
                        double sinP = Math.sin(phi);
                        double cosP = Math.cos(phi);
                        float x = (float)(sinT * cosP);
                        float y = (float)cosT;
                        float z = (float)(sinT * sinP);
                        pos[vtx * 3 + 0] = x;
                        pos[vtx * 3 + 1] = y;
                        pos[vtx * 3 + 2] = z;
                        nrm[vtx * 3 + 0] = x;
                        nrm[vtx * 3 + 1] = y;
                        nrm[vtx * 3 + 2] = z;
                        uv[vtx * 2 + 0] = (float)s;
                        uv[vtx * 2 + 1] = (float)(1.0 - t);
                        ++vtx;
                        if (ix == longSegs) break;
                        ++ix;
                    }
                }
                if (iy == latSegs) break;
                ++iy;
            }
        }
        int triCount = longSegs * latSegs * 2;
        int[] idx = new int[triCount * 3];
        int ii = 0;
        for (int iy2 = 0; iy2 < latSegs; ++iy2) {
            for (int ix = 0; ix < longSegs; ++ix) {
                int a = iy2 * cols + ix;
                int b = a + 1;
                int c = a + cols;
                int d = c + 1;
                idx[ii++] = a;
                idx[ii++] = c;
                idx[ii++] = b;
                idx[ii++] = b;
                idx[ii++] = c;
                idx[ii++] = d;
            }
        }
        return new Mesh(pos, nrm, uv, idx);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001b\u0010\u0004R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001c\u0010\u0004R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001a\u001a\u0004\b\u001d\u0010\u0004R\u0017\u0010\r\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001e\u001a\u0004\b\u001f\u0010\t\u00a8\u0006\""}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh$Mesh;", "", "", "component1", "()[F", "component2", "component3", "", "component4", "()[I", "positions", "normals", "uvs", "indices", "copy", "([F[F[F[I)Lorg/valkyrienskies/clockwork/content/curiosities/meteor/SphereMesh$Mesh;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "[F", "getPositions", "getNormals", "getUvs", "[I", "getIndices", "<init>", "([F[F[F[I)V", "clockwork"})
    public static final class Mesh {
        @NotNull
        private final float[] positions;
        @NotNull
        private final float[] normals;
        @NotNull
        private final float[] uvs;
        @NotNull
        private final int[] indices;

        public Mesh(@NotNull float[] positions, @NotNull float[] normals, @NotNull float[] uvs, @NotNull int[] indices) {
            Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)normals, (String)"normals");
            Intrinsics.checkNotNullParameter((Object)uvs, (String)"uvs");
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            this.positions = positions;
            this.normals = normals;
            this.uvs = uvs;
            this.indices = indices;
        }

        @NotNull
        public final float[] getPositions() {
            return this.positions;
        }

        @NotNull
        public final float[] getNormals() {
            return this.normals;
        }

        @NotNull
        public final float[] getUvs() {
            return this.uvs;
        }

        @NotNull
        public final int[] getIndices() {
            return this.indices;
        }

        @NotNull
        public final float[] component1() {
            return this.positions;
        }

        @NotNull
        public final float[] component2() {
            return this.normals;
        }

        @NotNull
        public final float[] component3() {
            return this.uvs;
        }

        @NotNull
        public final int[] component4() {
            return this.indices;
        }

        @NotNull
        public final Mesh copy(@NotNull float[] positions, @NotNull float[] normals, @NotNull float[] uvs, @NotNull int[] indices) {
            Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)normals, (String)"normals");
            Intrinsics.checkNotNullParameter((Object)uvs, (String)"uvs");
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            return new Mesh(positions, normals, uvs, indices);
        }

        public static /* synthetic */ Mesh copy$default(Mesh mesh, float[] fArray, float[] fArray2, float[] fArray3, int[] nArray, int n, Object object) {
            if ((n & 1) != 0) {
                fArray = mesh.positions;
            }
            if ((n & 2) != 0) {
                fArray2 = mesh.normals;
            }
            if ((n & 4) != 0) {
                fArray3 = mesh.uvs;
            }
            if ((n & 8) != 0) {
                nArray = mesh.indices;
            }
            return mesh.copy(fArray, fArray2, fArray3, nArray);
        }

        @NotNull
        public String toString() {
            return "Mesh(positions=" + Arrays.toString(this.positions) + ", normals=" + Arrays.toString(this.normals) + ", uvs=" + Arrays.toString(this.uvs) + ", indices=" + Arrays.toString(this.indices) + ")";
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.positions);
            result = result * 31 + Arrays.hashCode(this.normals);
            result = result * 31 + Arrays.hashCode(this.uvs);
            result = result * 31 + Arrays.hashCode(this.indices);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mesh)) {
                return false;
            }
            Mesh mesh = (Mesh)other;
            if (!Intrinsics.areEqual((Object)this.positions, (Object)mesh.positions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normals, (Object)mesh.normals)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uvs, (Object)mesh.uvs)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.indices, (Object)mesh.indices);
        }
    }
}

