/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.clock;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkSounds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\n\u0010+\u001a\u0006\u0012\u0002\b\u00030*\u0012\b\u0010-\u001a\u0004\u0018\u00010,\u0012\b\u0010/\u001a\u0004\u0018\u00010.\u00a2\u0006\u0004\b0\u00101J\u0017\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u00020\u00042\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\rR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\"\u0010\u0019\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\"\u0010\u001c\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\"\u0010\u001f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\u0006R\"\u0010$\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\"\"\u0004\b&\u0010\u0006R\"\u0010'\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010 \u001a\u0004\b(\u0010\"\"\u0004\b)\u0010\u0006\u00a8\u00062"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/clock/ClockBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "", "trailerAnim", "", "calcHandRotation", "(Z)V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "triggerTrailerAnim", "()V", "tick", "", "secondHandTargetRotation", "D", "getSecondHandTargetRotation", "()D", "setSecondHandTargetRotation", "(D)V", "minuteHandTargetRotation", "getMinuteHandTargetRotation", "setMinuteHandTargetRotation", "hourHandTargetRotation", "getHourHandTargetRotation", "setHourHandTargetRotation", "trailerAnimProgress", "getTrailerAnimProgress", "setTrailerAnimProgress", "doingTrailerAnim", "Z", "getDoingTrailerAnim", "()Z", "setDoingTrailerAnim", "tickTock", "getTickTock", "setTickTock", "startedSong", "getStartedSong", "setStartedSong", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class ClockBlockEntity
extends SmartBlockEntity {
    private double secondHandTargetRotation;
    private double minuteHandTargetRotation;
    private double hourHandTargetRotation;
    private double trailerAnimProgress;
    private boolean doingTrailerAnim;
    private boolean tickTock;
    private boolean startedSong;

    public ClockBlockEntity(@NotNull BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(type, pos, state);
        this.trailerAnimProgress = -1.0;
    }

    public final double getSecondHandTargetRotation() {
        return this.secondHandTargetRotation;
    }

    public final void setSecondHandTargetRotation(double d) {
        this.secondHandTargetRotation = d;
    }

    public final double getMinuteHandTargetRotation() {
        return this.minuteHandTargetRotation;
    }

    public final void setMinuteHandTargetRotation(double d) {
        this.minuteHandTargetRotation = d;
    }

    public final double getHourHandTargetRotation() {
        return this.hourHandTargetRotation;
    }

    public final void setHourHandTargetRotation(double d) {
        this.hourHandTargetRotation = d;
    }

    public final double getTrailerAnimProgress() {
        return this.trailerAnimProgress;
    }

    public final void setTrailerAnimProgress(double d) {
        this.trailerAnimProgress = d;
    }

    public final boolean getDoingTrailerAnim() {
        return this.doingTrailerAnim;
    }

    public final void setDoingTrailerAnim(boolean bl) {
        this.doingTrailerAnim = bl;
    }

    public final boolean getTickTock() {
        return this.tickTock;
    }

    public final void setTickTock(boolean bl) {
        this.tickTock = bl;
    }

    public final boolean getStartedSong() {
        return this.startedSong;
    }

    public final void setStartedSong(boolean bl) {
        this.startedSong = bl;
    }

    public final void calcHandRotation(boolean trailerAnim) {
        if (!trailerAnim) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            long time = level.m_46468_();
            long hours = time / (long)2000;
            double minutes = (double)(time % (long)2000) / 33.333;
            double seconds = (double)time % 33.333 * 1.800018000180002;
            this.secondHandTargetRotation = AngleHelper.rad((double)(seconds % 60.0 * 6.0));
            this.minuteHandTargetRotation = AngleHelper.rad((double)(minutes % 60.0 * 6.0));
            this.hourHandTargetRotation = AngleHelper.rad((double)((double)hours % 12.0 * 30.0));
        } else if (this.trailerAnimProgress > -1.0) {
            if (this.secondHandTargetRotation < Math.toRadians(390.0)) {
                this.secondHandTargetRotation = Math.toRadians(this.trailerAnimProgress * 390.0);
            }
        } else {
            this.secondHandTargetRotation = 0.0;
        }
    }

    public static /* synthetic */ void calcHandRotation$default(ClockBlockEntity clockBlockEntity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        clockBlockEntity.calcHandRotation(bl);
    }

    public void addBehaviours(@Nullable List<BlockEntityBehaviour> behaviours) {
    }

    public final void triggerTrailerAnim() {
        this.doingTrailerAnim = true;
        this.trailerAnimProgress = 0.0;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        boolean bl = level != null ? level.f_46443_ : false;
        if (bl) {
            if (!this.doingTrailerAnim && this.trailerAnimProgress > -1.0) {
                this.trailerAnimProgress = -1.0;
            }
        } else {
            this.calcHandRotation(this.doingTrailerAnim);
            if ((int)(Math.toDegrees(this.secondHandTargetRotation) % (double)12) == 0 && !this.doingTrailerAnim) {
                if (this.tickTock) {
                    this.tickTock = false;
                    Level level2 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level2);
                    SoundEvent soundEvent = ClockworkSounds.INSTANCE.getTOCK().getMainEvent();
                    Intrinsics.checkNotNull((Object)soundEvent);
                    level2.m_5594_(null, this.f_58858_, soundEvent, SoundSource.BLOCKS, 0.5f, 1.0f);
                } else {
                    this.tickTock = true;
                    Level level3 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level3);
                    SoundEvent soundEvent = ClockworkSounds.INSTANCE.getTICK().getMainEvent();
                    Intrinsics.checkNotNull((Object)soundEvent);
                    level3.m_5594_(null, this.f_58858_, soundEvent, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            }
            if (this.doingTrailerAnim && !this.startedSong) {
                this.startedSong = true;
                Level level4 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level4);
                SoundEvent soundEvent = ClockworkSounds.INSTANCE.getCLOCK_SONG().getMainEvent();
                Intrinsics.checkNotNull((Object)soundEvent);
                level4.m_5594_(null, this.f_58858_, soundEvent, SoundSource.MUSIC, 1.0f, 1.0f);
            }
        }
    }
}

