/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.contraption;

import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkContraptions;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0019\b\u0016\u0018\u0000 D2\u00020\u0001:\u0001DB\t\b\u0016\u00a2\u0006\u0004\bB\u0010CB\u0013\b\u0016\u0012\b\u0010(\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\bB\u0010;J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ=\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J3\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#J'\u0010&\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010*\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b*\u0010+R\"\u0010-\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R*\u00104\u001a\u00020,2\u0006\u00103\u001a\u00020,8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010.\u001a\u0004\b5\u00100\"\u0004\b6\u00102R.\u0010(\u001a\u0004\u0018\u00010\t2\b\u00103\u001a\u0004\u0018\u00010\t8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010<\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006E"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "Lcom/simibubi/create/content/contraptions/Contraption;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "assemble", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/core/Direction;", "direction", "Ljava/util/Queue;", "frontier", "", "visited", "moveBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Direction;Ljava/util/Queue;Ljava/util/Set;)Z", "searchMovedStructure", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z", "Lcom/simibubi/create/api/contraption/ContraptionType;", "getType", "()Lcom/simibubi/create/api/contraption/ContraptionType;", "isAnchoringBlockAt", "(Lnet/minecraft/core/BlockPos;)Z", "level", "Lorg/apache/commons/lang3/tuple/Pair;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "capture", "", "addBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lorg/apache/commons/lang3/tuple/Pair;)V", "spawnPacket", "Lnet/minecraft/nbt/CompoundTag;", "writeNBT", "(Z)Lnet/minecraft/nbt/CompoundTag;", "tag", "spawnData", "readNBT", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/nbt/CompoundTag;Z)V", "facing", "localPos", "canBeStabilized", "(Lnet/minecraft/core/Direction;Lnet/minecraft/core/BlockPos;)Z", "", "offset", "I", "getOffset", "()I", "setOffset", "(I)V", "value", "sailBlocks", "getSailBlocks", "setSailBlocks", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "setFacing", "(Lnet/minecraft/core/Direction;)V", "brass", "Z", "getBrass", "()Z", "setBrass", "(Z)V", "<init>", "()V", "Companion", "clockwork"})
public class PropellerContraption
extends Contraption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int offset;
    private int sailBlocks;
    @Nullable
    private Direction facing;
    private boolean brass;

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getSailBlocks() {
        return this.sailBlocks;
    }

    protected final void setSailBlocks(int n) {
        this.sailBlocks = n;
    }

    @Nullable
    public final Direction getFacing() {
        return this.facing;
    }

    protected final void setFacing(@Nullable Direction direction) {
        this.facing = direction;
    }

    public final boolean getBrass() {
        return this.brass;
    }

    public final void setBrass(boolean bl) {
        this.brass = bl;
    }

    public PropellerContraption() {
    }

    public PropellerContraption(@Nullable Direction facing) {
        this.facing = facing;
    }

    public boolean assemble(@NotNull Level world, @NotNull BlockPos pos) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.searchMovedStructure(world, pos, this.facing);
    }

    protected boolean moveBlock(@NotNull Level world, @Nullable Direction direction, @NotNull Queue<BlockPos> frontier, @NotNull Set<? extends BlockPos> visited) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(frontier, (String)"frontier");
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        return super.moveBlock(world, direction, frontier, visited);
    }

    public boolean searchMovedStructure(@NotNull Level world, @NotNull BlockPos pos, @Nullable Direction direction) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Direction direction2 = this.facing;
        Intrinsics.checkNotNull((Object)direction2);
        this.anchor = pos.m_5484_(direction2, this.offset + 1);
        if (this.bounds == null) {
            this.bounds = new AABB(BlockPos.f_121853_);
        }
        Direction direction3 = this.facing;
        Intrinsics.checkNotNull((Object)direction3);
        BlockState propellerBlock = world.m_8055_(pos.m_5484_(direction3, this.offset + 1));
        if (propellerBlock.m_60713_((Block)ClockworkBlocks.BLADE_CONTROLLER.get())) {
            Direction blockFacing = (Direction)propellerBlock.m_61143_((Property)BlockStateProperties.f_61372_);
            if (blockFacing != this.facing) {
                throw Companion.controllerWrongWay();
            }
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            Direction direction4 = this.facing;
            Intrinsics.checkNotNull((Object)direction4);
            queue.add(pos.m_5484_(direction4, this.offset + 1));
            return this.moveBlock(world, this.facing, (Queue<BlockPos>)queue, new HashSet());
        }
        if (this.brass) {
            return super.searchMovedStructure(world, pos.m_5484_(direction, this.offset + 1), null);
        }
        throw Companion.notProp();
    }

    @NotNull
    public ContraptionType getType() {
        Object object = ClockworkContraptions.INSTANCE.getPROPELLER().m_203334_();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        return (ContraptionType)object;
    }

    protected boolean isAnchoringBlockAt(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Direction direction = this.facing;
        Intrinsics.checkNotNull((Object)direction);
        return Intrinsics.areEqual((Object)pos, (Object)this.anchor.m_5484_(direction.m_122424_(), this.offset + 1));
    }

    public void addBlock(@NotNull Level level, @NotNull BlockPos pos, @NotNull Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(capture, (String)"capture");
        BlockPos localPos = pos.m_121996_((Vec3i)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && AllTags.AllBlockTags.WINDMILL_SAILS.matches(((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_())) {
            int n = this.sailBlocks;
            this.sailBlocks = n + 1;
        }
        super.addBlock(level, pos, capture);
    }

    @NotNull
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_(ClockworkConstants.Nbt.INSTANCE.getSAILS(), this.sailBlocks);
        String string = ClockworkConstants.Nbt.INSTANCE.getFACING();
        Direction direction = this.facing;
        Intrinsics.checkNotNull((Object)direction);
        tag.m_128405_(string, direction.m_122411_());
        tag.m_128405_(ClockworkConstants.Nbt.INSTANCE.getOFFSET(), this.offset);
        Intrinsics.checkNotNull((Object)tag);
        return tag;
    }

    public void readNBT(@NotNull Level world, @NotNull CompoundTag tag, boolean spawnData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.sailBlocks = tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getSAILS());
        this.facing = Direction.m_122376_((int)tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getFACING()));
        this.offset = tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getOFFSET());
        super.readNBT(world, tag, spawnData);
    }

    public boolean canBeStabilized(@NotNull Direction facing, @NotNull BlockPos localPos) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
        if (facing.m_122424_() == this.facing && Intrinsics.areEqual((Object)BlockPos.f_121853_, (Object)localPos)) {
            bl = false;
        } else {
            Direction.Axis axis = facing.m_122434_();
            Direction direction = this.facing;
            Intrinsics.checkNotNull((Object)direction);
            bl = axis == direction.m_122434_();
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final AssemblyException notProp() {
        return Companion.notProp();
    }

    @JvmStatic
    @NotNull
    public static final AssemblyException controllerWrongWay() {
        return Companion.controllerWrongWay();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption$Companion;", "", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/Direction;", "direction", "", "brass", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "assembleProp", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "notProp", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "controllerWrongWay", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PropellerContraption assembleProp(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction direction, boolean brass) throws AssemblyException {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            PropellerContraption contraption = new PropellerContraption();
            boolean flapBlocks = false;
            contraption.setFacing(direction);
            contraption.setBrass(brass);
            if (!contraption.assemble(world, pos)) {
                return null;
            }
            contraption.startMoving(world);
            contraption.expandBoundsAroundAxis(direction.m_122434_());
            return contraption;
        }

        @JvmStatic
        @NotNull
        public final AssemblyException notProp() {
            return new AssemblyException((Component)Component.m_237115_((String)"contraptions.propeller.not_prop"));
        }

        @JvmStatic
        @NotNull
        public final AssemblyException controllerWrongWay() {
            return new AssemblyException((Component)Component.m_237115_((String)"contraptions.propeller.controller_wrong_way"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

