/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.blades;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.AngleScrollValueBehaviour;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.LengthScrollValueBehaviour;
import org.valkyrienskies.clockwork.util.blocktype.ISyncableStorage;
import org.valkyrienskies.clockwork.util.blocktype.SyncableStoragePacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u0084\u0001\u0085\u0001B'\u0012\n\u0010~\u001a\u0006\u0012\u0002\b\u00030}\u0012\u0006\u0010\u007f\u001a\u00020L\u0012\b\u0010\u0081\u0001\u001a\u00030\u0080\u0001\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0083\u0001J\u001d\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u000f\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0012J\r\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u001f\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010#\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\r\u0010#\u001a\u00020\u000e\u00a2\u0006\u0004\b#\u0010%J\u000f\u0010&\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b&\u0010\u0012J\u000f\u0010'\u001a\u00020!H\u0016\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020!\u00a2\u0006\u0004\b)\u0010(J\r\u0010*\u001a\u00020!\u00a2\u0006\u0004\b*\u0010(J\r\u0010+\u001a\u00020!\u00a2\u0006\u0004\b+\u0010(J\u000f\u0010,\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010/\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020!H\u0016\u00a2\u0006\u0004\b/\u0010$J\u001f\u00101\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020!2\u0006\u00100\u001a\u00020!H\u0016\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020!H\u0016\u00a2\u0006\u0004\b3\u0010$J\u001f\u00105\u001a\u00020\u00062\u0006\u0010.\u001a\u00020!2\u0006\u00104\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b5\u00106J\u0017\u00109\u001a\u00020\u00192\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010>\u001a\u00020=2\u0006\u0010<\u001a\u00020;H\u0016\u00a2\u0006\u0004\b>\u0010?J)\u0010B\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020!2\u0006\u0010@\u001a\u00020\u000e2\b\u0010A\u001a\u0004\u0018\u00010;H\u0016\u00a2\u0006\u0004\bB\u0010CJ'\u0010D\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020!2\u0006\u00104\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020;H\u0016\u00a2\u0006\u0004\bD\u0010CJ\u001d\u0010G\u001a\u00020\u00062\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0EH\u0016\u00a2\u0006\u0004\bG\u0010HJ\u0015\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000e0EH\u0016\u00a2\u0006\u0004\bI\u0010JJ\u000f\u0010K\u001a\u00020!H\u0016\u00a2\u0006\u0004\bK\u0010(J\u000f\u0010M\u001a\u00020LH\u0016\u00a2\u0006\u0004\bM\u0010NR\"\u0010O\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010(\"\u0004\bR\u0010SR(\u0010T\u001a\b\u0012\u0004\u0012\u00020\u000e0E8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010U\u001a\u0004\bV\u0010J\"\u0004\bW\u0010HR\"\u0010X\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010\fR*\u0010_\u001a\n ^*\u0004\u0018\u00010]0]8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010`\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\"\u0010e\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010P\u001a\u0004\bf\u0010(\"\u0004\bg\u0010SR\"\u0010i\u001a\u00020h8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bi\u0010j\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\"\u0010p\u001a\u00020o8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bp\u0010q\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR.\u0010w\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020]0v8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010x\u001a\u0004\by\u0010z\"\u0004\b{\u0010|\u00a8\u0006\u0086\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lorg/valkyrienskies/clockwork/util/blocktype/ISyncableStorage;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "", "angle", "updateBladeAngle", "(D)V", "", "Lnet/minecraft/world/item/ItemStack;", "getAllBlades", "()Ljava/util/List;", "tick", "()V", "remove", "destroy", "invalidate", "dropBlades", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "blade", "insertBlade", "(Lnet/minecraft/world/item/ItemStack;)Z", "", "index", "removeBlade", "(I)Lnet/minecraft/world/item/ItemStack;", "()Lnet/minecraft/world/item/ItemStack;", "clearContent", "getContainerSize", "()I", "getOpenSpace", "getHighestTakenSlot", "getBladeCount", "isEmpty", "()Z", "slot", "getItem", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "stack", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "itemStack", "direction", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canTakeItemThroughFace", "Lnet/minecraft/core/NonNullList;", "storage", "sync", "(Lnet/minecraft/core/NonNullList;)V", "getStorageInventory", "()Lnet/minecraft/core/NonNullList;", "getStorageInventorySize", "Lnet/minecraft/core/BlockPos;", "getBlockPositionFromISS", "()Lnet/minecraft/core/BlockPos;", "previousBladeCount", "I", "getPreviousBladeCount", "setPreviousBladeCount", "(I)V", "blades", "Lnet/minecraft/core/NonNullList;", "getBlades", "setBlades", "bladeAngle", "D", "getBladeAngle", "()D", "setBladeAngle", "Lnet/createmod/catnip/animation/LerpedFloat;", "kotlin.jvm.PlatformType", "clientBladeAngle", "Lnet/createmod/catnip/animation/LerpedFloat;", "getClientBladeAngle", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setClientBladeAngle", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "bladeCooldown", "getBladeCooldown", "setBladeCooldown", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/AngleScrollValueBehaviour;", "angleController", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/AngleScrollValueBehaviour;", "getAngleController", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/AngleScrollValueBehaviour;", "setAngleController", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/AngleScrollValueBehaviour;)V", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/LengthScrollValueBehaviour;", "lengthController", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/LengthScrollValueBehaviour;", "getLengthController", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/LengthScrollValueBehaviour;", "setLengthController", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/LengthScrollValueBehaviour;)V", "", "clientBladeRotation", "Ljava/util/Map;", "getClientBladeRotation", "()Ljava/util/Map;", "setClientBladeRotation", "(Ljava/util/Map;)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "AngleControllerValueBoxTransform", "LengthControllerValueBoxTransform", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBladeControllerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BladeControllerBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n1863#2,2:363\n*S KotlinDebug\n*F\n+ 1 BladeControllerBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity\n*L\n141#1:363,2\n*E\n"})
public final class BladeControllerBlockEntity
extends SmartBlockEntity
implements ISyncableStorage {
    private int previousBladeCount;
    @NotNull
    private NonNullList<ItemStack> blades;
    private double bladeAngle;
    private LerpedFloat clientBladeAngle;
    private int bladeCooldown;
    public AngleScrollValueBehaviour angleController;
    public LengthScrollValueBehaviour lengthController;
    @NotNull
    private Map<Integer, LerpedFloat> clientBladeRotation;

    public BladeControllerBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        NonNullList nonNullList = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.blades = nonNullList;
        this.clientBladeAngle = LerpedFloat.angular().chase(this.bladeAngle, 0.5, LerpedFloat.Chaser.EXP);
        this.clientBladeRotation = MapsKt.withDefaultMutable((Map)new HashMap(), BladeControllerBlockEntity::clientBladeRotation$lambda$0);
    }

    public final int getPreviousBladeCount() {
        return this.previousBladeCount;
    }

    public final void setPreviousBladeCount(int n) {
        this.previousBladeCount = n;
    }

    @NotNull
    public final NonNullList<ItemStack> getBlades() {
        return this.blades;
    }

    public final void setBlades(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.blades = nonNullList;
    }

    public final double getBladeAngle() {
        return this.bladeAngle;
    }

    public final void setBladeAngle(double d) {
        this.bladeAngle = d;
    }

    public final LerpedFloat getClientBladeAngle() {
        return this.clientBladeAngle;
    }

    public final void setClientBladeAngle(LerpedFloat lerpedFloat) {
        this.clientBladeAngle = lerpedFloat;
    }

    public final int getBladeCooldown() {
        return this.bladeCooldown;
    }

    public final void setBladeCooldown(int n) {
        this.bladeCooldown = n;
    }

    @NotNull
    public final AngleScrollValueBehaviour getAngleController() {
        AngleScrollValueBehaviour angleScrollValueBehaviour = this.angleController;
        if (angleScrollValueBehaviour != null) {
            return angleScrollValueBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"angleController");
        return null;
    }

    public final void setAngleController(@NotNull AngleScrollValueBehaviour angleScrollValueBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)angleScrollValueBehaviour), (String)"<set-?>");
        this.angleController = angleScrollValueBehaviour;
    }

    @NotNull
    public final LengthScrollValueBehaviour getLengthController() {
        LengthScrollValueBehaviour lengthScrollValueBehaviour = this.lengthController;
        if (lengthScrollValueBehaviour != null) {
            return lengthScrollValueBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lengthController");
        return null;
    }

    public final void setLengthController(@NotNull LengthScrollValueBehaviour lengthScrollValueBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)lengthScrollValueBehaviour), (String)"<set-?>");
        this.lengthController = lengthScrollValueBehaviour;
    }

    @NotNull
    public final Map<Integer, LerpedFloat> getClientBladeRotation() {
        return this.clientBladeRotation;
    }

    public final void setClientBladeRotation(@NotNull Map<Integer, LerpedFloat> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.clientBladeRotation = map;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        MutableComponent mutableComponent = Component.m_237115_((String)"vs_clockwork.blade_controller.angle");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        this.setAngleController(new AngleScrollValueBehaviour((Component)mutableComponent, this, (ValueBoxTransform)new AngleControllerValueBoxTransform()));
        this.getAngleController().between(-180, 180);
        this.getAngleController().withCallback(arg_0 -> BladeControllerBlockEntity.addBehaviours$lambda$1(this, arg_0));
        behaviours.add((BlockEntityBehaviour)this.getAngleController());
    }

    public final void updateBladeAngle(double angle) {
        block3: {
            block2: {
                if (this.f_58857_ == null) break block2;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                if (!level.f_46443_) break block3;
            }
            return;
        }
        this.bladeAngle = angle;
        this.notifyUpdate();
    }

    @NotNull
    public final List<ItemStack> getAllBlades() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.m_7983_()) {
            return list;
        }
        int n = ((Collection)this.blades).size();
        for (int i = 0; i < n; ++i) {
            if (((ItemStack)this.blades.get(i)).m_41619_()) continue;
            list.add(this.blades.get(i));
        }
        return list;
    }

    public void tick() {
        super.tick();
        if (this.bladeCooldown > 0) {
            int n = this.bladeCooldown;
            this.bladeCooldown = n + -1;
        }
        Level level = this.f_58857_;
        boolean bl = level != null ? level.f_46443_ : false;
        if (bl) {
            int i;
            int n;
            if (this.getBladeCount() == 0) {
                return;
            }
            double angleBetweenBlades = 360.0 / (double)this.getBladeCount();
            if (this.previousBladeCount != this.getBladeCount()) {
                n = ((Collection)this.blades).size();
                for (i = 0; i < n; ++i) {
                    LerpedFloat lerpedFloat = this.clientBladeRotation.get(i);
                    if (lerpedFloat != null && (lerpedFloat = lerpedFloat.chase(angleBetweenBlades * (double)i, 0.5, LerpedFloat.Chaser.EXP)) != null) continue;
                    BladeControllerBlockEntity $this$tick_u24lambda_u242 = this;
                    boolean bl2 = false;
                    Integer n2 = i;
                    $this$tick_u24lambda_u242.clientBladeRotation.put(n2, LerpedFloat.linear().chase(angleBetweenBlades * (double)i, 0.5, LerpedFloat.Chaser.EXP));
                    lerpedFloat = Unit.INSTANCE;
                }
                this.previousBladeCount = this.getBladeCount();
            }
            this.clientBladeAngle.tickChaser();
            n = ((Collection)this.blades).size();
            for (i = 0; i < n; ++i) {
                LerpedFloat lerpedFloat = this.clientBladeRotation.get(i);
                if (lerpedFloat == null) continue;
                lerpedFloat.tickChaser();
            }
        }
        Level level2 = this.f_58857_;
        boolean bl3 = level2 != null ? !level2.m_5776_() : false;
        if (bl3) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel sLevel = (ServerLevel)level3;
            if (this.previousBladeCount != this.getBladeCount()) {
                ClockworkPackets.Companion.sendToNear((Level)sLevel, this.f_58858_, 64, new SyncableStoragePacket(this));
                this.previousBladeCount = this.getBladeCount();
            }
        }
    }

    public void remove() {
        super.remove();
    }

    public void destroy() {
        this.dropBlades();
        super.destroy();
    }

    public void invalidate() {
        super.invalidate();
    }

    public final void dropBlades() {
        if (this.f_58857_ != null && this.f_58857_ instanceof ServerLevel) {
            Iterable $this$forEach$iv = (Iterable)this.blades;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level);
                ItemEntity itemEntity = new ItemEntity(level, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, it);
                Vec3 vec3 = itemEntity.m_20184_().m_82520_(0.0, 0.5, 0.0);
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                vec3.m_82490_((double)(level2.f_46441_.m_188501_() * 0.3f));
                Level level3 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level3);
                level3.m_7967_((Entity)itemEntity);
            }
        }
        this.m_6211_();
    }

    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                super.read(tag, clientPacket);
                CompoundTag bladesTag = tag.m_128469_("Blades");
                ContainerHelper.m_18980_((CompoundTag)bladesTag, this.blades);
                this.bladeCooldown = tag.m_128451_("BladeCooldown");
                this.bladeAngle = tag.m_128459_("BladeAngle");
                if (tag.m_128441_("ScrollValue")) {
                    this.bladeAngle = tag.m_128459_("ScrollValue");
                }
                if (clientPacket) break block4;
                Level level = this.f_58857_;
                boolean bl = level != null ? level.f_46443_ : false;
                if (!bl) break block5;
            }
            this.clientBladeAngle.updateChaseTarget((float)this.bladeAngle);
        }
    }

    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        CompoundTag bladesTag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)bladesTag, this.blades);
        tag.m_128365_("Blades", (Tag)bladesTag);
        tag.m_128405_("BladeCount", this.getBladeCount());
        tag.m_128405_("BladeCooldown", this.bladeCooldown);
        tag.m_128347_("BladeAngle", this.bladeAngle);
        super.write(tag, clientPacket);
    }

    public final boolean insertBlade(@NotNull ItemStack blade) {
        Intrinsics.checkNotNullParameter((Object)blade, (String)"blade");
        if (this.getBladeCount() < 8) {
            this.m_6836_(this.getOpenSpace(), blade);
            this.bladeCooldown = 10;
            this.sendData();
            return true;
        }
        return false;
    }

    @NotNull
    public final ItemStack removeBlade(int index) {
        Object object = this.blades.remove(index);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"removeAt(...)");
        return (ItemStack)object;
    }

    @NotNull
    public final ItemStack removeBlade() {
        if (this.m_7983_()) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack blade = this.m_7407_(this.getHighestTakenSlot(), 1);
        this.bladeCooldown = 10;
        this.sendData();
        return blade;
    }

    public void m_6211_() {
        this.blades.clear();
    }

    public int m_6643_() {
        return this.blades.size();
    }

    public final int getOpenSpace() {
        int found = -1;
        int n = ((Collection)this.blades).size();
        for (int i = 0; i < n; ++i) {
            if (!((ItemStack)this.blades.get(i)).m_41619_()) continue;
            found = i;
            break;
        }
        return found;
    }

    public final int getHighestTakenSlot() {
        int found = -1;
        int n = ((Collection)this.blades).size();
        for (int i = 0; i < n; ++i) {
            if (((ItemStack)this.blades.get(i)).m_41619_()) continue;
            found = i;
        }
        return found;
    }

    public final int getBladeCount() {
        int found = 0;
        Iterator iterator = this.blades.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack blade = (ItemStack)iterator2.next();
            if (blade.m_41619_()) continue;
            ++found;
        }
        return found;
    }

    public boolean m_7983_() {
        boolean found = false;
        Iterator iterator = this.blades.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack blade = (ItemStack)iterator2.next();
            if (blade.m_41619_()) continue;
            found = true;
            break;
        }
        return !found;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        Object object = this.blades.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_((List)((List)this.blades), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack itemStack = ContainerHelper.m_18966_((List)((List)this.blades), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
        return itemStack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_150930_((Item)ClockworkItems.PROPELLER_BLADE.get()) || stack.m_150930_((Item)ClockworkItems.WIDE_PROPELLER_BLADE.get())) {
            this.blades.set(slot, (Object)stack);
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return level.m_7702_(this.f_58858_) == this;
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int[] arr = new int[8];
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        return arr;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return itemStack.m_150930_((Item)ClockworkItems.PROPELLER_BLADE.get()) || itemStack.m_150930_((Item)ClockworkItems.WIDE_PROPELLER_BLADE.get());
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }

    @Override
    public void sync(@NotNull NonNullList<ItemStack> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.blades = storage;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getStorageInventory() {
        return this.blades;
    }

    @Override
    public int getStorageInventorySize() {
        return 8;
    }

    @Override
    @NotNull
    public BlockPos getBlockPositionFromISS() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    private static final LerpedFloat clientBladeRotation$lambda$0(int it) {
        LerpedFloat lerpedFloat = LerpedFloat.linear().chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
        Intrinsics.checkNotNullExpressionValue((Object)lerpedFloat, (String)"chase(...)");
        return lerpedFloat;
    }

    private static final void addBehaviours$lambda$1(BladeControllerBlockEntity this$0, Integer i) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateBladeAngle(i.intValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity$AngleControllerValueBoxTransform;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform$Sided;", "Lnet/minecraft/world/phys/Vec3;", "getSouthLocation", "()Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/level/LevelAccessor;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "getLocalOffset", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/Vec3;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "rotate", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "Lnet/minecraft/core/Direction;", "direction", "", "isSideActive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z", "<init>", "()V", "clockwork"})
    public static final class AngleControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        @NotNull
        protected Vec3 getSouthLocation() {
            Vec3 vec3 = VecHelper.voxelSpace((double)8.0, (double)8.0, (double)18.5);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"voxelSpace(...)");
            return vec3;
        }

        @NotNull
        public Vec3 getLocalOffset(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Vec3 vec3 = super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_()).m_82490_(-0.125));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            return vec3;
        }

        public void rotate(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull PoseStack ms) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            if (!this.getSide().m_122434_().m_122479_()) {
                TransformStack.of((PoseStack)ms).rotateYDegrees(AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))) + (float)180);
            }
            super.rotate(level, pos, state, ms);
        }

        protected boolean isSideActive(@NotNull BlockState state, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return direction == facing;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeControllerBlockEntity$LengthControllerValueBoxTransform;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform$Sided;", "Lnet/minecraft/world/phys/Vec3;", "getSouthLocation", "()Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/level/LevelAccessor;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "getLocalOffset", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/Vec3;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "rotate", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "Lnet/minecraft/core/Direction;", "direction", "", "isSideActive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z", "<init>", "()V", "clockwork"})
    public static final class LengthControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        @NotNull
        protected Vec3 getSouthLocation() {
            Vec3 vec3 = VecHelper.voxelSpace((double)12.0, (double)8.0, (double)18.5);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"voxelSpace(...)");
            return vec3;
        }

        @NotNull
        public Vec3 getLocalOffset(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Vec3 vec3 = super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_()).m_82490_(-0.125));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            return vec3;
        }

        public void rotate(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull PoseStack ms) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            if (!this.getSide().m_122434_().m_122479_()) {
                TransformStack.of((PoseStack)ms).rotateYDegrees(AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))) + (float)180);
            }
            super.rotate(level, pos, state, ms);
        }

        protected boolean isSideActive(@NotNull BlockState state, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return direction == facing;
        }
    }
}

