/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.lang.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.ClockworkSoundScapes;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.propeller.blades.BladeData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.contraption.PropellerContraption;
import org.valkyrienskies.clockwork.content.contraptions.propeller.copter.CopterBearingBlock;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropCreateData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropData;
import org.valkyrienskies.clockwork.content.contraptions.propeller.data.PropUpdateData;
import org.valkyrienskies.clockwork.content.forces.MultiInstanceForceApplier;
import org.valkyrienskies.clockwork.content.forces.PropellerController;
import org.valkyrienskies.clockwork.content.generic.IForceApplierBE;
import org.valkyrienskies.clockwork.util.sound.PropellerSoundInstance;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b4\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00c8\u00012\u00020\u00012\u00020\u00022\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003:\u0004\u00c9\u0001\u00c8\u0001B4\u0012\f\u0010\u00c2\u0001\u001a\u0007\u0012\u0002\b\u00030\u00c1\u0001\u0012\u0007\u0010\u00c3\u0001\u001a\u00020B\u0012\b\u0010\u00c5\u0001\u001a\u00030\u00c4\u0001\u0012\b\b\u0002\u0010Z\u001a\u00020 \u00a2\u0006\u0006\b\u00c6\u0001\u0010\u00c7\u0001J\u000f\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\r\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\r\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\r\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0015\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u0017\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u000eJ\u000f\u0010\u001c\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\r\u0010\u001d\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u000eJ\u0015\u0010\"\u001a\u00020\f2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010&\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020 H\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b(\u0010\u000eJ\u0017\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b.\u0010\u000eJ\u0017\u00101\u001a\u00020\f2\u0006\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b1\u00102J\u001f\u00106\u001a\u00020\f2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010403H\u0016\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020 \u00a2\u0006\u0004\b8\u00109J\u0017\u0010;\u001a\u00020 2\u0006\u0010*\u001a\u00020:H\u0016\u00a2\u0006\u0004\b;\u0010<J\u0019\u0010=\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0004\b=\u0010>J\r\u0010?\u001a\u00020\f\u00a2\u0006\u0004\b?\u0010\u000eJ\u000f\u0010@\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b@\u0010\u000eJ\u000f\u0010A\u001a\u00020 H\u0016\u00a2\u0006\u0004\bA\u00109J\u000f\u0010C\u001a\u00020BH\u0016\u00a2\u0006\u0004\bC\u0010DJ\u0017\u0010F\u001a\u00020/2\u0006\u0010E\u001a\u00020/H\u0016\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010H\u001a\u00020 H\u0016\u00a2\u0006\u0004\bH\u00109J\u0017\u0010J\u001a\u00020\f2\u0006\u0010I\u001a\u00020/H\u0016\u00a2\u0006\u0004\bJ\u00102J\u001f\u0010N\u001a\u00020\f2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020 H\u0014\u00a2\u0006\u0004\bN\u0010OJ\u001f\u0010P\u001a\u00020\f2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020 H\u0014\u00a2\u0006\u0004\bP\u0010OJ\u000f\u0010Q\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bQ\u0010\u000eJ\u0019\u0010T\u001a\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020S0R\u00a2\u0006\u0004\bT\u0010UJ\u001b\u0010W\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020V0RH\u0004\u00a2\u0006\u0004\bW\u0010UJ\u000f\u0010X\u001a\u00020/H\u0016\u00a2\u0006\u0004\bX\u0010YR\u0017\u0010Z\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\bZ\u0010[\u001a\u0004\b\\\u00109R(\u0010^\u001a\b\u0012\u0004\u0012\u00020]038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010_\u001a\u0004\b`\u0010a\"\u0004\bb\u00107R(\u0010d\u001a\b\u0012\u0004\u0012\u00020c038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010_\u001a\u0004\b\u0012\u0010a\"\u0004\be\u00107R\"\u0010f\u001a\u00020V8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bf\u0010g\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR$\u0010l\u001a\u0004\u0018\u00010+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bl\u0010m\u001a\u0004\bn\u0010o\"\u0004\bp\u0010>R$\u0010r\u001a\u0004\u0018\u00010q8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\br\u0010s\u001a\u0004\bt\u0010u\"\u0004\bv\u0010wR\"\u0010x\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bx\u0010y\u001a\u0004\bz\u0010\u001e\"\u0004\b{\u0010\u0016R\"\u0010|\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b|\u0010y\u001a\u0004\b}\u0010\u001e\"\u0004\b~\u0010\u0016R$\u0010\u007f\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0004\b\u007f\u0010y\u001a\u0005\b\u0080\u0001\u0010\u001e\"\u0005\b\u0081\u0001\u0010\u0016R%\u0010\u0082\u0001\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0005\b\u0082\u0001\u0010y\u001a\u0005\b\u0083\u0001\u0010\u001e\"\u0004\bJ\u0010\u0016R&\u0010\u0084\u0001\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0084\u0001\u0010y\u001a\u0005\b\u0085\u0001\u0010\u001e\"\u0005\b\u0086\u0001\u0010\u0016R&\u0010\u0087\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0087\u0001\u0010[\u001a\u0005\b\u0088\u0001\u00109\"\u0005\b\u0089\u0001\u0010#R&\u0010\u008a\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u008a\u0001\u0010[\u001a\u0005\b\u008b\u0001\u00109\"\u0005\b\u008c\u0001\u0010#R&\u0010\u008d\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u008d\u0001\u0010[\u001a\u0005\b\u008e\u0001\u00109\"\u0005\b\u008f\u0001\u0010#R&\u0010\u0090\u0001\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0090\u0001\u0010y\u001a\u0005\b\u0091\u0001\u0010\u001e\"\u0005\b\u0092\u0001\u0010\u0016R&\u0010\u0093\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0093\u0001\u0010[\u001a\u0005\b\u0094\u0001\u00109\"\u0005\b\u0095\u0001\u0010#R&\u0010\u0096\u0001\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0096\u0001\u0010y\u001a\u0005\b\u0097\u0001\u0010\u001e\"\u0005\b\u0098\u0001\u0010\u0016R&\u0010\u0099\u0001\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0099\u0001\u0010y\u001a\u0005\b\u009a\u0001\u0010\u001e\"\u0005\b\u009b\u0001\u0010\u0016R&\u0010\u009c\u0001\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u009c\u0001\u0010[\u001a\u0005\b\u009d\u0001\u00109\"\u0005\b\u009e\u0001\u0010#R&\u0010\u009f\u0001\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u009f\u0001\u0010g\u001a\u0005\b\u00a0\u0001\u0010i\"\u0005\b\u00a1\u0001\u0010kR'\u0010\u00a2\u0001\u001a\u00020/8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0006\b\u00a2\u0001\u0010\u00a3\u0001\u001a\u0005\b\u00a4\u0001\u0010Y\"\u0005\b\u00a5\u0001\u00102R,\u0010\u00a7\u0001\u001a\u0005\u0018\u00010\u00a6\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a7\u0001\u0010\u00a8\u0001\u001a\u0006\b\u00a9\u0001\u0010\u00aa\u0001\"\u0006\b\u00ab\u0001\u0010\u00ac\u0001R1\u0010\u00af\u0001\u001a\n\u0012\u0005\u0012\u00030\u00ae\u00010\u00ad\u00018\u0006@\u0006X\u0086.\u00a2\u0006\u0018\n\u0006\b\u00af\u0001\u0010\u00b0\u0001\u001a\u0006\b\u00b1\u0001\u0010\u00b2\u0001\"\u0006\b\u00b3\u0001\u0010\u00b4\u0001R&\u0010\u00b5\u0001\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00b5\u0001\u0010g\u001a\u0005\b\u00b6\u0001\u0010i\"\u0005\b\u00b7\u0001\u0010kR&\u0010\u00b8\u0001\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00b8\u0001\u0010g\u001a\u0005\b\u00b9\u0001\u0010i\"\u0005\b\u00ba\u0001\u0010kR&\u0010\u00bb\u0001\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00bb\u0001\u0010g\u001a\u0005\b\u00bc\u0001\u0010i\"\u0005\b\u00bd\u0001\u0010kR&\u0010\u00be\u0001\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00be\u0001\u0010g\u001a\u0005\b\u00bf\u0001\u0010i\"\u0005\b\u00c0\u0001\u0010k\u00a8\u0006\u00ca\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lcom/simibubi/create/content/contraptions/bearing/IBearingBlockEntity;", "Lorg/valkyrienskies/clockwork/content/generic/IForceApplierBE;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropData;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropCreateData;", "Lorg/valkyrienskies/clockwork/content/forces/PropellerController;", "newCreateData", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropCreateData;", "newUpdateData", "()Lorg/valkyrienskies/clockwork/content/contraptions/propeller/data/PropUpdateData;", "", "invalidate", "()V", "clientInvalidate", "shutDown", "getSails", "getBlades", "", "bladeAngle", "setNewBladeAngle", "(D)V", "tickAudio", "angular", "backFromAngular", "(D)D", "tick", "applyPowerEffect", "getAngularSpeed", "()D", "remove", "", "negativeSpeed", "updateSpinDir", "(Z)V", "attachment", "shouldUpdate", "tickData", "(Lorg/valkyrienskies/clockwork/content/forces/PropellerController;Z)V", "assemble", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "contraption", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "createContraptionEntity", "(Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;)Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "disassemble", "", "previousSpeed", "onSpeedChanged", "(F)V", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "addBehaviours", "(Ljava/util/List;)V", "isInverted", "()Z", "Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;", "isAttachedTo", "(Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Z", "attach", "(Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;)V", "applyRotation", "onStall", "isValid", "Lnet/minecraft/core/BlockPos;", "getBlockPosition", "()Lnet/minecraft/core/BlockPos;", "partialTicks", "getInterpolatedAngle", "(F)F", "isWoodenTop", "forcedAngle", "setAngle", "Lnet/minecraft/nbt/CompoundTag;", "compound", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "lazyTick", "Lkotlin/Pair;", "Lnet/minecraft/core/Direction$Axis;", "getPowerDirections", "()Lkotlin/Pair;", "", "getPower", "calculateStressApplied", "()F", "brass", "Z", "getBrass", "Lorg/joml/Vector3ic;", "sailPositions", "Ljava/util/List;", "getSailPositions", "()Ljava/util/List;", "setSailPositions", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/blades/BladeData;", "blades", "setBlades", "physID", "I", "getPhysID", "()I", "setPhysID", "(I)V", "propellerContraption", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "getPropellerContraption", "()Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "setPropellerContraption", "Lorg/valkyrienskies/clockwork/util/sound/PropellerSoundInstance;", "soundInstance", "Lorg/valkyrienskies/clockwork/util/sound/PropellerSoundInstance;", "getSoundInstance", "()Lorg/valkyrienskies/clockwork/util/sound/PropellerSoundInstance;", "setSoundInstance", "(Lorg/valkyrienskies/clockwork/util/sound/PropellerSoundInstance;)V", "targetOmega", "D", "getTargetOmega", "setTargetOmega", "currentOmega", "getCurrentOmega", "setCurrentOmega", "previousOmega", "getPreviousOmega", "setPreviousOmega", "angle", "getAngle", "previousAngle", "getPreviousAngle", "setPreviousAngle", "active", "getActive", "setActive", "running", "getRunning", "setRunning", "starting", "getStarting", "setStarting", "startingProgress", "getStartingProgress", "setStartingProgress", "stopping", "getStopping", "setStopping", "disassemblyProgress", "getDisassemblyProgress", "setDisassemblyProgress", "totalDisassemblyTime", "getTotalDisassemblyTime", "setTotalDisassemblyTime", "assembleNextTick", "getAssembleNextTick", "setAssembleNextTick", "assembleCooldown", "getAssembleCooldown", "setAssembleCooldown", "clientAngleDiff", "F", "getClientAngleDiff", "setClientAngleDiff", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "setLastException", "(Lcom/simibubi/create/content/contraptions/AssemblyException;)V", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity$RotationDirection;", "rotationDirection", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "getRotationDirection", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "setRotationDirection", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;)V", "powerOne", "getPowerOne", "setPowerOne", "powerTwo", "getPowerTwo", "setPowerTwo", "lastPowerOne", "getLastPowerOne", "setLastPowerOne", "lastPowerTwo", "getLastPowerTwo", "setLastPowerTwo", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Companion", "RotationDirection", "clockwork"})
@SourceDebugExtension(value={"SMAP\nPropellerBearingBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropellerBearingBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,646:1\n1#2:647\n3829#3:648\n4344#3,2:649\n3829#3:651\n4344#3,2:652\n*S KotlinDebug\n*F\n+ 1 PropellerBearingBlockEntity.kt\norg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity\n*L\n586#1:648\n586#1:649,2\n595#1:651\n595#1:652,2\n*E\n"})
public class PropellerBearingBlockEntity
extends KineticBlockEntity
implements IBearingBlockEntity,
IForceApplierBE<PropUpdateData, PropData, PropCreateData, PropellerController> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean brass;
    @NotNull
    private List<Vector3ic> sailPositions;
    @NotNull
    private List<BladeData> blades;
    private int physID;
    @Nullable
    private ControlledContraptionEntity propellerContraption;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private PropellerSoundInstance soundInstance;
    private double targetOmega;
    private double currentOmega;
    private double previousOmega;
    private double angle;
    private double previousAngle;
    private boolean active;
    private volatile boolean running;
    private boolean starting;
    private double startingProgress;
    private volatile boolean stopping;
    private double disassemblyProgress;
    private double totalDisassemblyTime;
    private boolean assembleNextTick;
    private int assembleCooldown;
    private float clientAngleDiff;
    @Nullable
    private AssemblyException lastException;
    public ScrollOptionBehaviour<RotationDirection> rotationDirection;
    private int powerOne;
    private int powerTwo;
    private int lastPowerOne;
    private int lastPowerTwo;

    public PropellerBearingBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state, boolean brass) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.brass = brass;
        this.sailPositions = new ArrayList();
        this.blades = new ArrayList();
        this.physID = -1;
    }

    public /* synthetic */ PropellerBearingBlockEntity(BlockEntityType blockEntityType, BlockPos blockPos, BlockState blockState, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(blockEntityType, blockPos, blockState, bl);
    }

    public final boolean getBrass() {
        return this.brass;
    }

    @NotNull
    public final List<Vector3ic> getSailPositions() {
        return this.sailPositions;
    }

    public final void setSailPositions(@NotNull List<Vector3ic> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sailPositions = list;
    }

    @NotNull
    public final List<BladeData> getBlades() {
        return this.blades;
    }

    public final void setBlades(@NotNull List<BladeData> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.blades = list;
    }

    @Override
    public int getPhysID() {
        return this.physID;
    }

    @Override
    public void setPhysID(int n) {
        this.physID = n;
    }

    @Nullable
    public final ControlledContraptionEntity getPropellerContraption() {
        return this.propellerContraption;
    }

    public final void setPropellerContraption(@Nullable ControlledContraptionEntity controlledContraptionEntity) {
        this.propellerContraption = controlledContraptionEntity;
    }

    @Nullable
    public final PropellerSoundInstance getSoundInstance() {
        return this.soundInstance;
    }

    public final void setSoundInstance(@Nullable PropellerSoundInstance propellerSoundInstance) {
        this.soundInstance = propellerSoundInstance;
    }

    public final double getTargetOmega() {
        return this.targetOmega;
    }

    public final void setTargetOmega(double d) {
        this.targetOmega = d;
    }

    public final double getCurrentOmega() {
        return this.currentOmega;
    }

    public final void setCurrentOmega(double d) {
        this.currentOmega = d;
    }

    public final double getPreviousOmega() {
        return this.previousOmega;
    }

    public final void setPreviousOmega(double d) {
        this.previousOmega = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final double getPreviousAngle() {
        return this.previousAngle;
    }

    public final void setPreviousAngle(double d) {
        this.previousAngle = d;
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl) {
        this.active = bl;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    public final boolean getStarting() {
        return this.starting;
    }

    public final void setStarting(boolean bl) {
        this.starting = bl;
    }

    public final double getStartingProgress() {
        return this.startingProgress;
    }

    public final void setStartingProgress(double d) {
        this.startingProgress = d;
    }

    public final boolean getStopping() {
        return this.stopping;
    }

    public final void setStopping(boolean bl) {
        this.stopping = bl;
    }

    public final double getDisassemblyProgress() {
        return this.disassemblyProgress;
    }

    public final void setDisassemblyProgress(double d) {
        this.disassemblyProgress = d;
    }

    public final double getTotalDisassemblyTime() {
        return this.totalDisassemblyTime;
    }

    public final void setTotalDisassemblyTime(double d) {
        this.totalDisassemblyTime = d;
    }

    public final boolean getAssembleNextTick() {
        return this.assembleNextTick;
    }

    public final void setAssembleNextTick(boolean bl) {
        this.assembleNextTick = bl;
    }

    public final int getAssembleCooldown() {
        return this.assembleCooldown;
    }

    public final void setAssembleCooldown(int n) {
        this.assembleCooldown = n;
    }

    public final float getClientAngleDiff() {
        return this.clientAngleDiff;
    }

    public final void setClientAngleDiff(float f) {
        this.clientAngleDiff = f;
    }

    @Nullable
    public final AssemblyException getLastException() {
        return this.lastException;
    }

    public final void setLastException(@Nullable AssemblyException assemblyException) {
        this.lastException = assemblyException;
    }

    @NotNull
    public final ScrollOptionBehaviour<RotationDirection> getRotationDirection() {
        ScrollOptionBehaviour<RotationDirection> scrollOptionBehaviour = this.rotationDirection;
        if (scrollOptionBehaviour != null) {
            return scrollOptionBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rotationDirection");
        return null;
    }

    public final void setRotationDirection(@NotNull ScrollOptionBehaviour<RotationDirection> scrollOptionBehaviour) {
        Intrinsics.checkNotNullParameter(scrollOptionBehaviour, (String)"<set-?>");
        this.rotationDirection = scrollOptionBehaviour;
    }

    public final int getPowerOne() {
        return this.powerOne;
    }

    public final void setPowerOne(int n) {
        this.powerOne = n;
    }

    public final int getPowerTwo() {
        return this.powerTwo;
    }

    public final void setPowerTwo(int n) {
        this.powerTwo = n;
    }

    public final int getLastPowerOne() {
        return this.lastPowerOne;
    }

    public final void setLastPowerOne(int n) {
        this.lastPowerOne = n;
    }

    public final int getLastPowerTwo() {
        return this.lastPowerTwo;
    }

    public final void setLastPowerTwo(int n) {
        this.lastPowerTwo = n;
    }

    @Override
    @NotNull
    public PropCreateData newCreateData() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        Vector3ic vector3ic = (Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)blockPos));
        Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        return new PropCreateData(vector3ic, (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i), this.angle, this.currentOmega, new ArrayList(this.sailPositions), this.isInverted(), this.active, this.brass && this.blades.isEmpty(), new ArrayList(this.blades));
    }

    @Override
    @NotNull
    public PropUpdateData newUpdateData() {
        return new PropUpdateData(this.currentOmega, this.angle, this.isInverted(), this.active, new ArrayList(this.blades), null, null, this.lastStressApplied, 96, null);
    }

    public void invalidate() {
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (level.f_46443_) {
                this.clientInvalidate();
            }
        }
        super.invalidate();
    }

    public final void clientInvalidate() {
        PropellerSoundInstance propellerSoundInstance = this.soundInstance;
        if (propellerSoundInstance != null) {
            propellerSoundInstance.stopNow();
        }
        this.soundInstance = null;
    }

    public final void shutDown() {
        if (this.assembleCooldown > 0) {
            return;
        }
        this.assembleCooldown = 10;
        this.active = false;
        this.stopping = true;
        this.totalDisassemblyTime = this.disassemblyProgress = Math.abs(this.currentOmega);
        this.m_6596_();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getPROPELLER_STOP();
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            ClockworkSounds.SoundEntry.playOnServer$default(soundEntry, this.f_58857_, (Vec3i)blockPos, 0.75f, 0.0f, 8, null);
        }
        this.sendData();
    }

    public final void getSails() {
        this.sailPositions = new ArrayList();
        if (this.propellerContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            Map blocks = controlledContraptionEntity.getContraption().getBlocks();
            Intrinsics.checkNotNull((Object)blocks);
            for (Map.Entry entry : blocks.entrySet()) {
                BlockPos key = (BlockPos)entry.getKey();
                StructureTemplate.StructureBlockInfo value = (StructureTemplate.StructureBlockInfo)entry.getValue();
                if (!AllTags.AllBlockTags.WINDMILL_SAILS.matches(value.f_74676_())) continue;
                Intrinsics.checkNotNull((Object)key);
                this.sailPositions.add((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)key)));
            }
        }
    }

    public final void getBlades() {
        if (this.propellerContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            Map blocks = controlledContraptionEntity.getContraption().getBlocks();
            Intrinsics.checkNotNull((Object)blocks);
            for (Map.Entry entry : blocks.entrySet()) {
                BlockPos key = (BlockPos)entry.getKey();
                StructureTemplate.StructureBlockInfo value = (StructureTemplate.StructureBlockInfo)entry.getValue();
                if (!value.f_74676_().m_60713_((Block)ClockworkBlocks.BLADE_CONTROLLER.get())) continue;
                boolean shouldUpdate = true;
                if (value.f_74677_() == null) continue;
                CompoundTag compoundTag = value.f_74677_();
                Intrinsics.checkNotNull((Object)compoundTag);
                compoundTag.m_128379_("ShouldUpdatePhys", false);
                CompoundTag compoundTag2 = value.f_74677_();
                Intrinsics.checkNotNull((Object)compoundTag2);
                this.blades = BladeData.Companion.fromTag(compoundTag2);
            }
        }
    }

    public final void setNewBladeAngle(double bladeAngle) {
        if (this.propellerContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            Map blocks = controlledContraptionEntity.getContraption().getBlocks();
            Intrinsics.checkNotNull((Object)blocks);
            for (Map.Entry entry : blocks.entrySet()) {
                BlockPos key = (BlockPos)entry.getKey();
                StructureTemplate.StructureBlockInfo value = (StructureTemplate.StructureBlockInfo)entry.getValue();
                if (!value.f_74676_().m_60713_((Block)ClockworkBlocks.BLADE_CONTROLLER.get())) continue;
                CompoundTag compoundTag = value.f_74677_();
                if (compoundTag != null) {
                    compoundTag.m_128347_("BladeAngle", bladeAngle);
                }
                break;
            }
        }
    }

    public void tickAudio() {
        block9: {
            block10: {
                SoundEvent sound;
                block8: {
                    block7: {
                        if (this.f_58857_ == null) break block7;
                        Level level = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level);
                        if (level.f_46443_) break block8;
                    }
                    return;
                }
                if (!this.active || this.stopping || !(this.getAngularSpeed() > 2.0)) break block9;
                float pitch = Mth.m_14036_((float)((float)this.backFromAngular(Math.abs(this.currentOmega)) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
                if (!this.brass) {
                    ClockworkSoundScapes.AmbienceGroup scape = ClockworkSoundScapes.AmbienceGroup.RICKETY;
                    BlockPos blockPos = this.f_58858_;
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                    ClockworkSoundScapes.INSTANCE.play(scape, blockPos, pitch);
                }
                SoundEvent soundEvent = sound = this.brass ? ClockworkSounds.INSTANCE.getPROPELLER().getMainEvent() : ClockworkSounds.INSTANCE.getJUNK_PROPELLER().getMainEvent();
                if (sound == null) break block9;
                if (this.soundInstance == null) break block10;
                PropellerSoundInstance propellerSoundInstance = this.soundInstance;
                Intrinsics.checkNotNull((Object)((Object)propellerSoundInstance));
                if (!propellerSoundInstance.m_7801_()) break block9;
            }
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            RandomSource randomSource = level.f_46441_;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            this.soundInstance = new PropellerSoundInstance(this, randomSource);
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            PropellerSoundInstance propellerSoundInstance = this.soundInstance;
            Intrinsics.checkNotNull((Object)((Object)propellerSoundInstance));
            soundManager.m_120367_((SoundInstance)propellerSoundInstance);
        }
    }

    private final double backFromAngular(double angular) {
        return angular / 3.0 * 10.0;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            this.clientAngleDiff /= 2.0f;
        } else {
            if (this.assembleNextTick && this.assembleCooldown == 0) {
                this.assembleNextTick = false;
                this.assembleCooldown = 10;
                this.assemble();
            }
            if (this.assembleCooldown > 0) {
                int n = this.assembleCooldown;
                this.assembleCooldown = n + -1;
            }
        }
        if (!this.running) {
            return;
        }
        if (this.starting) {
            double d = this.startingProgress;
            this.startingProgress = d + 1.0;
        }
        if (this.startingProgress >= this.targetOmega) {
            this.starting = false;
            this.startingProgress = 0.0;
        }
        this.lastPowerOne = this.powerOne;
        this.lastPowerTwo = this.powerTwo;
        Pair<Integer, Integer> power = this.getPower();
        this.powerOne = ((Number)power.getFirst()).intValue();
        this.powerTwo = ((Number)power.getSecond()).intValue();
        this.previousAngle = this.angle;
        this.previousOmega = this.currentOmega;
        if (!this.stopping) {
            ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
            boolean stalled = controlledContraptionEntity != null ? controlledContraptionEntity.isStalled() : true;
            this.active = !this.overStressed && !stalled;
            this.updateSpinDir(this.currentOmega < 0.0);
            double lastTargetOmega = this.targetOmega;
            this.targetOmega = (double)KineticBlockEntity.convertToAngular((float)this.getSpeed()) * (this.isInverted() ? -1.0 : 1.0);
            if (!(lastTargetOmega == this.targetOmega)) {
                this.sendData();
            }
            this.currentOmega += Mth.m_14008_((double)((this.targetOmega - this.currentOmega) / 2.0 / (this.starting ? Math.abs(this.targetOmega) + 1.0 - Math.min(this.startingProgress, Math.abs(this.targetOmega)) : 1.0)), (double)KineticBlockEntity.convertToAngular((float)-32.0f), (double)KineticBlockEntity.convertToAngular((float)32.0f));
        } else {
            this.active = false;
            double stalled = this.disassemblyProgress;
            this.disassemblyProgress = stalled + -1.0;
            if (this.disassemblyProgress <= 0.0) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                if (!level2.f_46443_) {
                    ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
                    if (controlledContraptionEntity != null && (controlledContraptionEntity = controlledContraptionEntity.getContraption()) != null) {
                        Level level3 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level3);
                        controlledContraptionEntity.stop(level3);
                    }
                    this.disassemble();
                }
                this.stopping = false;
            } else {
                double stoppingPoint = this.angle + this.currentOmega * this.disassemblyProgress * 0.5;
                double optimalStoppingPoint = 90.0 * (double)Math.round(stoppingPoint / 90.0);
                double Q = (optimalStoppingPoint - stoppingPoint) / this.disassemblyProgress;
                this.currentOmega = (this.currentOmega + 6.0 * Q / this.disassemblyProgress) * (1.0 - 1.0 / this.disassemblyProgress);
            }
        }
        Level level4 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level4);
        if (!level4.f_46443_) {
            Level level5 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level5);
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            if (VSGameUtilsKt.getShipObjectManagingPos((Level)level5, (Vec3i)((Vec3i)blockPos)) != null) {
                Level level6 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level6, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level6;
                BlockPos blockPos2 = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos2));
                Intrinsics.checkNotNull((Object)loadedServerShip);
                LoadedServerShip shipOn = loadedServerShip;
                PropellerController propellerController = PropellerController.Companion.getOrCreate(shipOn);
                Intrinsics.checkNotNull((Object)propellerController);
                PropellerController attachment = propellerController;
                this.getBlades();
                this.tickData(attachment, true);
            }
        }
        if (this.propellerContraption != null && this.running) {
            float angularSpeed = (float)this.getAngularSpeed();
            float newAngle = (float)(this.angle + (double)angularSpeed);
            this.angle = newAngle % (float)360;
            this.applyPowerEffect();
        }
        this.applyRotation();
    }

    public void applyPowerEffect() {
        if (!this.brass || this.blades.isEmpty() || this.powerOne == 0 && this.powerTwo == 0) {
            return;
        }
        float powerEffect = Mth.m_14036_((float)((float)(this.powerOne + this.powerTwo) / 30.0f), (float)-1.0f, (float)1.0f);
        float angleChange = 2.0f * powerEffect;
        double currentAngle = this.blades.get(0).getAngle();
        double newAngle = (currentAngle + (double)angleChange) % (double)360.0f;
        this.setNewBladeAngle(newAngle);
        this.blades.clear();
        this.getBlades();
    }

    public final double getAngularSpeed() {
        double speed = this.currentOmega;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            speed *= (double)ServerSpeedProvider.get();
            speed += (double)this.clientAngleDiff / 3.0;
        }
        return speed;
    }

    public void remove() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    public final void updateSpinDir(boolean negativeSpeed) {
        if (!this.isInverted() && negativeSpeed || this.isInverted() && !negativeSpeed) {
            if (this.m_58900_().m_61143_((Property)PropellerBearingBlock.Companion.getSPIN_DIRECTION()) == PropellerBearingBlock.SpinDirection.PUSH) {
                return;
            }
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            level.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PropellerBearingBlock.Companion.getSPIN_DIRECTION(), (Comparable)((Object)PropellerBearingBlock.SpinDirection.PUSH)));
        } else if (!this.isInverted() && !negativeSpeed || this.isInverted() && negativeSpeed) {
            if (this.m_58900_().m_61143_((Property)PropellerBearingBlock.Companion.getSPIN_DIRECTION()) == PropellerBearingBlock.SpinDirection.PULL) {
                return;
            }
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            level.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PropellerBearingBlock.Companion.getSPIN_DIRECTION(), (Comparable)((Object)PropellerBearingBlock.SpinDirection.PULL)));
        }
    }

    @Override
    public void tickData(@NotNull PropellerController attachment, boolean shouldUpdate) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        if (this.running && this.propellerContraption != null) {
            IForceApplierBE.super.tickData((MultiInstanceForceApplier)attachment, shouldUpdate);
        } else {
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            this.removeApplier(PropellerController.class, this.f_58857_, blockPos);
        }
    }

    public void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof PropellerBearingBlock)) {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            if (!(level2.m_8055_(this.f_58858_).m_60734_() instanceof CopterBearingBlock)) {
                return;
            }
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        PropellerContraption contraption = null;
        try {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            Intrinsics.checkNotNull((Object)direction);
            PropellerContraption propellerContraption = PropellerContraption.Companion.assembleProp(level3, blockPos, direction, this.brass);
            Intrinsics.checkNotNull((Object)((Object)propellerContraption));
            contraption = propellerContraption;
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption.getBlocks().isEmpty()) {
            return;
        }
        BlockPos anchor = this.f_58858_.m_121945_(direction);
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption = this.createContraptionEntity(contraption);
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        ControlledContraptionEntity controlledContraptionEntity2 = this.propellerContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
        controlledContraptionEntity2.setRotationAxis(direction.m_122434_());
        ControlledContraptionEntity controlledContraptionEntity3 = this.propellerContraption;
        if (controlledContraptionEntity3 != null) {
            ControlledContraptionEntity it = controlledContraptionEntity3;
            boolean bl = false;
            Level level4 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level4);
            level4.m_7967_((Entity)it);
        }
        ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getPROPELLER_START();
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ClockworkSounds.SoundEntry.playOnServer$default(soundEntry, this.f_58857_, (Vec3i)blockPos, 0.0f, 0.0f, 12, null);
        this.running = true;
        this.starting = true;
        this.stopping = false;
        this.totalDisassemblyTime = 0.0;
        this.startingProgress = 0.0;
        this.angle = 0.0;
        this.currentOmega = 0.0;
        this.targetOmega = (double)KineticBlockEntity.convertToAngular((float)this.getSpeed()) * (this.isInverted() ? -1.0 : 1.0);
        this.getBlades();
        if (this.brass && this.blades.isEmpty()) {
            this.getSails();
        }
        float stressImpact = this.calculateStressApplied();
        KineticNetwork kineticNetwork = this.getOrCreateNetwork();
        if (kineticNetwork != null) {
            kineticNetwork.updateStressFor((KineticBlockEntity)this, stressImpact);
        }
        Level level5 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level5);
        if (!level5.f_46443_) {
            Level level6 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level6, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level6;
            BlockPos blockPos2 = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos2));
            if (ship != null) {
                PropellerController propellerController = PropellerController.Companion.getOrCreate(ship);
                Intrinsics.checkNotNull((Object)propellerController);
                this.tickData(propellerController, true);
            }
        }
        this.sendData();
    }

    @NotNull
    public ControlledContraptionEntity createContraptionEntity(@NotNull PropellerContraption contraption) {
        Intrinsics.checkNotNullParameter((Object)((Object)contraption), (String)"contraption");
        ControlledContraptionEntity controlledContraptionEntity = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)((IControlContraption)this), (Contraption)contraption);
        Intrinsics.checkNotNullExpressionValue((Object)controlledContraptionEntity, (String)"create(...)");
        return controlledContraptionEntity;
    }

    public void disassemble() {
        if (!this.running && this.propellerContraption == null) {
            return;
        }
        this.targetOmega = 0.0;
        this.currentOmega = 0.0;
        this.angle = 0.0;
        this.stopping = false;
        this.starting = false;
        this.startingProgress = 0.0;
        this.disassemblyProgress = 0.0;
        if (this.propellerContraption != null) {
            ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity);
            controlledContraptionEntity.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.propellerContraption = null;
        this.running = false;
        if (this.getPhysID() != -1) {
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            this.removeApplier(PropellerController.class, this.f_58857_, blockPos);
        }
        float stressImpact = this.calculateStressApplied();
        KineticNetwork kineticNetwork = this.getOrCreateNetwork();
        if (kineticNetwork != null) {
            kineticNetwork.updateStressFor((KineticBlockEntity)this, stressImpact);
        }
        this.sendData();
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.calculateStressApplied();
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
        this.setRotationDirection((ScrollOptionBehaviour<RotationDirection>)new ScrollOptionBehaviour(RotationDirection.class, (Component)ClockworkLang.translateDirect("contraptions.propeller.rotation_direction", new Object[0]), (SmartBlockEntity)this, this.getMovementModeSlot()));
        behaviours.add((BlockEntityBehaviour)this.getRotationDirection());
    }

    public final boolean isInverted() {
        return this.getRotationDirection().get() == RotationDirection.INVERTED;
    }

    public boolean isAttachedTo(@NotNull AbstractContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        return !(contraption.getContraption() instanceof PropellerContraption) ? false : this.propellerContraption == contraption;
    }

    public void attach(@Nullable ControlledContraptionEntity contraption) {
        BlockState blockState = this.m_58900_();
        ControlledContraptionEntity controlledContraptionEntity = contraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        if (!(controlledContraptionEntity.getContraption() instanceof PropellerContraption)) {
            return;
        }
        if (!blockState.m_61138_((Property)BearingBlock.FACING)) {
            return;
        }
        this.propellerContraption = contraption;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_121945_((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_));
        ControlledContraptionEntity controlledContraptionEntity2 = this.propellerContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
        controlledContraptionEntity2.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    public final void applyRotation() {
        if (this.propellerContraption == null) {
            return;
        }
        ControlledContraptionEntity controlledContraptionEntity = this.propellerContraption;
        Intrinsics.checkNotNull((Object)controlledContraptionEntity);
        controlledContraptionEntity.setAngle((float)this.angle);
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            ControlledContraptionEntity controlledContraptionEntity2 = this.propellerContraption;
            Intrinsics.checkNotNull((Object)controlledContraptionEntity2);
            controlledContraptionEntity2.setRotationAxis(((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_());
        }
    }

    public void onStall() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.targetOmega = 0.0;
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    @NotNull
    public BlockPos getBlockPosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    public float getInterpolatedAngle(float partialTicks) {
        float pT = partialTicks;
        if (this.isVirtual()) {
            return (float)Mth.m_14139_((double)(partialTicks + 0.5f), (double)this.previousAngle, (double)this.angle);
        }
        if (this.propellerContraption == null || !this.running) {
            pT = 0.0f;
        }
        double renderedOmega = !this.isInverted() ? Mth.m_14139_((double)pT, (double)this.getAngularSpeed(), (double)this.targetOmega) : Mth.m_14139_((double)pT, (double)(-this.getAngularSpeed()), (double)(-this.targetOmega));
        return (float)Mth.m_14139_((double)pT, (double)this.angle, (double)(this.angle + this.getAngularSpeed()));
    }

    public boolean isWoodenTop() {
        return false;
    }

    public void setAngle(float forcedAngle) {
        this.previousAngle = this.angle;
        this.angle = forcedAngle;
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.read(compound, clientPacket);
        double angleBefore = this.angle;
        if (compound.m_128441_("Stopping")) {
            if (clientPacket && !this.stopping && compound.m_128471_("Stopping")) {
                this.starting = false;
                this.startingProgress = 0.0;
                this.totalDisassemblyTime = this.disassemblyProgress = Math.abs(this.currentOmega);
            }
            this.stopping = compound.m_128471_("Stopping");
        }
        if (compound.m_128441_("Starting")) {
            if (clientPacket && !this.starting && compound.m_128471_("Starting")) {
                this.stopping = false;
                this.disassemblyProgress = 0.0;
                this.startingProgress = 0.0;
            }
            this.starting = compound.m_128471_("Starting");
        }
        if (compound.m_128441_("PhysID")) {
            this.setPhysID(compound.m_128451_("PhysID"));
        }
        if (compound.m_128441_("Running")) {
            this.running = compound.m_128471_("Running");
        }
        if (compound.m_128441_("Active")) {
            boolean bl = this.active = compound.m_128471_("Active") && !this.stopping;
        }
        if (compound.m_128441_("TargetOmega")) {
            this.targetOmega = compound.m_128459_("TargetOmega");
        }
        if (compound.m_128441_("CurrentOmega")) {
            this.currentOmega = compound.m_128459_("CurrentOmega");
        }
        if (compound.m_128441_("Angle")) {
            this.angle = compound.m_128459_("Angle");
        }
        if (compound.m_128441_("RotationDirection")) {
            this.getRotationDirection().setValue(compound.m_128451_("RotationDirection"));
        }
    }

    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128379_("Stopping", this.stopping);
        compound.m_128379_("Starting", this.starting);
        compound.m_128405_("PhysID", this.getPhysID());
        compound.m_128379_("Running", this.running);
        compound.m_128379_("Active", this.active);
        compound.m_128347_("TargetOmega", this.targetOmega);
        compound.m_128347_("CurrentOmega", this.currentOmega);
        compound.m_128347_("Angle", this.angle);
        compound.m_128405_("RotationDirection", this.getRotationDirection().getValue());
        super.write(compound, clientPacket);
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.running && this.propellerContraption != null) {
            this.sendData();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Direction.Axis, Direction.Axis> getPowerDirections() {
        void $this$filterTo$iv$iv;
        Direction.Axis[] $this$filter$iv = Direction.Axis.values();
        boolean $i$f$filter = false;
        Direction.Axis[] axisArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            Block block = this.m_58900_().m_60734_();
            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.simibubi.create.content.contraptions.bearing.BearingBlock");
            boolean bl2 = it != ((BearingBlock)block).getRotationAxis(this.m_58900_());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List perpendicularAxes = (List)destination$iv$iv;
        return TuplesKt.to(perpendicularAxes.get(0), perpendicularAxes.get(1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Pair<Integer, Integer> getPower() {
        void $this$filterTo$iv$iv;
        Direction.Axis[] $this$filter$iv = Direction.Axis.values();
        boolean $i$f$filter = false;
        Direction.Axis[] axisArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            Block block = this.m_58900_().m_60734_();
            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.simibubi.create.content.contraptions.bearing.BearingBlock");
            boolean bl2 = it != ((BearingBlock)block).getRotationAxis(this.m_58900_());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List perpendicularAxes = (List)destination$iv$iv;
        PropellerBearingBlockEntity $this$getPower_u24lambda_u243 = this;
        boolean bl = false;
        Direction positiveDir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)perpendicularAxes.get(0)));
        Direction negativeDir = positiveDir.m_122424_();
        int power = 0;
        Level level = $this$getPower_u24lambda_u243.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        power += level.m_277185_($this$getPower_u24lambda_u243.m_58899_().m_121945_(positiveDir), positiveDir);
        Level level2 = $this$getPower_u24lambda_u243.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        int powerOne = power -= level2.m_277185_($this$getPower_u24lambda_u243.m_58899_().m_121945_(negativeDir), negativeDir);
        PropellerBearingBlockEntity $this$getPower_u24lambda_u244 = this;
        boolean bl3 = false;
        Direction positiveDir2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)perpendicularAxes.get(1)));
        Direction negativeDir2 = positiveDir2.m_122424_();
        int power2 = 0;
        Level level3 = $this$getPower_u24lambda_u244.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        power2 += level3.m_277185_($this$getPower_u24lambda_u244.m_58899_().m_121945_(positiveDir2), positiveDir2);
        Level level4 = $this$getPower_u24lambda_u244.f_58857_;
        Intrinsics.checkNotNull((Object)level4);
        int powerTwo = power2 -= level4.m_277185_($this$getPower_u24lambda_u244.m_58899_().m_121945_(negativeDir2), negativeDir2);
        return TuplesKt.to((Object)powerOne, (Object)powerTwo);
    }

    public float calculateStressApplied() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return this.lastStressApplied;
        }
        double stressImpact = 0.0;
        Vec3i vec3i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3dc axis = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        if (this.propellerContraption != null) {
            if (!((Collection)this.sailPositions).isEmpty()) {
                for (Vector3ic sail : this.sailPositions) {
                    stressImpact += axis.cross((double)sail.x(), (double)sail.y(), (double)sail.z(), new Vector3d()).length();
                }
            } else {
                for (BladeData blade : this.blades) {
                    stressImpact += Math.abs(blade.getLength() * Math.sin(Math.toRadians(blade.getAngle())) * (blade.getWide() ? 1.5 : 1.0));
                }
            }
        }
        this.lastStressApplied = (float)stressImpact;
        return (float)stressImpact;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity$Companion;", "", "", "rpm", "", "rpmToOmega", "(F)D", "omega", "omegaToRPM", "(D)F", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final double rpmToOmega(float rpm) {
            return (double)rpm * (Math.PI * 2) / 60.0;
        }

        public final float omegaToRPM(double omega) {
            return (float)(omega * 60.0 / (Math.PI * 2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fj\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/PropellerBearingBlockEntity$RotationDirection;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/INamedIconOptions;", "", "Lcom/simibubi/create/foundation/gui/AllIcons;", "getIcon", "()Lcom/simibubi/create/foundation/gui/AllIcons;", "", "getTranslationKey", "()Ljava/lang/String;", "icon", "Lcom/simibubi/create/foundation/gui/AllIcons;", "translationKey", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;ILcom/simibubi/create/foundation/gui/AllIcons;)V", "NORMAL", "INVERTED", "clockwork"})
    public static final class RotationDirection
    extends Enum<RotationDirection>
    implements INamedIconOptions {
        @NotNull
        private final AllIcons icon;
        @NotNull
        private final String translationKey;
        public static final /* enum */ RotationDirection NORMAL;
        public static final /* enum */ RotationDirection INVERTED;
        private static final /* synthetic */ RotationDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RotationDirection(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "propeller.rotation_direction." + Lang.asId((String)this.name());
        }

        @NotNull
        public AllIcons getIcon() {
            return this.icon;
        }

        @NotNull
        public String getTranslationKey() {
            return this.translationKey;
        }

        public static RotationDirection[] values() {
            return (RotationDirection[])$VALUES.clone();
        }

        public static RotationDirection valueOf(String value) {
            return Enum.valueOf(RotationDirection.class, value);
        }

        @NotNull
        public static EnumEntries<RotationDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            AllIcons allIcons = AllIcons.I_REFRESH;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons, (String)"I_REFRESH");
            NORMAL = new RotationDirection(allIcons);
            AllIcons allIcons2 = AllIcons.I_ROTATE_CCW;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons2, (String)"I_ROTATE_CCW");
            INVERTED = new RotationDirection(allIcons2);
            $VALUES = rotationDirectionArray = new RotationDirection[]{RotationDirection.NORMAL, RotationDirection.INVERTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

