/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.util.sound.SoundScape;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000267B\t\b\u0002\u00a2\u0006\u0004\b5\u0010\u0016J)\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ3\u0010\r\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ3\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ3\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ3\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000eJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0014J\r\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010!\u001a\u00020 2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b!\u0010\"J'\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0#2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u0012\u00a2\u0006\u0004\b(\u0010\u0016R\u0014\u0010)\u001a\u00020 8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020 8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u0014\u0010,\u001a\u00020 8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b,\u0010*R8\u0010/\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0.0-0-8\u0002X\u0083\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u0012\u0004\b1\u0010\u0016R2\u00103\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e02\u0012\u0004\u0012\u00020\b0-8\u0002X\u0083\u0004\u00a2\u0006\f\n\u0004\b3\u00100\u0012\u0004\b4\u0010\u0016\u00a8\u00068"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSoundScapes;", "", "", "pitch", "Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;", "group", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "rickety", "(FLorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lorg/valkyrienskies/core/api/ships/Ship;)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "Lnet/minecraft/core/BlockPos;", "pos", "propeller", "(FLorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/core/BlockPos;)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "juryriggedPropeller", "thruster", "gasHiss", "", "play", "(Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lnet/minecraft/core/BlockPos;F)V", "tick", "()V", "addSound", "invalidateAll", "", "outOfRange", "(Lnet/minecraft/core/BlockPos;)Z", "getCameraPos", "()Lnet/minecraft/core/BlockPos;", "Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;", "pitchGroup", "", "getSoundCount", "(Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;)I", "", "getAllLocations", "(Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;)Ljava/util/Set;", "getGroupFromPitch", "(F)Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;", "init", "MAX_AMBIENT_SOURCE_DISTANCE", "I", "UPDATE_INTERVAL", "SOUND_VOLUME_ARG_MAX", "", "", "counter", "Ljava/util/Map;", "getCounter$annotations", "Lkotlin/Pair;", "activeSounds", "getActiveSounds$annotations", "<init>", "AmbienceGroup", "PitchGroup", "clockwork"})
@SourceDebugExtension(value={"SMAP\nClockworkSoundScapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClockworkSoundScapes.kt\norg/valkyrienskies/clockwork/ClockworkSoundScapes\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,157:1\n216#2,2:158\n*S KotlinDebug\n*F\n+ 1 ClockworkSoundScapes.kt\norg/valkyrienskies/clockwork/ClockworkSoundScapes\n*L\n123#1:158,2\n*E\n"})
public final class ClockworkSoundScapes {
    @NotNull
    public static final ClockworkSoundScapes INSTANCE = new ClockworkSoundScapes();
    public static final int MAX_AMBIENT_SOURCE_DISTANCE = 16;
    public static final int UPDATE_INTERVAL = 5;
    public static final int SOUND_VOLUME_ARG_MAX = 15;
    @NotNull
    private static final Map<AmbienceGroup, Map<PitchGroup, Set<BlockPos>>> counter = new IdentityHashMap();
    @NotNull
    private static final Map<Pair<AmbienceGroup, PitchGroup>, SoundScape> activeSounds = new HashMap();

    private ClockworkSoundScapes() {
    }

    private final SoundScape rickety(float pitch, AmbienceGroup group, Ship ship) {
        SoundScape soundScape = new SoundScape(pitch, group, ship);
        SoundEvent soundEvent = ClockworkSounds.INSTANCE.getJUNK_RATTLE().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent);
        return soundScape.repeating(soundEvent, 1.5f, 1.0f, 30);
    }

    private final SoundScape propeller(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
        SoundScape soundScape = new SoundScape(pitch, group, ship);
        SoundEvent soundEvent = ClockworkSounds.INSTANCE.getPROPELLER().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent);
        return soundScape.continuous(soundEvent, 8.0f, 1.0f, ship, pos);
    }

    private final SoundScape juryriggedPropeller(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
        SoundScape soundScape = new SoundScape(pitch, group, ship);
        SoundEvent soundEvent = ClockworkSounds.INSTANCE.getJUNK_PROPELLER().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent);
        SoundScape soundScape2 = soundScape.continuous(soundEvent, 10.0f, 1.0f, ship, pos);
        SoundEvent soundEvent2 = ClockworkSounds.INSTANCE.getJUNK_RATTLE().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent2);
        return soundScape2.repeating(soundEvent2, 1.5f, 1.0f, 30);
    }

    private final SoundScape thruster(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
        SoundScape soundScape = new SoundScape(pitch, group, ship);
        SoundEvent soundEvent = ClockworkSounds.INSTANCE.getTHRUSTER().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent);
        return soundScape.repeating(soundEvent, 3.0f, 1.0f, 0);
    }

    private final SoundScape gasHiss(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
        SoundScape soundScape = new SoundScape(pitch, group, ship);
        SoundEvent soundEvent = ClockworkSounds.INSTANCE.getGAS_HISS().getMainEvent();
        Intrinsics.checkNotNull((Object)soundEvent);
        return soundScape.repeating(soundEvent, 3.0f, 1.0f, 0);
    }

    @JvmStatic
    private static /* synthetic */ void getCounter$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getActiveSounds$annotations() {
    }

    public final void play(@NotNull AmbienceGroup group, @NotNull BlockPos pos, float pitch) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!((Boolean)AllConfigs.client().enableAmbientSounds.get()).booleanValue()) {
            return;
        }
        if (!this.outOfRange(pos)) {
            this.addSound(group, pos, pitch);
        }
    }

    public final void tick() {
        activeSounds.values().forEach(ClockworkSoundScapes::tick$lambda$0);
        if (AnimationTickHolder.getTicks() % 5 != 0) {
            return;
        }
        boolean disable = (Boolean)AllConfigs.client().enableAmbientSounds.get() == false;
        Iterator<Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape>> iterator = activeSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape> entry = iterator.next();
            Pair<AmbienceGroup, PitchGroup> key = entry.getKey();
            SoundScape value = entry.getValue();
            if (!disable && this.getSoundCount((AmbienceGroup)((Object)key.getFirst()), (PitchGroup)((Object)key.getSecond())) != 0) continue;
            value.remove();
            iterator.remove();
        }
        counter.values().forEach(ClockworkSoundScapes::tick$lambda$2);
    }

    private final void addSound(AmbienceGroup group, BlockPos pos, float pitch) {
        PitchGroup groupFromPitch = this.getGroupFromPitch(pitch);
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || (localPlayer = localPlayer.m_9236_()) == null || (localPlayer = VSGameUtilsKt.toWorldCoordinates((Level)localPlayer, (Vector3d)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)))) == null || (localPlayer = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)localPlayer))) == null) {
            localPlayer = Vec3.m_82528_((Vec3i)((Vec3i)pos));
        }
        BlockPos realPos = BlockPos.m_274446_((Position)((Position)localPlayer));
        Set set = counter.computeIfAbsent(group, arg_0 -> ClockworkSoundScapes.addSound$lambda$4(ClockworkSoundScapes::addSound$lambda$3, arg_0)).computeIfAbsent(groupFromPitch, arg_0 -> ClockworkSoundScapes.addSound$lambda$6(ClockworkSoundScapes::addSound$lambda$5, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set set2 = set;
        set2.add(pos);
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        Ship ship = clientLevel != null ? VSGameUtilsKt.getShipManagingPos((Level)((Level)clientLevel), (BlockPos)pos) : null;
        Pair pair = new Pair((Object)group, (Object)groupFromPitch);
        activeSounds.computeIfAbsent((Pair<AmbienceGroup, PitchGroup>)pair, arg_0 -> ClockworkSoundScapes.addSound$lambda$8(arg_0 -> ClockworkSoundScapes.addSound$lambda$7(group, pitch, ship, realPos, arg_0), arg_0));
    }

    public final void invalidateAll() {
        counter.clear();
        Map<Pair<AmbienceGroup, PitchGroup>, SoundScape> $this$forEach$iv = activeSounds;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape> element$iv;
            Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape> entry = element$iv = iterator.next();
            boolean bl = false;
            SoundScape sound = entry.getValue();
            sound.remove();
        }
        activeSounds.clear();
    }

    private final boolean outOfRange(BlockPos pos) {
        BlockPos blockPos = this.getCameraPos();
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || (localPlayer = localPlayer.m_9236_()) == null || (localPlayer = VSGameUtilsKt.toWorldCoordinates((Level)localPlayer, (Vector3d)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)pos)))) == null || (localPlayer = VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)localPlayer))) == null) {
            localPlayer = Vec3.m_82528_((Vec3i)((Vec3i)pos));
        }
        return !blockPos.m_123314_((Vec3i)BlockPos.m_274446_((Position)((Position)localPlayer)), 16.0);
    }

    private final BlockPos getCameraPos() {
        Entity entity = Minecraft.m_91087_().f_91075_;
        if (entity == null) {
            BlockPos blockPos = BlockPos.f_121853_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"ZERO");
            return blockPos;
        }
        Entity renderViewEntity = entity;
        Level level = renderViewEntity.m_9236_();
        BlockPos blockPos = renderViewEntity.m_20183_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        Vector3d playerLocation = VSGameUtilsKt.toWorldCoordinates((Level)level, (Vector3d)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos)));
        BlockPos blockPos2 = BlockPos.m_274446_((Position)((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)((Vector3dc)playerLocation))));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"containing(...)");
        return blockPos2;
    }

    public final int getSoundCount(@Nullable AmbienceGroup group, @Nullable PitchGroup pitchGroup) {
        return this.getAllLocations(group, pitchGroup).size();
    }

    @NotNull
    public final Set<BlockPos> getAllLocations(@Nullable AmbienceGroup group, @Nullable PitchGroup pitchGroup) {
        return counter.getOrDefault((Object)group, MapsKt.emptyMap()).getOrDefault((Object)pitchGroup, SetsKt.emptySet());
    }

    @NotNull
    public final PitchGroup getGroupFromPitch(float pitch) {
        if ((double)pitch < 0.7) {
            return PitchGroup.VERY_LOW;
        }
        if ((double)pitch < 0.9) {
            return PitchGroup.LOW;
        }
        if ((double)pitch < 1.1) {
            return PitchGroup.NORMAL;
        }
        if ((double)pitch < 1.3) {
            return PitchGroup.HIGH;
        }
        return PitchGroup.VERY_HIGH;
    }

    public final void init() {
    }

    private static final void tick$lambda$0(SoundScape obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.tick();
    }

    private static final void tick$lambda$2$lambda$1(Set obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.clear();
    }

    private static final void tick$lambda$2(Map m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        m.values().forEach(ClockworkSoundScapes::tick$lambda$2$lambda$1);
    }

    private static final Map addSound$lambda$3(AmbienceGroup ag) {
        Intrinsics.checkNotNullParameter((Object)((Object)ag), (String)"ag");
        return new IdentityHashMap();
    }

    private static final Map addSound$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Set addSound$lambda$5(PitchGroup pg) {
        return new HashSet();
    }

    private static final Set addSound$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final SoundScape addSound$lambda$7(AmbienceGroup $group, float $pitch, Ship $ship, BlockPos $realPos, Pair it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$group), (String)"$group");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SoundScape soundScape = $group.instantiate($pitch, $ship, $realPos);
        soundScape.play();
        return soundScape;
    }

    private static final SoundScape addSound$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SoundScape)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012(\u0010\f\u001a$\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nR6\u0010\f\u001a$\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$AmbienceGroup;", "", "", "pitch", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lnet/minecraft/core/BlockPos;", "pos", "Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "instantiate", "(FLorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/core/BlockPos;)Lorg/valkyrienskies/clockwork/util/sound/SoundScape;", "Lnet/minecraft/data/models/blockstates/PropertyDispatch$QuadFunction;", "factory", "Lnet/minecraft/data/models/blockstates/PropertyDispatch$QuadFunction;", "<init>", "(Ljava/lang/String;ILnet/minecraft/data/models/blockstates/PropertyDispatch$QuadFunction;)V", "RICKETY", "PROPELLER", "JURYRIGGED_PROPELLER", "THRUSTER", "GAS_HISS", "clockwork"})
    public static final class AmbienceGroup
    extends Enum<AmbienceGroup> {
        @NotNull
        private final PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape> factory;
        public static final /* enum */ AmbienceGroup RICKETY = new AmbienceGroup((PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape>)((PropertyDispatch.QuadFunction)AmbienceGroup::_init_$lambda$0));
        public static final /* enum */ AmbienceGroup PROPELLER = new AmbienceGroup((PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape>)((PropertyDispatch.QuadFunction)AmbienceGroup::_init_$lambda$1));
        public static final /* enum */ AmbienceGroup JURYRIGGED_PROPELLER = new AmbienceGroup((PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape>)((PropertyDispatch.QuadFunction)AmbienceGroup::_init_$lambda$2));
        public static final /* enum */ AmbienceGroup THRUSTER = new AmbienceGroup((PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape>)((PropertyDispatch.QuadFunction)AmbienceGroup::_init_$lambda$3));
        public static final /* enum */ AmbienceGroup GAS_HISS = new AmbienceGroup((PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape>)((PropertyDispatch.QuadFunction)AmbienceGroup::_init_$lambda$4));
        private static final /* synthetic */ AmbienceGroup[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AmbienceGroup(PropertyDispatch.QuadFunction<Float, AmbienceGroup, Ship, BlockPos, SoundScape> factory) {
            this.factory = factory;
        }

        @NotNull
        public final SoundScape instantiate(float pitch, @Nullable Ship ship, @Nullable BlockPos pos) {
            Object object = this.factory.m_176446_((Object)Float.valueOf(pitch), (Object)this, (Object)ship, (Object)pos);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
            return (SoundScape)object;
        }

        public static AmbienceGroup[] values() {
            return (AmbienceGroup[])$VALUES.clone();
        }

        public static AmbienceGroup valueOf(String value) {
            return Enum.valueOf(AmbienceGroup.class, value);
        }

        @NotNull
        public static EnumEntries<AmbienceGroup> getEntries() {
            return $ENTRIES;
        }

        private static final SoundScape _init_$lambda$0(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return INSTANCE.rickety(pitch, group, ship);
        }

        private static final SoundScape _init_$lambda$1(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return INSTANCE.propeller(pitch, group, ship, pos);
        }

        private static final SoundScape _init_$lambda$2(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return INSTANCE.juryriggedPropeller(pitch, group, ship, pos);
        }

        private static final SoundScape _init_$lambda$3(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return INSTANCE.thruster(pitch, group, ship, pos);
        }

        private static final SoundScape _init_$lambda$4(float pitch, AmbienceGroup group, Ship ship, BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
            return INSTANCE.gasHiss(pitch, group, ship, pos);
        }

        static {
            $VALUES = ambienceGroupArray = new AmbienceGroup[]{AmbienceGroup.RICKETY, AmbienceGroup.PROPELLER, AmbienceGroup.JURYRIGGED_PROPELLER, AmbienceGroup.THRUSTER, AmbienceGroup.GAS_HISS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSoundScapes$PitchGroup;", "", "<init>", "(Ljava/lang/String;I)V", "VERY_LOW", "LOW", "NORMAL", "HIGH", "VERY_HIGH", "clockwork"})
    public static final class PitchGroup
    extends Enum<PitchGroup> {
        public static final /* enum */ PitchGroup VERY_LOW = new PitchGroup();
        public static final /* enum */ PitchGroup LOW = new PitchGroup();
        public static final /* enum */ PitchGroup NORMAL = new PitchGroup();
        public static final /* enum */ PitchGroup HIGH = new PitchGroup();
        public static final /* enum */ PitchGroup VERY_HIGH = new PitchGroup();
        private static final /* synthetic */ PitchGroup[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PitchGroup[] values() {
            return (PitchGroup[])$VALUES.clone();
        }

        public static PitchGroup valueOf(String value) {
            return Enum.valueOf(PitchGroup.class, value);
        }

        @NotNull
        public static EnumEntries<PitchGroup> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pitchGroupArray = new PitchGroup[]{PitchGroup.VERY_LOW, PitchGroup.LOW, PitchGroup.NORMAL, PitchGroup.HIGH, PitchGroup.VERY_HIGH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

