/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import com.simibubi.create.foundation.particle.ICustomParticleData;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.curiosities.particles.PhysLightningParticle;
import org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle.LeakParticleData;
import org.valkyrienskies.clockwork.platform.PlatformUtils;
import org.valkyrienskies.clockwork.platform.api.DeferredRegister;

public enum ClockworkParticles {
    PHYS_LIGHTNING(PhysLightningParticle.Data::new),
    LEAK("leak", LeakParticleData::new);

    private final ParticleEntry<?> entry;

    private <D extends ParticleOptions> ClockworkParticles(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        String name = Lang.asId((String)this.name());
        ClockworkMod.INSTANCE.getLOGGER().info("Registering particle: " + name);
        this.entry = new ParticleEntry(name, typeFactory);
    }

    private <D extends ParticleOptions> ClockworkParticles(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
        ClockworkMod.INSTANCE.getLOGGER().info("Registering particle: " + name);
        this.entry = new ParticleEntry(name, typeFactory);
    }

    public static void init() {
        for (ClockworkParticles particle : ClockworkParticles.values()) {
            ParticleEntry.REGISTER.register(particle.entry.name, () -> particle.entry.object);
        }
        ParticleEntry.REGISTER.registerAll();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient(Object event) {
        for (ClockworkParticles particle : ClockworkParticles.values()) {
            PlatformUtils.registerParticleOnPlatform(particle.entry, event);
        }
    }

    public ParticleType<?> get() {
        return this.entry.object;
    }

    public String parameter() {
        return this.entry.name;
    }

    public static class ParticleEntry<D extends ParticleOptions> {
        private static final DeferredRegister<ParticleType<?>> REGISTER = DeferredRegister.create(BuiltInRegistries.f_257034_, "vs_clockwork");
        public final String name;
        public final Supplier<? extends ICustomParticleData<D>> typeFactory;
        public final ParticleType<D> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = this.typeFactory.get().createType();
        }
    }
}

