/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipModifier;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.clockwork.ClockworkAugmentations;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkDamageTypes;
import org.valkyrienskies.clockwork.ClockworkGasses;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.ClockworkRecipes;
import org.valkyrienskies.clockwork.ClockworkTags;
import org.valkyrienskies.clockwork.ClockworkWorldgen;
import org.valkyrienskies.clockwork.client.render.airpocket.AirpocketRenderer;
import org.valkyrienskies.clockwork.content.contraptions.flap.dual_link.DualLinkHandler;
import org.valkyrienskies.clockwork.content.events.CollisionSoundEffectHandler;
import org.valkyrienskies.clockwork.content.forces.BalloonController;
import org.valkyrienskies.clockwork.content.forces.EncasedFanController;
import org.valkyrienskies.clockwork.content.forces.GravitronController;
import org.valkyrienskies.clockwork.content.forces.PocketForcesController;
import org.valkyrienskies.clockwork.content.forces.PropellerController;
import org.valkyrienskies.clockwork.content.forces.ReactionWheelController;
import org.valkyrienskies.clockwork.content.forces.SugarRocketController;
import org.valkyrienskies.clockwork.content.forces.WanderShipControl;
import org.valkyrienskies.clockwork.content.forces.contraption.BearingController;
import org.valkyrienskies.clockwork.content.physicalities.gyro.GyroShipControl;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.clockwork.util.builder.ClockworkExpandedCreateRegistrate;
import org.valkyrienskies.clockwork.util.gui.DuctStats;
import org.valkyrienskies.core.api.attachment.AttachmentRegistration;
import org.valkyrienskies.core.api.events.CollisionEvent;
import org.valkyrienskies.core.api.events.PhysTickEvent;
import org.valkyrienskies.core.api.events.ShipLoadEvent;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.kelvin.KelvinMod;
import org.valkyrienskies.kelvin.api.DuctNetwork;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bN\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004Jj\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052Q\u0010\u0010\u001aM\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00020\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u0017\u0010!\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u001f\u0010,\u001a\n +*\u0004\u0018\u00010*0*8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001f\u00100\u001a\n +*\u0004\u0018\u00010*0*8\u0006\u00a2\u0006\f\n\u0004\b0\u0010-\u001a\u0004\b1\u0010/R8\u00104\u001a&\u0012\f\u0012\n +*\u0004\u0018\u00010303 +*\u0012\u0012\f\u0012\n +*\u0004\u0018\u00010303\u0018\u000102028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001d\u00107\u001a\b\u0012\u0004\u0012\u000203068\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u001d\u0010;\u001a\b\u0012\u0004\u0012\u000203068\u0006\u00a2\u0006\f\n\u0004\b;\u00108\u001a\u0004\b<\u0010:R\u001d\u0010=\u001a\b\u0012\u0004\u0012\u000203068\u0006\u00a2\u0006\f\n\u0004\b=\u00108\u001a\u0004\b>\u0010:R\u001d\u0010@\u001a\b\u0012\u0004\u0012\u0002030?8\u0006\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010CR\u001d\u0010D\u001a\b\u0012\u0004\u0012\u0002030?8\u0006\u00a2\u0006\f\n\u0004\bD\u0010A\u001a\u0004\bE\u0010CR\u001d\u0010F\u001a\b\u0012\u0004\u0012\u0002030?8\u0006\u00a2\u0006\f\n\u0004\bF\u0010A\u001a\u0004\bG\u0010CRK\u0010\u0011\u001a6\u00122\u00120\u0012\b\u0012\u00060\u0005j\u0002`J\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e\u0012\u0004\u0012\u00020\u00020\u00070I0H8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010K\u001a\u0004\bL\u0010M\u00a8\u0006O"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkMod;", "", "", "init", "()V", "", "dimensionId", "Lkotlin/Function3;", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "Lkotlin/ParameterName;", "name", "level", "", "delta", "Lkotlin/Function0;", "tryNextTick", "fn", "physTickOnce", "(Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "Lorg/valkyrienskies/kelvin/impl/DuctNetworkServer;", "getKelvin", "()Lorg/valkyrienskies/kelvin/impl/DuctNetworkServer;", "path", "Lnet/minecraft/resources/ResourceLocation;", "asResource", "(Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "MOD_ID", "Ljava/lang/String;", "", "BUILD_VERSION", "I", "NETWORK_VERSION", "NETWORK_VERSION_STR", "NETWORK_CHANNEL", "Lnet/minecraft/resources/ResourceLocation;", "getNETWORK_CHANNEL", "()Lnet/minecraft/resources/ResourceLocation;", "Lcom/simibubi/create/foundation/data/CreateRegistrate;", "REGISTRATE", "Lcom/simibubi/create/foundation/data/CreateRegistrate;", "getREGISTRATE", "()Lcom/simibubi/create/foundation/data/CreateRegistrate;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MIXIN_LOGGER", "Lorg/slf4j/Logger;", "getMIXIN_LOGGER", "()Lorg/slf4j/Logger;", "LOGGER", "getLOGGER", "Ldev/architectury/registry/registries/DeferredRegister;", "Lnet/minecraft/world/item/CreativeModeTab;", "TAB_REGISTRY", "Ldev/architectury/registry/registries/DeferredRegister;", "Ldev/architectury/registry/registries/RegistrySupplier;", "BASE_CREATIVE_TAB", "Ldev/architectury/registry/registries/RegistrySupplier;", "getBASE_CREATIVE_TAB", "()Ldev/architectury/registry/registries/RegistrySupplier;", "PHYSICAL_CREATIVE_TAB", "getPHYSICAL_CREATIVE_TAB", "GAS_CREATIVE_TAB", "getGAS_CREATIVE_TAB", "Lnet/minecraft/resources/ResourceKey;", "BASE_CREATIVE_TABINFO", "Lnet/minecraft/resources/ResourceKey;", "getBASE_CREATIVE_TABINFO", "()Lnet/minecraft/resources/ResourceKey;", "PHYSICAL_CREATIVE_TABINFO", "getPHYSICAL_CREATIVE_TABINFO", "GAS_CREATIVE_TABINFO", "getGAS_CREATIVE_TABINFO", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getPhysTickOnce", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "<init>", "clockwork"})
public final class ClockworkMod {
    @NotNull
    public static final ClockworkMod INSTANCE = new ClockworkMod();
    @NotNull
    public static final String MOD_ID = "vs_clockwork";
    public static final int BUILD_VERSION = 1;
    public static final int NETWORK_VERSION = 1;
    @NotNull
    public static final String NETWORK_VERSION_STR = "1";
    @NotNull
    private static final ResourceLocation NETWORK_CHANNEL = ClockworkMod.asResource("main");
    @NotNull
    private static final CreateRegistrate REGISTRATE;
    private static final Logger MIXIN_LOGGER;
    private static final Logger LOGGER;
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTRY;
    @NotNull
    private static final RegistrySupplier<CreativeModeTab> BASE_CREATIVE_TAB;
    @NotNull
    private static final RegistrySupplier<CreativeModeTab> PHYSICAL_CREATIVE_TAB;
    @NotNull
    private static final RegistrySupplier<CreativeModeTab> GAS_CREATIVE_TAB;
    @NotNull
    private static final ResourceKey<CreativeModeTab> BASE_CREATIVE_TABINFO;
    @NotNull
    private static final ResourceKey<CreativeModeTab> PHYSICAL_CREATIVE_TABINFO;
    @NotNull
    private static final ResourceKey<CreativeModeTab> GAS_CREATIVE_TABINFO;
    @NotNull
    private static final ConcurrentLinkedQueue<Pair<String, Function3<PhysLevel, Double, Function0<Unit>, Unit>>> physTickOnce;

    private ClockworkMod() {
    }

    @NotNull
    public final ResourceLocation getNETWORK_CHANNEL() {
        return NETWORK_CHANNEL;
    }

    @NotNull
    public final CreateRegistrate getREGISTRATE() {
        return REGISTRATE;
    }

    public final Logger getMIXIN_LOGGER() {
        return MIXIN_LOGGER;
    }

    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final RegistrySupplier<CreativeModeTab> getBASE_CREATIVE_TAB() {
        return BASE_CREATIVE_TAB;
    }

    @NotNull
    public final RegistrySupplier<CreativeModeTab> getPHYSICAL_CREATIVE_TAB() {
        return PHYSICAL_CREATIVE_TAB;
    }

    @NotNull
    public final RegistrySupplier<CreativeModeTab> getGAS_CREATIVE_TAB() {
        return GAS_CREATIVE_TAB;
    }

    @NotNull
    public final ResourceKey<CreativeModeTab> getBASE_CREATIVE_TABINFO() {
        return BASE_CREATIVE_TABINFO;
    }

    @NotNull
    public final ResourceKey<CreativeModeTab> getPHYSICAL_CREATIVE_TABINFO() {
        return PHYSICAL_CREATIVE_TABINFO;
    }

    @NotNull
    public final ResourceKey<CreativeModeTab> getGAS_CREATIVE_TABINFO() {
        return GAS_CREATIVE_TABINFO;
    }

    @NotNull
    public final ConcurrentLinkedQueue<Pair<String, Function3<PhysLevel, Double, Function0<Unit>, Unit>>> getPhysTickOnce() {
        return physTickOnce;
    }

    @JvmStatic
    public static final void init() {
        ClockworkPackets.Companion.init();
        ClockworkTags.INSTANCE.init();
        ClockworkRecipes.INSTANCE.init();
        TAB_REGISTRY.register();
        VSGameUtilsKt.getVsCore().registerAttachment(PocketForcesController.class);
        VSGameUtilsKt.getVsCore().registerAttachment(WanderShipControl.class);
        VSGameUtilsKt.getVsCore().registerAttachment(PropellerController.class);
        VSGameUtilsKt.getVsCore().registerAttachment(ReactionWheelController.class);
        VSGameUtilsKt.getVsCore().registerAttachment(EncasedFanController.class);
        VSGameUtilsKt.getVsCore().registerAttachment(GyroShipControl.class);
        VSGameUtilsKt.getVsCore().registerAttachment(SugarRocketController.class);
        VSGameUtilsKt.getVsCore().registerAttachment(GravitronController.class, ClockworkMod::init$lambda$7);
        VSGameUtilsKt.getVsCore().registerAttachment(BearingController.class, ClockworkMod::init$lambda$8);
        VSGameUtilsKt.getVsCore().registerAttachment(BalloonController.class);
        ValkyrienSkies.api().getShipLoadEvent().on(arg_0 -> ClockworkMod.init$lambda$10(ClockworkMod::init$lambda$9, arg_0));
        ClockworkWorldgen.INSTANCE.register();
        ClockworkDamageTypes.INSTANCE.init();
        ClockworkGasses.init();
        LifecycleEvent.SERVER_STARTED.register(ClockworkMod::init$lambda$11);
        TickEvent.SERVER_LEVEL_POST.register(ClockworkMod::init$lambda$12);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(ClockworkMod::init$lambda$13);
        CommandRegistrationEvent.EVENT.register(ClockworkMod::init$lambda$15);
        ValkyrienSkies.api().getCollisionStartEvent().on(arg_0 -> ClockworkMod.init$lambda$16((Function1)new Function1<CollisionEvent, Unit>((Object)CollisionSoundEffectHandler.INSTANCE){

            public final void invoke(CollisionEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((CollisionSoundEffectHandler)this.receiver).onCollide(p0);
            }
        }, arg_0));
        ValkyrienSkies.api().getPhysTickEvent().on(arg_0 -> ClockworkMod.init$lambda$19(ClockworkMod::init$lambda$18, arg_0));
    }

    @JvmStatic
    public static final void physTickOnce(@NotNull String dimensionId, @NotNull Function3<? super PhysLevel, ? super Double, ? super Function0<Unit>, Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        physTickOnce.add((Pair<String, Function3<PhysLevel, Double, Function0<Unit>, Unit>>)TuplesKt.to((Object)dimensionId, fn));
    }

    @JvmStatic
    @NotNull
    public static final DuctNetworkServer getKelvin() {
        DuctNetwork ductNetwork = KelvinMod.INSTANCE.getKelvin();
        Intrinsics.checkNotNull((Object)ductNetwork, (String)"null cannot be cast to non-null type org.valkyrienskies.kelvin.impl.DuctNetworkServer");
        return (DuctNetworkServer)ductNetwork;
    }

    @JvmStatic
    @NotNull
    public static final ResourceLocation asResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new ResourceLocation(MOD_ID, path);
    }

    private static final TooltipModifier REGISTRATE$lambda$0(Item item) {
        ItemDescription.Modifier modifier = new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE);
        Intrinsics.checkNotNull((Object)item);
        return modifier.andThen(TooltipModifier.mapNull((TooltipModifier)DuctStats.Companion.create(item)));
    }

    private static final ItemStack BASE_CREATIVE_TAB$lambda$2$lambda$1() {
        return new ItemStack((ItemLike)ClockworkItems.WANDERWAND.m_5456_());
    }

    private static final CreativeModeTab BASE_CREATIVE_TAB$lambda$2() {
        return CreativeTabRegistry.create((Component)((Component)Component.m_237115_((String)"itemGroup.vs_clockwork")), ClockworkMod::BASE_CREATIVE_TAB$lambda$2$lambda$1);
    }

    private static final ItemStack PHYSICAL_CREATIVE_TAB$lambda$4$lambda$3() {
        return new ItemStack((ItemLike)ClockworkBlocks.PHYSICS_INFUSER.m_5456_());
    }

    private static final CreativeModeTab PHYSICAL_CREATIVE_TAB$lambda$4() {
        return CreativeTabRegistry.create((Component)((Component)Component.m_237115_((String)"itemGroup.vs_clockwork.physicalities")), ClockworkMod::PHYSICAL_CREATIVE_TAB$lambda$4$lambda$3);
    }

    private static final ItemStack GAS_CREATIVE_TAB$lambda$6$lambda$5() {
        return new ItemStack((ItemLike)ClockworkBlocks.AIR_COMPRESSOR.get());
    }

    private static final CreativeModeTab GAS_CREATIVE_TAB$lambda$6() {
        return CreativeTabRegistry.create((Component)((Component)Component.m_237115_((String)"itemGroup.vs_clockwork.gasses")), ClockworkMod::GAS_CREATIVE_TAB$lambda$6$lambda$5);
    }

    private static final Unit init$lambda$7(AttachmentRegistration.Builder $this$registerAttachment) {
        Intrinsics.checkNotNullParameter((Object)$this$registerAttachment, (String)"$this$registerAttachment");
        $this$registerAttachment.useTransientSerializer();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$8(AttachmentRegistration.Builder $this$registerAttachment) {
        Intrinsics.checkNotNullParameter((Object)$this$registerAttachment, (String)"$this$registerAttachment");
        $this$registerAttachment.useTransientSerializer();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$9(ShipLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LoadedServerShip ship = event.getShip();
        WanderShipControl.Companion.getOrCreate(ship);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void init$lambda$11(MinecraftServer it) {
        Intrinsics.checkNotNull((Object)it);
        ClockworkAugmentations.INSTANCE.registerComponentAvgAugmentation("heatEnergy", VSGameUtilsKt.getShipObjectWorld((MinecraftServer)it));
        ClockworkAugmentations.INSTANCE.registerComponentAvgAugmentation("pressure", VSGameUtilsKt.getShipObjectWorld((MinecraftServer)it));
        for (GasType gas : GasTypeRegistry.INSTANCE.getGAS_TYPES().values()) {
            ClockworkAugmentations.INSTANCE.registerComponentAvgAugmentation("gas/" + gas.getResourceLocation(), VSGameUtilsKt.getShipObjectWorld((MinecraftServer)it));
        }
        ClockworkAugmentations.INSTANCE.registerComponentSumAugmentation("airupdated", VSGameUtilsKt.getShipObjectWorld((MinecraftServer)it));
        ClockworkAugmentations.INSTANCE.registerSumAugmentation("sealed", VSGameUtilsKt.getShipObjectWorld((MinecraftServer)it));
    }

    private static final void init$lambda$12(ServerLevel it) {
        for (LoadedServerShip ship : VSGameUtilsKt.getShipObjectWorld((ServerLevel)it).getLoadedShips()) {
            BalloonController balloonController = (BalloonController)ship.getAttachment(BalloonController.class);
            if (balloonController == null) continue;
            Intrinsics.checkNotNull((Object)it);
            balloonController.gameTick(it, ship);
        }
        Intrinsics.checkNotNull((Object)it);
        ClockworkUtils.tick(it);
        if (ClockworkConfig.CLIENT.getDebugRender()) {
            AirpocketRenderer.INSTANCE.tick(it);
        }
        CollisionSoundEffectHandler.INSTANCE.tick(it);
    }

    private static final EventResult init$lambda$13(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        Intrinsics.checkNotNull((Object)player);
        Intrinsics.checkNotNull((Object)hand);
        Intrinsics.checkNotNull((Object)pos);
        Intrinsics.checkNotNull((Object)face);
        return DualLinkHandler.handler(player, hand, pos, face);
    }

    private static final int init$lambda$15$lambda$14(CommandContext it) {
        ServerLevel serverLevel = ((CommandSourceStack)it.getSource()).m_81372_();
        Intrinsics.checkNotNull((Object)serverLevel);
        ServerLevel level = serverLevel;
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).m_230896_();
        Intrinsics.checkNotNull((Object)serverPlayer);
        ServerPlayer player = serverPlayer;
        double density = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirTemperatureForY(player.m_20182_().m_7098_(), ValkyrienSkies.getDimensionIdNonnull((Level)((Level)level)));
        double temperature = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAerodynamicUtils().getAirTemperatureForY(player.m_20182_().m_7098_(), ValkyrienSkies.getDimensionIdNonnull((Level)((Level)level)));
        Object[] objectArray = new Object[]{MathKt.roundToInt((double)player.m_20182_().f_82480_), MathKt.roundToInt((double)density), MathKt.roundToInt((double)temperature)};
        player.m_213846_((Component)Component.m_237110_((String)"vs_clockwork.command.get_air_values", (Object[])objectArray));
        return 0;
    }

    private static final void init$lambda$15(CommandDispatcher dispatcher, CommandBuildContext context, Commands.CommandSelection idk) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"get-air-values").executes(ClockworkMod::init$lambda$15$lambda$14));
    }

    private static final void init$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit init$lambda$18$lambda$17(List $temp, String $dimension, Function3 $fn) {
        Intrinsics.checkNotNullParameter((Object)$temp, (String)"$temp");
        Intrinsics.checkNotNullParameter((Object)$dimension, (String)"$dimension");
        Intrinsics.checkNotNullParameter((Object)$fn, (String)"$fn");
        $temp.add(TuplesKt.to((Object)$dimension, (Object)$fn));
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit init$lambda$18(PhysTickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List temp = new ArrayList();
        while (true) {
            Pair<String, Function3<PhysLevel, Double, Function0<Unit>, Unit>> pair;
            if (!(!((Collection)physTickOnce).isEmpty())) {
                physTickOnce.addAll(temp);
                return Unit.INSTANCE;
            }
            if (physTickOnce.poll() == null) continue;
            String dimension = (String)pair.component1();
            Function3 fn = (Function3)pair.component2();
            if (!Intrinsics.areEqual((Object)it.getWorld().getDimension(), (Object)dimension)) {
                temp.add(TuplesKt.to((Object)dimension, (Object)fn));
                continue;
            }
            fn.invoke((Object)it.getWorld(), (Object)it.getDelta(), () -> ClockworkMod.init$lambda$18$lambda$17(temp, dimension, fn));
        }
    }

    private static final void init$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        CreateRegistrate createRegistrate = ClockworkExpandedCreateRegistrate.Companion.create(MOD_ID).setTooltipModifierFactory(ClockworkMod::REGISTRATE$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)createRegistrate, (String)"setTooltipModifierFactory(...)");
        REGISTRATE = createRegistrate;
        MIXIN_LOGGER = LoggerFactory.getLogger((String)"ClockworkMixins");
        LOGGER = LogUtils.getLogger();
        TAB_REGISTRY = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.f_279569_);
        RegistrySupplier registrySupplier = TAB_REGISTRY.register("clockwork_main", ClockworkMod::BASE_CREATIVE_TAB$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier, (String)"register(...)");
        BASE_CREATIVE_TAB = registrySupplier;
        RegistrySupplier registrySupplier2 = TAB_REGISTRY.register("clockwork_physicalities", ClockworkMod::PHYSICAL_CREATIVE_TAB$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier2, (String)"register(...)");
        PHYSICAL_CREATIVE_TAB = registrySupplier2;
        RegistrySupplier registrySupplier3 = TAB_REGISTRY.register("clockwork_gasses", ClockworkMod::GAS_CREATIVE_TAB$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier3, (String)"register(...)");
        GAS_CREATIVE_TAB = registrySupplier3;
        ResourceKey resourceKey = BASE_CREATIVE_TAB.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"getKey(...)");
        BASE_CREATIVE_TABINFO = resourceKey;
        ResourceKey resourceKey2 = PHYSICAL_CREATIVE_TAB.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"getKey(...)");
        PHYSICAL_CREATIVE_TABINFO = resourceKey2;
        ResourceKey resourceKey3 = GAS_CREATIVE_TAB.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey3, (String)"getKey(...)");
        GAS_CREATIVE_TABINFO = resourceKey3;
        physTickOnce = new ConcurrentLinkedQueue();
    }
}

