/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.flywheel_renderer;

import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.ShipRenderer;
import org.valkyrienskies.mod.common.config.ShipRendererKt;
import org.valkyrienskies.mod.compat.LoadedMods;
import org.valkyrienskies.mod.compat.flywheel.FlywheelCompat;

@Mixin(value={ViewArea.class})
public class MixinViewArea {
    @Shadow
    @Final
    protected Level f_110839_;
    @Shadow
    protected int f_110840_;

    @Inject(method={"setDirty"}, at={@At(value="HEAD")}, cancellable=true)
    private void preScheduleRebuild(int x2, int y2, int z2, boolean important, CallbackInfo callbackInfo) {
        int yIndex = y2 - this.f_110839_.m_151560_();
        if (yIndex < 0 || yIndex >= this.f_110840_) {
            return;
        }
        ClientShip ship = (ClientShip)VSGameUtilsKt.getShipManagingPos(this.f_110839_, x2, z2);
        if (ship == null) {
            return;
        }
        if (ShipRendererKt.getShipRenderer(ship) != ShipRenderer.FLYWHEEL) {
            return;
        }
        if (LoadedMods.getFlywheel() != LoadedMods.FlywheelVersion.V1) {
            throw new IllegalStateException("Trying to render with flywheel, but no flywheel installed");
        }
        FlywheelCompat.INSTANCE.setShipEffectDirty(ship, x2, y2, z2, important);
    }

    @Inject(method={"getRenderChunkAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetRenderedChunk(BlockPos pos, CallbackInfoReturnable<ChunkRenderDispatcher.RenderChunk> callbackInfoReturnable) {
        int chunkX = Mth.m_14042_((int)pos.m_123341_(), (int)16);
        int chunkY = Mth.m_14042_((int)(pos.m_123342_() - this.f_110839_.m_141937_()), (int)16);
        int chunkZ = Mth.m_14042_((int)pos.m_123343_(), (int)16);
        if (chunkY < 0 || chunkY >= this.f_110840_) {
            return;
        }
        ClientShip ship = (ClientShip)VSGameUtilsKt.getShipManagingPos(this.f_110839_, chunkX, chunkZ);
        if (ship != null && ShipRendererKt.getShipRenderer(ship) == ShipRenderer.FLYWHEEL) {
            callbackInfoReturnable.setReturnValue(null);
        }
    }
}

