/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.handling.DefaultShipyardEntityHandler;
import org.valkyrienskies.mod.common.entity.handling.VSEntityManager;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.compat.create.AdvancedAirCurrentSegment;
import org.valkyrienskies.mod.compat.create.AirFlowClipContext;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IExtendedAirCurrentSource;
import org.valkyrienskies.mod.util.AdvancedBlockWalker;

@Mixin(value={AirCurrent.class})
public abstract class MixinAirCurrent {
    @Unique
    private static final boolean[] FALSE_THEN_TRUE = new boolean[]{false, true};
    @Unique
    private static final double NON_BLOCK_EXTEND = 0.03125;
    @Unique
    private static final double EPS1 = 1.0E-6;
    @Unique
    private static final double EPS2 = 2.0E-6;
    @Unique
    private static final double EPS3 = 4.0E-6;
    @Shadow
    @Final
    public IAirCurrentSource source;
    @Shadow
    public Direction direction;
    @Shadow
    public boolean pushing;
    @Shadow
    public float maxDistance;
    @Shadow
    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>> affectedItemHandlers;
    @Unique
    private double shipScale = 1.0;
    @Unique
    private FanProcessingType initialProcessingType = null;
    @Unique
    private List<AdvancedAirCurrentSegment> segments = new ArrayList<AdvancedAirCurrentSegment>();

    @Shadow
    private static boolean shouldAlwaysPass(BlockState state) {
        return false;
    }

    @Shadow
    protected abstract int getLimit();

    @Unique
    private Ship getShip() {
        IAirCurrentSource iAirCurrentSource = this.source;
        if (iAirCurrentSource instanceof IExtendedAirCurrentSource) {
            IExtendedAirCurrentSource se2 = (IExtendedAirCurrentSource)iAirCurrentSource;
            return se2.getShip();
        }
        if (this.source.getAirCurrentWorld() != null) {
            return VSGameUtilsKt.getShipManagingPos(this.source.getAirCurrentWorld(), this.source.getAirCurrentPos());
        }
        return null;
    }

    @Inject(method={"getFlowLimit"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void clipFlowLimit(Level level, BlockPos start, float originalMax, Direction facing, CallbackInfoReturnable<Float> cir) {
        float flowLimit = ((Float)cir.getReturnValue()).floatValue();
        Ship ship = VSGameUtilsKt.getShipManagingPos(level, start);
        if (ship != null) {
            BlockPos pos;
            Vector3d startVec = new Vector3d((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_());
            Vector3d direction = VectorConversionsMCKt.toJOMLD(facing.m_122436_());
            startVec.add(0.5, 0.5, 0.5).add((Vector3dc)direction.mul(0.5, new Vector3d()));
            ship.getTransform().getShipToWorld().transformPosition(startVec);
            ship.getTransform().getShipToWorld().transformDirection(direction);
            Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
            double shipScale = facing.m_122434_().m_6150_(scaling.x(), scaling.y(), scaling.z());
            direction.mul((double)flowLimit);
            Vec3 startPos = VectorConversionsMCKt.toMinecraft((Vector3dc)startVec);
            Vec3 endPos = VectorConversionsMCKt.toMinecraft((Vector3dc)startVec.add(direction.x, direction.y, direction.z));
            BlockHitResult result = level.m_45547_((ClipContext)new AirFlowClipContext(level, start, startPos, endPos, MixinAirCurrent::shouldAlwaysPass));
            double limit = result.m_82450_().m_82554_(startPos) / shipScale + 2.0E-6;
            if (result.m_6662_() == HitResult.Type.BLOCK && level.m_8055_(pos = result.m_82425_()).m_60812_((BlockGetter)level, pos) != Shapes.m_83144_()) {
                limit += 0.03125;
            }
            cir.setReturnValue((Object)Float.valueOf((float)limit));
            return;
        }
        BlockPos end = start.m_5484_(facing, (int)Math.ceil(flowLimit));
        if (VSGameUtilsKt.getShipsIntersecting(level, new AABB((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_(), (double)(end.m_123341_() + 1), (double)(end.m_123342_() + 1), (double)(end.m_123343_() + 1))).iterator().hasNext()) {
            BlockPos pos;
            Vec3 startPos = Vec3.m_82512_((Vec3i)start).m_82520_((double)facing.m_122429_() * 0.5, (double)facing.m_122430_() * 0.5, (double)facing.m_122431_() * 0.5);
            Vec3 endPos = Vec3.m_82512_((Vec3i)end).m_82520_((double)facing.m_122429_() * 0.5, (double)facing.m_122430_() * 0.5, (double)facing.m_122431_() * 0.5);
            BlockHitResult result = level.m_45547_((ClipContext)new AirFlowClipContext(level, start, startPos, endPos, MixinAirCurrent::shouldAlwaysPass));
            double limit = result.m_82450_().m_82554_(startPos) + 2.0E-6;
            if (result.m_6662_() == HitResult.Type.BLOCK && level.m_8055_(pos = result.m_82425_()).m_60812_((BlockGetter)level, pos) != Shapes.m_83144_()) {
                limit += 0.03125;
            }
            cir.setReturnValue((Object)Float.valueOf(Math.min((float)limit, flowLimit)));
        }
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/IAirCurrentSource;getAirCurrentWorld()Lnet/minecraft/world/level/Level;", remap=true)}, remap=false)
    private void calcScaling(CallbackInfo ci2) {
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
            this.shipScale = this.direction.m_122434_().m_6150_(scaling.x(), scaling.y(), scaling.z());
        }
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/AirCurrent;getLimit()I")}, remap=false)
    private void stealInitialType(CallbackInfo ci2, @Local(name={"type"}) FanProcessingType type) {
        this.initialProcessingType = type;
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/AirCurrent;findAffectedHandlers()V")}, remap=false)
    private void calcSegments(CallbackInfo ci2) {
        this.segments.clear();
        Level level = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        Vec3 startCenter = start.m_252807_();
        AdvancedAirCurrentSegment currentSegment = null;
        FanProcessingType type = this.initialProcessingType;
        int limit = this.getLimit();
        Vec3 delta = new Vec3((double)this.direction.m_122429_() * 0.5, (double)this.direction.m_122430_() * 0.5, (double)this.direction.m_122431_() * 0.5);
        Vec3 startPos = startCenter.m_82549_(delta);
        Vec3 endPos = startCenter.m_231075_(this.direction, (double)this.maxDistance).m_82549_(delta);
        AdvancedBlockWalker walker = new AdvancedBlockWalker(level, startPos, endPos, !this.pushing, true);
        while (walker.hasNext()) {
            AdvancedBlockWalker.BlockPosWithDistance data = walker.next();
            FanProcessingType newType = FanProcessingType.getAt((Level)level, (BlockPos)data.pos());
            double dist = data.distance();
            if (dist < 2.147483647E9 && Math.abs(dist - (double)((int)dist)) < 1.0E-6) {
                dist = (int)dist;
            }
            if (newType != null) {
                type = newType;
            }
            if (currentSegment == null) {
                currentSegment = new AdvancedAirCurrentSegment();
                currentSegment.startOffset = dist;
                currentSegment.type = type;
                continue;
            }
            if (currentSegment.type == type) continue;
            currentSegment.endOffset = dist;
            this.segments.add(currentSegment);
            currentSegment = new AdvancedAirCurrentSegment();
            currentSegment.startOffset = dist;
            currentSegment.type = type;
        }
        if (currentSegment != null) {
            currentSegment.endOffset = this.pushing ? (double)limit : 0.0;
            this.segments.add(currentSegment);
        }
    }

    @WrapOperation(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;position()Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 transformEntityPos(Entity instance, Operation<Vec3> original) {
        Vec3 result = (Vec3)original.call(new Object[]{instance});
        Ship ship = this.getShip();
        if (ship == null || VSEntityManager.INSTANCE.getHandler(instance) instanceof DefaultShipyardEntityHandler) {
            return result;
        }
        Vector3d sourcePos = VectorConversionsMCKt.toJOML(this.source.getAirCurrentPos().m_252807_());
        Vector3d naiveEntityPos = ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(result));
        Vector3d distanceFromSource = VectorConversionsMCKt.toJOML(this.source.getAirCurrentPos().m_252807_()).sub((Vector3dc)naiveEntityPos);
        Vector3d adjustedEntityPos = sourcePos.sub((Vector3dc)distanceFromSource.div(this.shipScale, new Vector3d()), new Vector3d());
        return VectorConversionsMCKt.toMinecraft((Vector3dc)adjustedEntityPos);
    }

    @ModifyArg(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;spawnProcessingParticles(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V"), index=1)
    private Vec3 useRealEntityPosition(Vec3 pos, @Local Entity entity) {
        return entity.m_20182_();
    }

    @Redirect(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;intersects(Lnet/minecraft/world/phys/AABB;)Z"))
    private boolean redirectIntersects(AABB entityAABB, AABB boundsAABB) {
        Ship ship = this.getShip();
        if (ship == null) {
            return entityAABB.m_82381_(boundsAABB);
        }
        AABBd entityInShipAABB = VectorConversionsMCKt.toJOML(entityAABB).transform(ship.getWorldToShip());
        AABBd boundsInWorldAABB = VectorConversionsMCKt.toJOML(boundsAABB).transform(ship.getShipToWorld());
        return boundsAABB.m_82314_(entityInShipAABB.minX, entityInShipAABB.minY, entityInShipAABB.minZ, entityInShipAABB.maxX, entityInShipAABB.maxY, entityInShipAABB.maxZ) && entityAABB.m_82314_(boundsInWorldAABB.minX, boundsInWorldAABB.minY, boundsInWorldAABB.minZ, boundsInWorldAABB.maxX, boundsInWorldAABB.maxY, boundsInWorldAABB.maxZ);
    }

    @WrapOperation(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V")})
    private void redirectSetDeltaMovement(Entity instance, Vec3 motion, Operation<Void> original, @Local(ordinal=2) float acceleration, @Local(ordinal=3) float maxAcceleration, @Local(ordinal=0) Vec3i flow) {
        Ship ship = this.getShip();
        if (ship != null && !(VSEntityManager.INSTANCE.getHandler(instance) instanceof DefaultShipyardEntityHandler)) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection((double)flow.m_123341_(), (double)flow.m_123342_(), (double)flow.m_123343_(), tempVec);
            Vec3 transformedFlow = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
            Vec3 previousMotion = instance.m_20184_();
            double xIn = Mth.m_14008_((double)(transformedFlow.f_82479_ * (double)acceleration - previousMotion.f_82479_), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = Mth.m_14008_((double)(transformedFlow.f_82480_ * (double)acceleration - previousMotion.f_82480_), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = Mth.m_14008_((double)(transformedFlow.f_82481_ * (double)acceleration - previousMotion.f_82481_), (double)(-maxAcceleration), (double)maxAcceleration);
            motion = previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125));
        }
        original.call(new Object[]{instance, motion});
    }

    @Inject(method={"findAffectedHandlers"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void findAffectedHandlers(CallbackInfo ci2) {
        ci2.cancel();
        this.affectedItemHandlers.clear();
        Level level = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        Vec3 startCenter = start.m_252807_();
        ArrayList<AdvancedBlockWalker.BlockPosWithDistance> datas = new ArrayList<AdvancedBlockWalker.BlockPosWithDistance>();
        Vec3 delta = new Vec3((double)this.direction.m_122429_() * 0.5, (double)this.direction.m_122430_() * 0.5, (double)this.direction.m_122431_() * 0.5);
        Vec3 startPos = startCenter.m_82549_(delta);
        Vec3 endPos = startCenter.m_231075_(this.direction, (double)this.maxDistance).m_82549_(delta);
        AdvancedBlockWalker walker = new AdvancedBlockWalker(level, startPos, endPos, !this.pushing, false);
        while (walker.hasNext()) {
            datas.add(walker.next());
        }
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        for (boolean checkBelow : FALSE_THEN_TRUE) {
            for (AdvancedBlockWalker.BlockPosWithDistance data : datas) {
                BlockPos pos = checkBelow ? data.pos().m_7495_() : data.pos();
                TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour == null) continue;
                double dist = data.distance() + 4.0E-6;
                if (dist < 2.147483647E9 && Math.abs(dist - (double)((int)dist)) < 1.0E-6) {
                    dist = (int)dist;
                }
                if (dist > (double)this.maxDistance || !processed.add(pos)) continue;
                FanProcessingType type = FanProcessingType.getAt((Level)level, (BlockPos)pos);
                if (type == null) {
                    type = this.getTypeAt0(dist);
                }
                this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>)Pair.of((Object)behaviour, (Object)type));
            }
        }
    }

    @Inject(method={"getTypeAt"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getTypeAt(float offset, CallbackInfoReturnable<FanProcessingType> cir) {
        cir.setReturnValue((Object)this.getTypeAt0(offset));
    }

    @Unique
    private FanProcessingType getTypeAt0(double offset) {
        if (offset < 2.147483647E9 && Math.abs(offset - (double)((int)offset)) < 1.0E-6) {
            offset = (int)offset;
        }
        if (offset < 0.0 || offset > (double)this.maxDistance) {
            return null;
        }
        if (this.pushing) {
            for (AdvancedAirCurrentSegment segment : this.segments) {
                if (!(offset <= segment.endOffset)) continue;
                return segment.type;
            }
        } else {
            for (AdvancedAirCurrentSegment segment : this.segments) {
                if (!(offset >= segment.endOffset)) continue;
                return segment.type;
            }
        }
        return null;
    }
}

