/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.sculk;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={VibrationSystem.Listener.class})
public abstract class MixinVibrationSystem {
    @WrapMethod(method={"scheduleVibration"})
    private void scheduleVibration(ServerLevel level, VibrationSystem.Data data, GameEvent gameEvent, GameEvent.Context context, Vec3 pos, Vec3 sensorPos, Operation<Void> original) {
        original.call(new Object[]{level, data, gameEvent, context, VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.getWorldCoordinates((Level)level, BlockPos.m_274446_((Position)pos), VectorConversionsMCKt.toJOML(pos))), VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.getWorldCoordinates((Level)level, BlockPos.m_274446_((Position)sensorPos), VectorConversionsMCKt.toJOML(sensorPos)))});
    }

    @WrapMethod(method={"isOccluded"})
    private static boolean adjustOcclusionForWorldPosition(Level level, Vec3 pos1, Vec3 pos2, Operation<Boolean> original) {
        Ship ship2;
        Ship ship1 = VSGameUtilsKt.getShipManagingPos(level, (Position)pos1);
        if (ship1 == (ship2 = VSGameUtilsKt.getShipManagingPos(level, (Position)pos2))) {
            return (Boolean)original.call(new Object[]{level, pos1, pos2});
        }
        Vec3 pos1InWorld = VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.getWorldCoordinates(level, BlockPos.m_274446_((Position)pos1), VectorConversionsMCKt.toJOML(pos1)));
        Vec3 pos2InWorld = VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.getWorldCoordinates(level, BlockPos.m_274446_((Position)pos2), VectorConversionsMCKt.toJOML(pos2)));
        if (((Boolean)original.call(new Object[]{level, pos1InWorld, pos2InWorld})).booleanValue()) {
            return true;
        }
        boolean result = false;
        if (ship2 != null) {
            Vec3 pos1InShip2 = VectorConversionsMCKt.toMinecraft((Vector3dc)ship2.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(pos1InWorld)));
            result |= ((Boolean)original.call(new Object[]{level, pos1InShip2, pos2})).booleanValue();
        }
        if (ship1 != null) {
            Vec3 pos2InShip1 = VectorConversionsMCKt.toMinecraft((Vector3dc)ship1.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(pos2InWorld)));
            result |= ((Boolean)original.call(new Object[]{level, pos1, pos2InShip1})).booleanValue();
        }
        return result;
    }
}

