/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.entity_collision;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.EntityShipCollisionUtils;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEntityDraggingInformationProvider {
    @Shadow
    public boolean f_19812_;
    @Shadow
    protected boolean f_19803_;
    @Shadow
    public int f_19797_;
    @Shadow
    public Level f_19853_;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Shadow
    private EntityDimensions f_19815_;

    @Shadow
    public abstract void m_146884_(Vec3 var1);

    @Shadow
    public abstract boolean m_7306_(Entity var1);

    @Shadow
    public abstract boolean m_6109_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract Iterable<Entity> m_146897_();

    @Shadow
    public abstract BlockPos m_20097_();

    @Inject(at={@At(value="HEAD")}, method={"move"}, cancellable=true)
    private void beforeMove(MoverType type, Vec3 pos, CallbackInfo ci2) {
        if (EntityShipCollisionUtils.isCollidingWithUnloadedShips((Entity)Entity.class.cast(this))) {
            ci2.cancel();
        }
    }

    @WrapOperation(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;")})
    public Vec3 collideWithShips(Entity entity, Vec3 movement, Operation<Vec3> collide) {
        AABB box = this.m_20191_();
        movement = EntityShipCollisionUtils.INSTANCE.adjustEntityMovementForShipCollisions(entity, movement, box, this.f_19853_);
        Object[] objectArray = new Object[]{entity, movement};
        Vec3 collisionResultWithWorld = (Vec3)collide.call(objectArray);
        if (collisionResultWithWorld.m_82557_(movement) > 1.0E-12) {
            EntityDraggingInformation entityDraggingInformation = this.getDraggingInformation();
            if (entityDraggingInformation.getIgnoreNextGroundStand()) {
                entityDraggingInformation.setIgnoreNextGroundStand(false);
                return collisionResultWithWorld;
            }
            entityDraggingInformation.setLastShipStoodOn(null);
            entityDraggingInformation.setAddedYawRotLastTick(0.0);
            for (Entity entityRiding : entity.m_146897_()) {
                EntityDraggingInformation passengerDraggingInformation = ((IEntityDraggingInformationProvider)entityRiding).getDraggingInformation();
                passengerDraggingInformation.setLastShipStoodOn(null);
                passengerDraggingInformation.setAddedYawRotLastTick(0.0);
            }
        }
        return collisionResultWithWorld;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(DDD)V")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void redirectSetVelocity(MoverType moverType, Vec3 movement, CallbackInfo callbackInfo, Vec3 movementAdjustedForCollisions) {
        Vector3d collisionResponseHorizontal = new Vector3d(movementAdjustedForCollisions.f_82479_ - movement.f_82479_, 0.0, movementAdjustedForCollisions.f_82481_ - movement.f_82481_);
        if (collisionResponseHorizontal.lengthSquared() > 1.0E-6) {
            Vec3 deltaMovement = this.m_20184_();
            Vector3d collisionResponseHorizontalNormal = collisionResponseHorizontal.normalize(new Vector3d());
            double parallelHorizontalVelocityComponent = collisionResponseHorizontalNormal.dot(deltaMovement.f_82479_, 0.0, deltaMovement.f_82481_);
            this.m_20334_(deltaMovement.f_82479_ - collisionResponseHorizontalNormal.x() * parallelHorizontalVelocityComponent, deltaMovement.f_82480_, deltaMovement.f_82481_ - collisionResponseHorizontalNormal.z() * parallelHorizontalVelocityComponent);
        }
        this.m_146872_();
        callbackInfo.cancel();
    }

    @Unique
    private BlockPos getPosStandingOnFromShips(Vector3dc blockPosInGlobal) {
        double radius = 0.5;
        AABBd testAABB = new AABBd(blockPosInGlobal.x() - 0.5, blockPosInGlobal.y() - 0.5, blockPosInGlobal.z() - 0.5, blockPosInGlobal.x() + 0.5, blockPosInGlobal.y() + 0.5, blockPosInGlobal.z() + 0.5);
        Iterable<Ship> intersectingShips = VSGameUtilsKt.getShipsIntersecting(this.f_19853_, (AABBdc)testAABB);
        for (Ship ship : intersectingShips) {
            Vector3d blockPosInLocal = ship.getTransform().getWorldToShip().transformPosition(blockPosInGlobal, new Vector3d());
            BlockPos blockPos = BlockPos.m_274561_((double)blockPosInLocal.x(), (double)blockPosInLocal.y(), (double)blockPosInLocal.z());
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            if (!blockState.m_60795_()) {
                return blockPos;
            }
            Vector3d blockPosInLocal2 = ship.getTransform().getWorldToShip().transformPosition(new Vector3d(blockPosInGlobal.x(), blockPosInGlobal.y() - 1.0, blockPosInGlobal.z()));
            BlockPos blockPos2 = BlockPos.m_274561_((double)blockPosInLocal2.x(), (double)blockPosInLocal2.y(), (double)blockPosInLocal2.z());
            BlockState blockState2 = this.f_19853_.m_8055_(blockPos2);
            if (blockState2.m_60795_()) continue;
            return blockPos2;
        }
        return null;
    }

    @Inject(method={"getBlockPosBelowThatAffectsMyMovement"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetBlockPosBelowThatAffectsMyMovement(CallbackInfoReturnable<BlockPos> cir) {
        Vector3d blockPosInGlobal = new Vector3d(this.f_19825_.f_82479_, this.m_20191_().f_82289_ - 0.5, this.f_19825_.f_82481_);
        BlockPos blockPosStandingOnFromShip = this.getPosStandingOnFromShips((Vector3dc)blockPosInGlobal);
        if (blockPosStandingOnFromShip != null) {
            cir.setReturnValue((Object)blockPosStandingOnFromShip);
        }
    }

    @Inject(method={"getOnPos(F)Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetOnPos(CallbackInfoReturnable<BlockPos> cir) {
        Vector3d blockPosInGlobal = new Vector3d(this.f_19825_.f_82479_, this.f_19825_.f_82480_ - 0.2, this.f_19825_.f_82481_);
        BlockPos blockPosStandingOnFromShip = this.getPosStandingOnFromShips((Vector3dc)blockPosInGlobal);
        if (blockPosStandingOnFromShip != null) {
            cir.setReturnValue((Object)blockPosStandingOnFromShip);
        }
    }

    @WrapOperation(method={"spawnSprintParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;blockPosition()Lnet/minecraft/core/BlockPos;")})
    private BlockPos skipBlockPosition(Entity entity, Operation<BlockPos> original, @Local BlockPos posOn) {
        if (VSGameUtilsKt.isBlockInShipyard(this.f_19853_, posOn)) {
            return posOn;
        }
        return (BlockPos)original.call(new Object[]{entity});
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void markImpulsedFirstTick(CallbackInfo ci2) {
        if (this.f_19803_ && this.getDraggingInformation().isEntityBeingDraggedByAShip() && !this.f_19853_.f_46443_) {
            this.f_19812_ = true;
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    private void postBaseTick(CallbackInfo ci2) {
        EntityDraggingInformation entityDraggingInformation = this.getDraggingInformation();
        if (this.f_19853_ != null && this.f_19853_.f_46443_ && this.f_19797_ > 1) {
            LoadedShip ship = VSGameUtilsKt.getLoadedShipManagingPos(this.f_19853_, (Vec3i)this.m_20097_());
            if (ship != null) {
                entityDraggingInformation.setLastShipStoodOn(ship.getId());
                this.m_146897_().forEach(arg_0 -> MixinEntity.lambda$postBaseTick$0((Ship)ship, arg_0));
            } else if (!this.f_19853_.m_8055_(this.m_20097_()).m_60795_()) {
                if (entityDraggingInformation.getIgnoreNextGroundStand()) {
                    entityDraggingInformation.setIgnoreNextGroundStand(false);
                } else {
                    entityDraggingInformation.setLastShipStoodOn(null);
                    this.m_146897_().forEach(entity -> {
                        EntityDraggingInformation passengerDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
                        passengerDraggingInformation.setLastShipStoodOn(null);
                    });
                }
            }
        }
    }

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract void m_20334_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_146872_();

    @Shadow
    protected abstract Vec3 m_20272_(Vec3 var1);

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20185_();

    private static /* synthetic */ void lambda$postBaseTick$0(Ship ship, Entity entity) {
        EntityDraggingInformation passengerDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
        passengerDraggingInformation.setLastShipStoodOn(ship.getId());
    }
}

