/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.compat;

import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterable;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.hooks.VSGameEvents;
import org.valkyrienskies.mod.compat.VSRenderer;
import org.valkyrienskies.mod.mixin.ValkyrienCommonMixinConfigPlugin;
import org.valkyrienskies.mod.mixin.mod_compat.sodium.RenderSectionManagerAccessor;
import org.valkyrienskies.mod.mixinducks.mod_compat.sodium.RenderSectionManagerDuck;

public class SodiumCompat {
    public static void onChunkAdded(ClientLevel level, int x2, int z2) {
        if (ValkyrienCommonMixinConfigPlugin.getVSRenderer() == VSRenderer.SODIUM) {
            ChunkTrackerHolder.get((ClientLevel)level).onChunkStatusAdded(x2, z2, 1);
        }
    }

    public static void onChunkRemoved(ClientLevel level, int x2, int z2) {
        if (ValkyrienCommonMixinConfigPlugin.getVSRenderer() == VSRenderer.SODIUM) {
            ChunkTrackerHolder.get((ClientLevel)level).onChunkStatusRemoved(x2, z2, 1);
        }
    }

    public static void vsRenderLayer(RenderSectionManager renderSectionManager, ChunkRenderMatrices matrices, TerrainRenderPass pass, double x2, double y2, double z2, CommandList commandList) {
        VSGameEvents.INSTANCE.getShipsStartRenderingSodium().emit((Object)new VSGameEvents.ShipStartRenderEventSodium(pass, matrices, x2, y2, z2));
        ((RenderSectionManagerDuck)renderSectionManager).vs_getShipRenderLists().forEach((ship, renderList) -> {
            VSGameEvents.INSTANCE.getRenderShipSodium().emit((Object)new VSGameEvents.ShipRenderEventSodium(pass, matrices, x2, y2, z2, (ClientShip)ship, (SortedRenderLists)renderList));
            ShipTransform shipTransform = ship.getRenderTransform();
            float distanceScaling = 1.0f / (float)shipTransform.getShipToWorldScaling().x();
            float initialFogStart = RenderSystem.getShaderFogStart();
            float initialFogEnd = RenderSystem.getShaderFogEnd();
            if (distanceScaling != 1.0f) {
                RenderSystem.setShaderFogStart((float)(initialFogStart * distanceScaling));
                RenderSystem.setShaderFogEnd((float)(initialFogEnd * distanceScaling));
            }
            Vector3d cameraShipSpace = shipTransform.getWorldToShip().transformPosition(new Vector3d(x2, y2, z2));
            Matrix4dc s2 = ship.getRenderTransform().getShipToWorld();
            Matrix4d newModelView = new Matrix4d(matrices.modelView()).translate(-x2, -y2, -z2).mul(s2).translate((Vector3dc)cameraShipSpace);
            ChunkRenderMatrices newMatrices = new ChunkRenderMatrices(matrices.projection(), (Matrix4fc)new Matrix4f((Matrix4dc)newModelView));
            ((RenderSectionManagerAccessor)renderSectionManager).getChunkRenderer().render(newMatrices, commandList, (ChunkRenderListIterable)renderList, pass, new CameraTransform(cameraShipSpace.x(), cameraShipSpace.y(), cameraShipSpace.z()));
            commandList.close();
            if (distanceScaling != 1.0f) {
                RenderSystem.setShaderFogStart((float)initialFogStart);
                RenderSystem.setShaderFogEnd((float)initialFogEnd);
            }
            VSGameEvents.INSTANCE.getPostRenderShipSodium().emit((Object)new VSGameEvents.ShipRenderEventSodium(pass, matrices, x2, y2, z2, (ClientShip)ship, (SortedRenderLists)renderList));
        });
    }

    public static void renderShips(RenderSectionManager renderSectionManager, RenderType renderLayer, ChunkRenderMatrices matrices, double x2, double y2, double z2) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        if (renderLayer == RenderType.m_110451_()) {
            SodiumCompat.vsRenderLayer(renderSectionManager, matrices, DefaultTerrainRenderPasses.SOLID, x2, y2, z2, commandList);
            SodiumCompat.vsRenderLayer(renderSectionManager, matrices, DefaultTerrainRenderPasses.CUTOUT, x2, y2, z2, commandList);
        } else if (renderLayer == RenderType.m_110466_()) {
            SodiumCompat.vsRenderLayer(renderSectionManager, matrices, DefaultTerrainRenderPasses.TRANSLUCENT, x2, y2, z2, commandList);
        }
        commandList.close();
    }
}

