/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.compat;

import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/valkyrienskies/mod/compat/CreateCompat;", "", "Lnet/minecraft/world/entity/Entity;", "entity", "", "isContraption", "(Lnet/minecraft/world/entity/Entity;)Z", "Lnet/minecraft/core/Vec3i;", "pos", "Lnet/minecraft/world/phys/Vec3;", "getCenterOf", "(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;", "vec", "", "deg", "Lnet/minecraft/core/Direction$Axis;", "axis", "rotate", "(Lnet/minecraft/world/phys/Vec3;DLnet/minecraft/core/Direction$Axis;)Lnet/minecraft/world/phys/Vec3;", "", "p", "from", "to", "lerp", "(FLnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "Ljava/lang/Class;", "contraptionClass", "Ljava/lang/Class;", "<init>", "()V", "valkyrienskies-120"})
public final class CreateCompat {
    @NotNull
    public static final CreateCompat INSTANCE;
    @Nullable
    private static final Class<?> contraptionClass;

    private CreateCompat() {
    }

    @JvmStatic
    public static final boolean isContraption(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Class<?> clazz = contraptionClass;
        return clazz != null ? clazz.isInstance(entity) : false;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 getCenterOf(@NotNull Vec3i pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)pos, (Object)Vec3i.f_123288_)) {
            return new Vec3(0.5, 0.5, 0.5);
        }
        Vec3 vec3 = Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 rotate(@NotNull Vec3 vec, double deg, @NotNull Direction.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        if (deg == 0.0) {
            return vec;
        }
        if (Intrinsics.areEqual((Object)vec, (Object)Vec3.f_82478_)) {
            return vec;
        }
        double angle = deg / (double)180.0f * Math.PI;
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double x2 = vec.f_82479_;
        double y2 = vec.f_82480_;
        double z2 = vec.f_82481_;
        if (axis == Direction.Axis.X) {
            return new Vec3(x2, y2 * cos - z2 * sin, z2 * cos + y2 * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x2 * cos + z2 * sin, y2, z2 * cos - x2 * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x2 * cos - y2 * sin, y2 * cos + x2 * sin, z2);
        }
        return vec;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 lerp(float p2, @NotNull Vec3 from, @NotNull Vec3 to2) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to2, (String)"to");
        Vec3 vec3 = from.m_82549_(to2.m_82546_(from).m_82490_((double)p2));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    static {
        Object object;
        INSTANCE = new CreateCompat();
        Object object2 = INSTANCE;
        try {
            CreateCompat $this$contraptionClass_u24lambda_u240 = object2;
            boolean bl2 = false;
            object = Result.constructor-impl(Class.forName("com.simibubi.create.content.contraptions.AbstractContraptionEntity"));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        contraptionClass = (Class)(Result.isFailure-impl((Object)object2) ? null : object2);
    }
}

