/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010JO\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017JO\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u001aJ?\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/mod/common/VSClientGameUtils;", "", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "ship", "", "multiplyWithShipToWorld", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/valkyrienskies/core/api/ships/ClientShip;)V", "", "offsetX", "offsetY", "offsetZ", "transformRenderIfInShipyard", "(Lcom/mojang/blaze3d/vertex/PoseStack;DDD)V", "getClientShip", "(DDD)Lorg/valkyrienskies/core/api/ships/ClientShip;", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "renderTransform", "camX", "camY", "camZ", "transformRenderWithShip", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lcom/mojang/blaze3d/vertex/PoseStack;DDDDDD)V", "Lorg/joml/Matrix4f;", "matrix", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/joml/Matrix4f;DDDDDD)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/core/BlockPos;DDD)V", "<init>", "()V", "valkyrienskies-120"})
public final class VSClientGameUtils {
    @NotNull
    public static final VSClientGameUtils INSTANCE = new VSClientGameUtils();

    private VSClientGameUtils() {
    }

    @JvmStatic
    public static final void multiplyWithShipToWorld(@NotNull PoseStack poseStack, @NotNull ClientShip ship) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        VectorConversionsMCKt.multiply(poseStack, ship.getRenderTransform().getShipToWorld(), ship.getRenderTransform().getShipToWorldRotation());
    }

    @JvmStatic
    public static final void transformRenderIfInShipyard(@NotNull PoseStack poseStack, double offsetX, double offsetY, double offsetZ) {
        ClientShip ship;
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        ClientShip clientShip = ship = clientLevel != null ? VSGameUtilsKt.getLoadedShipManagingPos(clientLevel, offsetX, offsetY, offsetZ) : null;
        if (ship != null) {
            ShipTransform transform = ship.getRenderTransform();
            Matrix4d renderMatrix = new Matrix4d().mul(transform.getShipToWorld()).translate(offsetX, offsetY, offsetZ);
            Intrinsics.checkNotNull((Object)renderMatrix);
            VectorConversionsMCKt.multiply(poseStack, (Matrix4dc)renderMatrix);
        } else {
            poseStack.m_85837_(offsetX, offsetY, offsetZ);
        }
    }

    @JvmStatic
    @Nullable
    public static final ClientShip getClientShip(double offsetX, double offsetY, double offsetZ) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        return clientLevel != null ? VSGameUtilsKt.getLoadedShipManagingPos(clientLevel, offsetX, offsetY, offsetZ) : null;
    }

    @JvmStatic
    public static final void transformRenderWithShip(@NotNull ShipTransform renderTransform, @NotNull PoseStack poseStack, double offsetX, double offsetY, double offsetZ, double camX, double camY, double camZ) {
        Intrinsics.checkNotNullParameter((Object)renderTransform, (String)"renderTransform");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Matrix4dc shipToWorldMatrix = renderTransform.getShipToWorld();
        Matrix4d renderMatrix = new Matrix4d();
        renderMatrix.translate(-camX, -camY, -camZ);
        renderMatrix.mul(shipToWorldMatrix);
        renderMatrix.translate(offsetX, offsetY, offsetZ);
        VectorConversionsMCKt.multiply(poseStack, (Matrix4dc)renderMatrix, renderTransform.getShipToWorldRotation());
    }

    @JvmStatic
    public static final void transformRenderWithShip(@NotNull ShipTransform renderTransform, @NotNull Matrix4f matrix, double offsetX, double offsetY, double offsetZ, double camX, double camY, double camZ) {
        Intrinsics.checkNotNullParameter((Object)renderTransform, (String)"renderTransform");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Matrix4dc shipToWorldMatrix = renderTransform.getShipToWorld();
        Matrix4d renderMatrix = new Matrix4d();
        renderMatrix.translate(-camX, -camY, -camZ);
        renderMatrix.mul(shipToWorldMatrix);
        renderMatrix.translate(offsetX, offsetY, offsetZ);
        matrix.mul((Matrix4fc)new Matrix4f((Matrix4dc)renderMatrix));
    }

    @JvmStatic
    public static final void transformRenderWithShip(@NotNull ShipTransform renderTransform, @NotNull PoseStack matrix, @NotNull BlockPos blockPos, double camX, double camY, double camZ) {
        Intrinsics.checkNotNullParameter((Object)renderTransform, (String)"renderTransform");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        VSClientGameUtils.transformRenderWithShip(renderTransform, matrix, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), camX, camY, camZ);
    }
}

