/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.foundation.utility.SameSizeCombinedInvWrapper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ColoredStorageContainerBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected LazyOptional<IItemHandler> itemCapability;
    protected InventoryIdentifier invId;
    protected ItemStackHandler inventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;
    protected Direction.Axis axis;
    protected int checkTickRate;
    protected int checkTickCounter;

    public ColoredStorageContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setCheckTickRate(4);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ColoredStorageContainerBlockEntity.this.updateComparators();
            }
        };
        this.radius = 1;
        this.length = 1;
    }

    public void initialize() {
        super.initialize();
        this.repairContainer();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (Objects.requireNonNull(this.m_58904_()).m_5776_()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
        this.updateColors();
    }

    protected void updateComparators() {
        ColoredStorageContainerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        Objects.requireNonNull(this.m_58904_()).m_151543_(controllerBE.f_58858_);
        BlockPos pos = controllerBE.m_58899_();
        for (int y = 0; y < controllerBE.radius; ++y) {
            for (int z = 0; z < (controllerBE.axis == Direction.Axis.X ? controllerBE.radius : controllerBE.length); ++z) {
                for (int x = 0; x < (controllerBE.axis == Direction.Axis.Z ? controllerBE.radius : controllerBE.length); ++x) {
                    this.m_58904_().m_46717_(pos.m_7918_(x, y, z), this.m_58900_().m_60734_());
                }
            }
        }
    }

    public void updateCheck() {
        if (this.getControllerBE() == null) {
            return;
        }
        if (this.getControllerBE().m_58900_().m_61143_(ColoredStorageContainerBlock.COLOR) != this.m_58900_().m_61143_(ColoredStorageContainerBlock.COLOR)) {
            this.updateColors();
        }
    }

    public void repairContainer() {
        if (this.getControllerBE() == null) {
            return;
        }
        if (this.getControllerBE().m_58900_().m_61143_(ColoredStorageContainerBlock.COLOR) != this.m_58900_().m_61143_(ColoredStorageContainerBlock.COLOR)) {
            Objects.requireNonNull(this.m_58904_()).m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(ColoredStorageContainerBlock.COLOR, (Comparable)((DyeColor)this.getControllerBE().m_58900_().m_61143_(ColoredStorageContainerBlock.COLOR))));
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.checkTickCounter <= 0) {
            this.checkTickCounter = this.checkTickRate;
            this.repairContainer();
        } else {
            this.updateCheck();
        }
    }

    public void setCheckTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public ColoredStorageContainerBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = Objects.requireNonNull(this.m_58904_()).m_7702_(this.controller);
        if (blockEntity instanceof ColoredStorageContainerBlockEntity) {
            ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (Objects.requireNonNull(this.m_58904_()).m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.m_58900_();
        if (ColoredStorageContainerBlock.isVault(state)) {
            state = (BlockState)state.m_61124_((Property)ColoredStorageContainerBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.itemCapability = null;
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (Objects.requireNonNull(this.m_58904_()).f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    public void updateColors() {
        Objects.requireNonNull(this.m_58904_()).m_46597_(this.getControllerBE().m_58899_(), (BlockState)this.getControllerBE().m_58900_().m_61124_(ColoredStorageContainerBlock.COLOR, (Comparable)this.getMostColor()));
        if (this.isController()) {
            for (int y = 0; y < this.radius; ++y) {
                for (int z = 0; z < (this.getControllerBE().axis == Direction.Axis.X ? this.radius : this.length); ++z) {
                    for (int x = 0; x < (this.getControllerBE().axis == Direction.Axis.Z ? this.radius : this.length); ++x) {
                        BlockPos pos = this.getControllerBE().m_58899_().m_7918_(x, y, z);
                        BlockState stateAtPos = Objects.requireNonNull(this.m_58904_()).m_8055_(pos);
                        BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
                        if (blockEntity instanceof ColoredStorageContainerBlockEntity) {
                            ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
                            if (this.getController() != be.getController()) continue;
                        }
                        if (stateAtPos.m_60795_() || !stateAtPos.m_61138_(ColoredStorageContainerBlock.COLOR) || this.getMostColor() == null) continue;
                        this.m_58904_().m_46597_(pos, (BlockState)stateAtPos.m_61124_(ColoredStorageContainerBlock.COLOR, (Comparable)this.getMostColor()));
                    }
                }
            }
        }
    }

    public DyeColor getMostColor() {
        HashMap<DyeColor, Integer> colorCountMap = new HashMap<DyeColor, Integer>();
        DyeColor colorController = (DyeColor)this.getControllerBE().m_58900_().m_61143_(ColoredStorageContainerBlock.COLOR);
        colorCountMap.put(colorController, colorCountMap.getOrDefault(colorController, 0) + 1);
        if (this.isController()) {
            for (int y = 0; y < this.radius; ++y) {
                for (int z = 0; z < (this.getControllerBE().axis == Direction.Axis.X ? this.radius : this.length); ++z) {
                    for (int x = 0; x < (this.getControllerBE().axis == Direction.Axis.Z ? this.radius : this.length); ++x) {
                        BlockPos pos = this.getControllerBE().m_58899_().m_7918_(x, y, z);
                        BlockState stateAtPos = Objects.requireNonNull(this.m_58904_()).m_8055_(pos);
                        BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
                        if (blockEntity instanceof ColoredStorageContainerBlockEntity) {
                            ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
                            if (this.getController() != be.getController()) continue;
                        }
                        if (stateAtPos.m_60795_() || !stateAtPos.m_61138_(ColoredStorageContainerBlock.COLOR)) continue;
                        DyeColor color = (DyeColor)stateAtPos.m_61143_(ColoredStorageContainerBlock.COLOR);
                        colorCountMap.put(color, colorCountMap.getOrDefault(color, 0) + 1);
                    }
                }
            }
        }
        return colorCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.length = compound.m_128451_("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.m_58898_() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            Objects.requireNonNull(this.m_58904_()).m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Length", this.length);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128359_("StorageType", "CombinedInv");
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    private void initCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            ColoredStorageContainerBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            this.invId = controllerBE.invId;
            return;
        }
        boolean alongZ = ItemVaultBlock.getVaultBlockAxis((BlockState)this.m_58900_()) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.f_58858_.m_7918_(xOffset, zOffset, yOffset) : this.f_58858_.m_7918_(yOffset, xOffset, zOffset);
                    ColoredStorageContainerBlockEntity vaultAt = (ColoredStorageContainerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)AllBlockEntityTypes.ITEM_VAULT.get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)SameSizeCombinedInvWrapper.create((IItemHandlerModifiable[])invs));
        this.itemCapability = LazyOptional.of(() -> ColoredStorageContainerBlockEntity.lambda$initCapability$0((IItemHandler)itemHandler));
        BlockPos farCorner = alongZ ? this.f_58858_.m_7918_(this.radius, this.radius, this.length) : this.f_58858_.m_7918_(this.length, this.radius, this.radius);
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)this.f_58858_, (Vec3i)farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (ColoredStorageContainerBlock.isVault(state)) {
            Objects.requireNonNull(this.m_58904_()).m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)ColoredStorageContainerBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.itemCapability.invalidate();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public InventoryIdentifier getInvId() {
        this.initCapability();
        return this.invId;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return ColoredStorageContainerBlockEntity.getMaxLength(width);
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

