/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlockEntity;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ColoredStorageContainerBlock
extends Block
implements IWrenchable,
IBE<ColoredStorageContainerBlockEntity> {
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty LARGE = BooleanProperty.m_61465_((String)"large");
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"colors", DyeColor.class);
    public static final SoundType SILENCED_METAL = new SoundType(0.1f, 1.5f, SoundEvents.f_12198_, SoundEvents.f_12199_, SoundEvents.f_12200_, SoundEvents.f_12201_, SoundEvents.f_12202_);

    public ColoredStorageContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)DyeColor.WHITE));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        DyeItem dyeItem;
        ItemStack pStack = player.m_21120_(hand);
        Item item = pStack.m_41720_();
        if (item instanceof DyeItem && this.applyDye(state, level, pos, (dyeItem = (DyeItem)item).m_41089_(), player, pStack)) {
            level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.1f - level.f_46441_.m_188501_() * 0.2f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public boolean applyDye(BlockState pState, Level pLevel, BlockPos pPos, @Nullable DyeColor pDyeColor, Player pPlayer, ItemStack pDyeStack) {
        BlockEntity blockEntity;
        assert (pDyeColor != null);
        if (!pState.m_61138_(COLOR) || pDyeStack.m_41619_() || !((blockEntity = pLevel.m_7702_(pPos)) instanceof ColoredStorageContainerBlockEntity)) {
            return false;
        }
        ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
        ColoredStorageContainerBlockEntity controllerBE = be.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        BlockState blockState = pLevel.m_8055_(controllerBE.m_58899_());
        BlockState newState = (BlockState)blockState.m_61124_(COLOR, (Comparable)pDyeColor);
        if (blockState.m_61143_(COLOR) != newState.m_61143_(COLOR)) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if (be.isController()) {
                int radius = be.radius;
                int length = be.length;
                for (int y = 0; y < radius; ++y) {
                    for (int z = 0; z < (controllerBE.axis == Direction.Axis.X ? radius : length); ++z) {
                        for (int x = 0; x < (controllerBE.axis == Direction.Axis.Z ? radius : length); ++x) {
                            BlockPos pos = controllerBE.m_58899_().m_7918_(x, y, z);
                            BlockState stateAtPos = pLevel.m_8055_(pos);
                            BlockEntity blockEntity2 = pLevel.m_7702_(pos);
                            if (blockEntity2 instanceof ColoredStorageContainerBlockEntity) {
                                ColoredStorageContainerBlockEntity be2 = (ColoredStorageContainerBlockEntity)blockEntity2;
                                if (be.getController() != be2.getController()) continue;
                            }
                            if (stateAtPos.m_60795_() || !stateAtPos.m_61138_(COLOR)) continue;
                            positions.add(pos);
                        }
                    }
                }
            }
            pLevel.m_46597_(controllerBE.m_58899_(), (BlockState)controllerBE.m_58900_().m_61124_(COLOR, (Comparable)pDyeColor));
            for (BlockPos pos : positions) {
                pLevel.m_46597_(pos, (BlockState)pLevel.m_8055_(pos).m_61124_(COLOR, (Comparable)pDyeColor));
            }
            if (!pPlayer.m_7500_()) {
                pDyeStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HORIZONTAL_AXIS, LARGE, COLOR});
        super.m_7926_(pBuilder);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.m_43723_() != null && pContext.m_43723_().m_6144_() || (preferredAxis = ColoredStorageContainerBlock.getVaultBlockAxis(placedOn = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_())))) == null)) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public void m_6807_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == pState.m_60734_()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ColoredStorageContainerBlockEntity::updateConnectivity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_().m_122478_()) {
            BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
            if (be instanceof ColoredStorageContainerBlockEntity) {
                ColoredStorageContainerBlockEntity vault = (ColoredStorageContainerBlockEntity)be;
                ConnectivityHandler.splitMulti((BlockEntity)vault);
                vault.removeController(true);
            }
            state = (BlockState)state.m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        return super.onWrenched(state, context);
    }

    public void m_6810_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean pIsMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof ColoredStorageContainerBlockEntity)) {
                return;
            }
            ColoredStorageContainerBlockEntity vaultBE = (ColoredStorageContainerBlockEntity)be;
            ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)vaultBE.inventory);
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)vaultBE);
        }
    }

    public static boolean isVault(BlockState state) {
        return false;
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state) {
        if (!ColoredStorageContainerBlock.isVault(state)) {
            return null;
        }
        return (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(BlockState state) {
        if (!ColoredStorageContainerBlock.isVault(state)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)LARGE);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)rot.m_55954_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_());
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state;
    }

    @NotNull
    public SoundType getSoundType(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceVaultSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean m_7278_(@NotNull BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return ItemHelper.calcRedstoneFromBlockEntity((IBE)this, (Level)pLevel, (BlockPos)pPos);
    }

    public BlockEntityType<? extends ColoredStorageContainerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DnDecorBETypes.COLORED_STORAGE_CONTAINER.get();
    }

    public Class<ColoredStorageContainerBlockEntity> getBlockEntityClass() {
        return ColoredStorageContainerBlockEntity.class;
    }
}

