/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.frontlight;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.lopyluna.dndecor.content.blocks.frontlight.Frontlight;
import dev.lopyluna.dndecor.register.DnDecorShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class FrontlightBlock
extends Block
implements IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<Frontlight> ADDITIVE = EnumProperty.m_61587_((String)"additive", Frontlight.class);
    public static final BooleanProperty ROTATED = BooleanProperty.m_61465_((String)"rotated");

    public FrontlightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(ADDITIVE, (Comparable)((Object)Frontlight.TOP))).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getLight(BlockState state) {
        Boolean lit = (Boolean)state.m_61143_((Property)LIT);
        return lit != false ? 15 : 0;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction face = (Direction)pState.m_61143_((Property)FACING);
        if (face.m_122434_().m_122478_()) {
            face = face == Direction.DOWN ? Direction.UP : Direction.DOWN;
        }
        return DnDecorShapes.shape(3.0, 3.0, 8.0, 13.0, 13.0, 16.0).forDirectional(Direction.NORTH).get(face);
    }

    protected boolean hasNeighborSignal(Level level, BlockPos pos, Direction direction) {
        return level.m_276987_(pos.m_121945_(direction), direction) || level.m_276867_(pos.m_121945_(direction));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean flag = this.hasNeighborSignal(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122424_());
        if (flag != (Boolean)state.m_61143_((Property)LIT)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(flag)));
            level.m_247517_(null, pos, (Boolean)state.m_61143_((Property)LIT) != false ? SoundEvents.f_12056_ : SoundEvents.f_12055_, SoundSource.BLOCKS);
        }
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face);
        if (!base.m_60710_((LevelReader)level, pos)) {
            return null;
        }
        boolean flag = this.hasNeighborSignal(level, pos, face.m_122424_());
        if (flag != (Boolean)base.m_61143_((Property)LIT)) {
            base = (BlockState)base.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(flag));
        }
        if (face.m_122434_().m_122478_()) {
            base = (BlockState)base.m_61124_(ADDITIVE, (Comparable)((Object)Frontlight.EMPTY));
        }
        return base;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(dir.m_122424_()), (Direction)dir);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState rotated;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState blockState = rotated = face.m_122434_().equals((Object)((Direction)state.m_61143_((Property)FACING)).m_122434_()) ? (BlockState)state.m_61122_((Property)ROTATED) : (BlockState)state.m_61122_(ADDITIVE);
        if (!rotated.m_60710_((LevelReader)level, context.m_8083_())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.m_8055_(pos) != state) {
            AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.f_46441_.m_188501_() + 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT, ADDITIVE, ROTATED});
    }
}

