/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.cogs;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DnDCogWheelBlock
extends CogWheelBlock {
    boolean isLarge;
    public DyeColor color;
    public PartialModel customModel;

    public DnDCogWheelBlock(DyeColor color, boolean large, BlockBehaviour.Properties properties) {
        super(large, properties);
        this.color = color;
        this.isLarge = large;
    }

    public DnDCogWheelBlock(PartialModel model, boolean large, BlockBehaviour.Properties properties) {
        super(large, properties);
        this.customModel = model;
        this.isLarge = large;
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((Direction.Axis)state.m_61143_((Property)AXIS));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return DnDCogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog((BlockState)state), worldIn, pos, (Direction.Axis)state.m_61143_((Property)AXIS));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.triggerShiftingGearsAdvancement(worldIn, pos, state, player);
        }
    }

    protected void triggerShiftingGearsAdvancement(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.f_46443_ || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.m_5484_(d1, offset1).m_5484_(d2, offset2);
                        BlockState blockState = world.m_8055_(connectedPos);
                        if (!(blockState.m_60734_() instanceof DnDCogWheelBlock) || blockState.m_61143_((Property)AXIS) != axis || ICogWheel.isLargeCog((BlockState)blockState) == this.isLarge) continue;
                        AllAdvancements.COGS.awardTo(player);
                    }
                }
            }
        }
    }

    public static boolean isValidCogwheelPosition(boolean large, LevelReader worldIn, BlockPos pos, Direction.Axis cogAxis) {
        for (Direction facing : Iterate.directions) {
            BlockPos offsetPos;
            BlockState blockState;
            if (facing.m_122434_() == cogAxis || (blockState = worldIn.m_8055_(offsetPos = pos.m_121945_(facing))).m_61138_((Property)AXIS) && facing.m_122434_() == blockState.m_61143_((Property)AXIS) || !ICogWheel.isLargeCog((BlockState)blockState) && (!large || !ICogWheel.isSmallCog((BlockState)blockState))) continue;
            return false;
        }
        return true;
    }

    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return context.m_43719_().m_122434_();
        }
        Level world = context.m_43725_();
        BlockState stateBelow = world.m_8055_(context.m_8083_().m_7495_());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLargeCog()) {
            return stateBelow.m_61143_(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        }
        BlockPos placedOnPos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState placedAgainst = world.m_8055_(placedOnPos);
        Block block = placedAgainst.m_60734_();
        if (ICogWheel.isSmallCog((BlockState)placedAgainst)) {
            return ((IRotate)block).getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = DnDCogWheelBlock.getPreferredAxis((BlockPlaceContext)context);
        return preferredAxis != null ? preferredAxis : context.m_43719_().m_122434_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean shouldWaterlog = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AXIS, (Comparable)this.getAxisForPlacement(context))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(shouldWaterlog));
    }

    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DnDecorBETypes.COLORED_COGWHEELS.get();
    }
}

