/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.bolt;

import net.minecraft.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;

public enum BoltRotation implements StringRepresentable
{
    D0("0", 0, 1, 7),
    D45("45", 1, 2, 0),
    D90("90", 2, 3, 1),
    D135("135", 3, 4, 2),
    D180("180", 4, 5, 3),
    D225("225", 5, 6, 4),
    D270("270", 6, 7, 5),
    D315("315", 7, 0, 6);

    public static final BoltRotation[] VALUES;
    public static final StringRepresentable.EnumCodec<BoltRotation> CODEC;
    final String name;
    final int id;
    final int next;
    final int prev;

    private BoltRotation(String name, int id, int next, int prev) {
        this.name = name;
        this.id = id;
        this.next = next;
        this.prev = prev;
    }

    public int getNextID() {
        return this.next;
    }

    public BoltRotation getNext() {
        return BoltRotation.getByID(this.next);
    }

    public int getPrevID() {
        return this.prev;
    }

    public BoltRotation getPrev() {
        return BoltRotation.getByID(this.prev);
    }

    public int getId() {
        return this.id;
    }

    public BoltRotation getRotation(Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> this;
            case Rotation.CLOCKWISE_90 -> this.getPrev().getPrev();
            case Rotation.CLOCKWISE_180 -> this.getPrev().getPrev().getPrev().getPrev();
            case Rotation.COUNTERCLOCKWISE_90 -> this.getNext().getNext();
        };
    }

    public static BoltRotation fromPlayerFacing(Player player) {
        return BoltRotation.fromYaw(player.m_146908_());
    }

    public static BoltRotation fromYaw(double yaw) {
        yaw = (yaw + 360.0) % 360.0;
        return BoltRotation.getByID((int)((yaw + 22.5) / 45.0) % 8);
    }

    public static BoltRotation getByID(int id) {
        int bound = id;
        if (bound < 0) {
            bound = 8;
        }
        return VALUES[bound % 8];
    }

    public static BoltRotation getRandom(RandomSource random) {
        return (BoltRotation)((Object)Util.m_214670_((Object[])VALUES, (RandomSource)random));
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    static {
        VALUES = BoltRotation.values();
        CODEC = StringRepresentable.m_216439_(BoltRotation::values);
    }
}

