/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.beam;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BeamBlock
extends Block
implements IWrenchable {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<BeamStates> BEAM = EnumProperty.m_61587_((String)"beam", BeamStates.class);

    public BeamBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(BEAM, (Comparable)((Object)BeamStates.BOTH)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BeamStates beam = (BeamStates)((Object)state.m_61143_(BEAM));
        if (face == Direction.UP) {
            beam = beam == BeamStates.TOP ? BeamStates.BOTH : BeamStates.TOP;
        }
        if (face == Direction.DOWN) {
            beam = beam == BeamStates.BOTTOM ? BeamStates.BOTH : BeamStates.BOTTOM;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(BEAM, (Comparable)((Object)beam))));
        if (level.m_8055_(pos) != state) {
            AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.f_46441_.m_188501_() + 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, BEAM});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        Direction.Axis direction;
        BlockState stateForPlacement = super.m_5573_(pContext);
        Direction face = pContext.m_43719_();
        Direction.Axis axis = direction = face.m_122434_().m_122479_() ? face.m_122434_() : pContext.m_8125_().m_122434_();
        if (stateForPlacement != null) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)direction);
        }
        return stateForPlacement;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        return (BlockState)state.m_61124_(AXIS, (Comparable)rot.m_55954_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)).m_122434_());
    }

    public static enum BeamStates implements StringRepresentable
    {
        TOP,
        BOTTOM,
        BOTH;


        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

