/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.loot;

import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.loot.AddPerWorldPatternToScrollFunc;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.forge.lib.ForgeHexLootMods;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ForgeHexScrollLootMod
extends LootModifier {
    public static final Supplier<Codec<ForgeHexScrollLootMod>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ForgeHexScrollLootMod.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.INT.fieldOf("countRange").forGetter(it -> it.countRange)).apply((Applicative)inst, ForgeHexScrollLootMod::new)));
    public final int countRange;

    public ForgeHexScrollLootMod(LootItemCondition[] conditionsIn, int countRange) {
        super(conditionsIn);
        this.countRange = countRange;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int count = this.countRange < 0 ? 1 : HexLootHandler.getScrollCount(this.countRange, context.m_230907_());
        for (int i = 0; i < count; ++i) {
            ItemStack newStack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
            AddPerWorldPatternToScrollFunc.doStatic(newStack, context.m_230907_(), context.m_78952_().m_7654_().m_129783_());
            generatedLoot.add((Object)newStack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)ForgeHexLootMods.INJECT_SCROLLS.get();
    }
}

