/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.pigment;

import at.petrak.hexcasting.api.addldata.ADPigment;
import at.petrak.hexcasting.api.item.PigmentItem;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.paucal.api.PaucalAPI;
import at.petrak.paucal.api.contrib.Contributor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemUUIDPigment
extends Item
implements PigmentItem {
    public ItemUUIDPigment(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public ColorProvider provideColor(ItemStack stack, UUID owner) {
        return new MyColorProvider(owner);
    }

    protected static class MyColorProvider
    extends ColorProvider {
        private final int[] colors;

        MyColorProvider(UUID owner) {
            JsonArray colorList;
            Contributor contributor = PaucalAPI.instance().getContributor(owner);
            if (contributor != null && (colorList = contributor.otherVals().getAsJsonArray("hexcasting:colorizer")) != null) {
                int[] colors = new int[colorList.size()];
                boolean ok = true;
                for (int i = 0; i < colorList.size(); ++i) {
                    JsonPrimitive n;
                    JsonElement elt = colorList.get(i);
                    if (!(elt instanceof JsonPrimitive) || !(n = (JsonPrimitive)elt).isNumber()) {
                        ok = false;
                        break;
                    }
                    colors[i] = n.getAsNumber().intValue() | 0xFF000000;
                }
                if (ok) {
                    this.colors = colors;
                    return;
                }
            }
            Random rand = new Random(owner.getLeastSignificantBits() ^ owner.getMostSignificantBits());
            float hue1 = rand.nextFloat();
            float saturation1 = rand.nextFloat(0.4f, 0.8f);
            float brightness1 = rand.nextFloat(0.7f, 1.0f);
            float hue2 = rand.nextFloat();
            float saturation2 = rand.nextFloat(0.7f, 1.0f);
            float brightness2 = rand.nextFloat(0.2f, 0.7f);
            int col1 = Color.HSBtoRGB(hue1, saturation1, brightness1);
            int col2 = Color.HSBtoRGB(hue2, saturation2, brightness2);
            this.colors = new int[]{col1, col2};
        }

        @Override
        protected int getRawColor(float time, Vec3 position) {
            return ADPigment.morphBetweenColors(this.colors, new Vec3(0.1, 0.1, 0.1), time / 400.0f, position);
        }
    }
}

