/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.arithmetic.operator.list.OperatorUnique;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BinaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00040\u000fH\u0002J\u0016\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lat/petrak/hexcasting/common/casting/arithmetic/ListSetArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "()V", "OPS", "", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "kotlin.jvm.PlatformType", "arithName", "", "getOperator", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "pattern", "make2", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "op", "Ljava/util/function/BinaryOperator;", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "opTypes", "hexcasting-forge-1.20.1"})
public final class ListSetArithmetic
implements Arithmetic {
    @NotNull
    public static final ListSetArithmetic INSTANCE = new ListSetArithmetic();
    @NotNull
    private static final List<HexPattern> OPS;

    private ListSetArithmetic() {
    }

    @Override
    @NotNull
    public String arithName() {
        return "list_set_ops";
    }

    @NotNull
    public List<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.AND)) {
            operator = this.make2(ListSetArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.OR)) {
            operator = this.make2(ListSetArithmetic::getOperator$lambda$5);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.XOR)) {
            operator = this.make2(ListSetArithmetic::getOperator$lambda$10);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.UNIQUE)) {
            operator = OperatorUnique.INSTANCE;
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    private final OperatorBinary make2(BinaryOperator<List<Iota>> op) {
        return new OperatorBinary(IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.LIST)), (arg_0, arg_1) -> ListSetArithmetic.make2$lambda$11(op, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private static final List getOperator$lambda$2(List list0, List list1) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list0, (String)"list0");
        Intrinsics.checkNotNullParameter((Object)list1, (String)"list1");
        Iterable $this$filter$iv = list0;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                Iota x = (Iota)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = list1;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Iota it = (Iota)element$iv;
                        boolean bl3 = false;
                        if (!Iota.tolerates(x, it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getOperator$lambda$5(List list0, List list1) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)list0, (String)"list0");
        Intrinsics.checkNotNullParameter((Object)list1, (String)"list1");
        Iterable iterable = list1;
        Collection collection = list0;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                Iota x = (Iota)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = list0;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Iota it = (Iota)element$iv;
                        boolean bl3 = false;
                        if (!Iota.tolerates(x, it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final List getOperator$lambda$10(List list0, List list1) {
        Iota it;
        boolean $i$f$none;
        Iterable $this$none$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list0, (String)"list0");
        Intrinsics.checkNotNullParameter((Object)list1, (String)"list1");
        Iterable $this$filter$iv = list0;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                Iota x0 = (Iota)element$iv$iv;
                boolean bl2 = false;
                $this$none$iv = list1;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Iota)element$iv;
                        boolean bl3 = false;
                        if (!Iota.tolerates(x0, it)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = list1;
        Collection collection = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                Iota x1 = (Iota)element$iv$iv;
                boolean bl4 = false;
                $this$none$iv = list0;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Iota)element$iv;
                        boolean bl5 = false;
                        if (!Iota.tolerates(x1, it)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final Iota make2$lambda$11(BinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        IotaType<ListIota> iotaType = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"LIST");
        SpellList spellList = Operator.Companion.downcast(i, iotaType).getList();
        Intrinsics.checkNotNullExpressionValue((Object)spellList, (String)"downcast(i, LIST).list");
        List list = CollectionsKt.toList((Iterable)spellList);
        IotaType<ListIota> iotaType2 = HexIotaTypes.LIST;
        Intrinsics.checkNotNullExpressionValue(iotaType2, (String)"LIST");
        SpellList spellList2 = Operator.Companion.downcast(j, iotaType2).getList();
        Intrinsics.checkNotNullExpressionValue((Object)spellList2, (String)"downcast(j, LIST).list");
        return new ListIota((List)$op.apply(list, CollectionsKt.toList((Iterable)spellList2)));
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.AND, Arithmetic.OR, Arithmetic.XOR, Arithmetic.UNIQUE};
        OPS = CollectionsKt.listOf((Object[])objectArray);
    }
}

