/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.RenderLib;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.phys.Vec2;

public interface HexPatternLike {
    public List<Vec2> getNonZappyPoints();

    public String getName();

    public Set<Integer> getDups();

    public static HexPatternLike of(HexPattern pat) {
        return new HexPatternLikeBecauseItsActuallyAHexPattern(pat);
    }

    public static HexPatternLike of(List<Vec2> lines, String name) {
        return new PureLines(lines, name);
    }

    public record HexPatternLikeBecauseItsActuallyAHexPattern(HexPattern pat) implements HexPatternLike
    {
        @Override
        public List<Vec2> getNonZappyPoints() {
            return this.pat.toLines(1.0f, Vec2.f_82462_);
        }

        @Override
        public String getName() {
            return this.pat.getStartDir() + "-" + this.pat.anglesSignature();
        }

        @Override
        public Set<Integer> getDups() {
            return RenderLib.findDupIndices(this.pat.positions());
        }
    }

    public record PureLines(List<Vec2> lines, String name) implements HexPatternLike
    {
        @Override
        public List<Vec2> getNonZappyPoints() {
            return this.lines;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Integer> getDups() {
            return RenderLib.findDupIndices(this.lines().stream().map(p -> new Vec2(p.f_82470_, p.f_82471_, (Vec2)p){
                final /* synthetic */ Vec2 val$p;
                {
                    this.val$p = vec2;
                    super(p_82474_, p_82475_);
                }

                public boolean equals(Object other) {
                    if (other instanceof Vec2) {
                        Vec2 otherVec = (Vec2)other;
                        return this.val$p.m_82476_(otherVec);
                    }
                    return false;
                }

                public int hashCode() {
                    return Objects.hash(Float.valueOf(this.val$p.f_82470_), Float.valueOf(this.val$p.f_82471_));
                }
            }).toList());
        }
    }
}

