/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Function3;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.entities.DeathEssenceEntity;
import it.hurts.sskirillss.relics.entities.LifeEssenceEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.SyncTargetPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HolyLocketItem
extends RelicItem
implements IRenderableCurio {
    public static final String TAG_TOGGLED = "toggled";
    public static final String TAG_CHARGE = "charge";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("belief").active(CastData.builder().type(CastType.INSTANTANEOUS).build()).icon((Function3<Player, ItemStack, String, String>)((Function3)(player, stack, ability) -> ability + (NBTUtils.getBoolean(stack, TAG_TOGGLED, true) ? "_holy" : "_wicked"))).stat(StatData.builder("radius").initialValue(3.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("amount").initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).stat(StatData.builder("count").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("capacity").initialValue(8.0, 12.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).ability(AbilityData.builder("repentance").requiredLevel(5).stat(StatData.builder("radius").initialValue(2.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("damage").initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).build()).ability(AbilityData.builder("blessing").maxLevel(5).requiredPoints(2).requiredLevel(10).active(CastData.builder().type(CastType.TOGGLEABLE).castPredicate("blessing", (player, stack) -> this.getCharges((ItemStack)stack) > 0).build()).stat(StatData.builder("consumption").initialValue(8.0, 6.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).leveling(new LevelingData(100, 15, 100)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.DESERT).build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("belief")) {
            NBTUtils.setBoolean(stack, TAG_TOGGLED, !NBTUtils.getBoolean(stack, TAG_TOGGLED, true));
        }
    }

    public List<Monster> gatherMonsters(Player player, ItemStack stack) {
        return player.m_20193_().m_45976_(Monster.class, player.m_20191_().m_82400_(this.getAbilityValue(stack, "repentance", "radius"))).stream().filter(LivingEntity::m_21222_).toList();
    }

    public int getMaxCharges(ItemStack stack) {
        return (int)this.getAbilityValue(stack, "belief", "capacity");
    }

    public void setCharges(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, TAG_CHARGE, Mth.m_14045_((int)amount, (int)0, (int)this.getMaxCharges(stack)));
    }

    public void addCharge(ItemStack stack, int amount) {
        this.setCharges(stack, this.getCharges(stack) + amount);
    }

    public int getCharges(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_CHARGE, 0);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        List<Monster> monsters;
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20193_().m_5776_() || player.f_19797_ % 20 != 0) {
            return;
        }
        Level level = player.m_20193_();
        int charges = this.getCharges(stack);
        if (this.isAbilityTicking(stack, "blessing")) {
            this.setCharges(stack, (int)((double)charges - this.getAbilityValue(stack, "blessing", "consumption")));
            if (charges <= 0) {
                this.setAbilityTicking(stack, "blessing", false);
            }
        }
        if ((monsters = this.gatherMonsters(player, stack)).isEmpty() || charges <= 0) {
            return;
        }
        for (Monster entity : monsters) {
            if (!EntityUtils.hurt((LivingEntity)entity, player.m_9236_().m_269111_().m_269075_(player), (float)((double)charges * this.getAbilityValue(stack, "repentance", "damage")))) continue;
            entity.m_7311_(50);
            this.spreadExperience((LivingEntity)player, stack, 1);
            RandomSource random = level.m_213780_();
            ((ServerLevel)level).m_8767_(ParticleUtils.constructSimpleSpark(new Color(200, 150 + random.m_188503_(50), random.m_188503_(50)), 0.4f, 20, 0.95f), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 10, (double)(entity.m_20205_() / 2.0f), (double)(entity.m_20206_() / 2.0f), (double)(entity.m_20205_() / 2.0f), (double)0.025f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        model.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-8.0f, -1.15f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)1.15f, (float)0.0f));
        bone.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.6096f, -0.8646f, -0.2f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0571f, (float)6.6447f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)0.2568f));
        bone.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(12, 18).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.15f)), PartPose.m_171423_((float)0.0877f, (float)6.2393f, (float)-5.2f, (float)0.0f, (float)0.0f, (float)0.7854f));
        bone.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0322f, -2.5947f, -0.225f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)0.0571f, (float)6.6447f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)-0.004f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get());
                Item item = stack.m_41720_();
                if (item instanceof HolyLocketItem) {
                    int charges;
                    HolyLocketItem relic = (HolyLocketItem)item;
                    if (relic.isAbilityTicking((ItemStack)stack, "blessing")) {
                        event.setCanceled(true);
                        return;
                    }
                    if (NBTUtils.getBoolean((ItemStack)stack, HolyLocketItem.TAG_TOGGLED, false) && (charges = relic.getCharges((ItemStack)stack)) > 0) {
                        event.setAmount(event.getAmount() * (1.0f - (float)charges * 0.01f));
                    }
                }
            } else {
                Player player;
                Item charges;
                stack = event.getSource().m_7639_();
                if (stack instanceof Player && (charges = (stack = EntityUtils.findEquippedCurio((Entity)(player = (Player)stack), (Item)ItemRegistry.HOLY_LOCKET.get())).m_41720_()) instanceof HolyLocketItem) {
                    HolyLocketItem relic = (HolyLocketItem)charges;
                    if (!NBTUtils.getBoolean((ItemStack)stack, HolyLocketItem.TAG_TOGGLED, false) && (charges = relic.getCharges((ItemStack)stack)) > 0) {
                        event.setAmount(event.getAmount() + event.getAmount() * (float)charges * 0.01f);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingHeal(LivingHealEvent event) {
            block11: {
                block8: {
                    HolyLocketItem relic;
                    Level level;
                    ItemStack stack;
                    Player player;
                    block10: {
                        block9: {
                            if (event.getAmount() <= 0.5f) {
                                return;
                            }
                            LivingEntity livingEntity = event.getEntity();
                            if (!(livingEntity instanceof Player)) break block8;
                            player = (Player)livingEntity;
                            stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get());
                            level = player.m_20193_();
                            Item item = stack.m_41720_();
                            if (!(item instanceof HolyLocketItem)) break block9;
                            relic = (HolyLocketItem)item;
                            if (!NBTUtils.getBoolean(stack, HolyLocketItem.TAG_TOGGLED, true)) break block10;
                        }
                        return;
                    }
                    for (LivingEntity target : level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(relic.getAbilityValue(stack, "belief", "radius"))).stream().filter(arg_0 -> ((Player)player).m_142582_(arg_0)).sorted(Comparator.comparing(entity -> entity.m_20182_().m_82554_(player.m_20182_()))).limit((int)relic.getAbilityValue(stack, "belief", "count")).toList()) {
                        if (target.m_20149_().equals(player.m_20149_())) continue;
                        int amount = (int)Math.max((double)event.getAmount() * relic.getAbilityValue(stack, "belief", "amount"), 1.0);
                        DeathEssenceEntity essence = new DeathEssenceEntity((EntityType<? extends DeathEssenceEntity>)((EntityType)EntityRegistry.DEATH_ESSENCE.get()), level);
                        essence.m_146884_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0));
                        essence.setDirectionChoice(MathUtils.randomFloat(player.m_217043_()));
                        essence.setTarget(target);
                        essence.setDamage(amount);
                        level.m_7967_((Entity)essence);
                        if (!level.m_5776_()) {
                            NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> essence), new SyncTargetPacket(essence.m_19879_(), target.m_19879_()));
                        }
                        relic.spreadExperience((LivingEntity)player, stack, amount);
                        relic.addCharge(stack, 1);
                    }
                    break block11;
                }
                LivingEntity entity2 = event.getEntity();
                Level level = entity2.m_20193_();
                for (ServerPlayer playerSearched : level.m_45976_(ServerPlayer.class, event.getEntity().m_20191_().m_82400_(32.0))) {
                    HolyLocketItem relic;
                    ItemStack stack = EntityUtils.findEquippedCurio((Entity)playerSearched, (Item)ItemRegistry.HOLY_LOCKET.get());
                    Item essence = stack.m_41720_();
                    if (!(essence instanceof HolyLocketItem) || (relic = (HolyLocketItem)essence).getAbilityValue(stack, "belief", "radius") < playerSearched.m_20182_().m_82554_(event.getEntity().m_20182_()) || !NBTUtils.getBoolean(stack, HolyLocketItem.TAG_TOGGLED, true)) continue;
                    int amount = (int)Math.max((double)event.getAmount() * relic.getAbilityValue(stack, "belief", "amount"), 0.5);
                    LifeEssenceEntity essence2 = new LifeEssenceEntity((EntityType<? extends LifeEssenceEntity>)((EntityType)EntityRegistry.LIFE_ESSENCE.get()), level);
                    essence2.m_146884_(entity2.m_20182_().m_82520_(0.0, (double)(entity2.m_20206_() / 2.0f), 0.0));
                    essence2.setDirectionChoice(MathUtils.randomFloat(playerSearched.m_217043_()));
                    essence2.setTarget((LivingEntity)playerSearched);
                    essence2.setHeal(amount);
                    playerSearched.m_9236_().m_7967_((Entity)essence2);
                    if (!level.m_5776_()) {
                        NetworkHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> essence2), new SyncTargetPacket(essence2.m_19879_(), playerSearched.m_19879_()));
                    }
                    relic.spreadExperience((LivingEntity)playerSearched, stack, amount);
                    relic.addCharge(stack, 1);
                }
            }
        }
    }
}

