/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class StringWidget
extends Widget {
    private float alignX;
    private Component message;
    private boolean shadow;
    private final Component tooltip;

    public StringWidget(Panel panel, @Nullable Component tooltip, boolean shadow) {
        super(panel);
        this.tooltip = tooltip;
        this.shadow = shadow;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    private StringWidget horizontalAlignment(float horizontalAlignment) {
        this.alignX = horizontalAlignment;
        return this;
    }

    public StringWidget alignLeft() {
        return this.horizontalAlignment(0.0f);
    }

    public StringWidget alignCenter() {
        return this.horizontalAlignment(0.5f);
    }

    public StringWidget alignRight() {
        return this.horizontalAlignment(1.0f);
    }

    public void addMouseOverText(TooltipList list) {
        if (this.tooltip != null) {
            list.add(this.tooltip);
        }
        super.addMouseOverText(list);
    }

    public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        Font font = theme.getFont();
        int offsetX = this.getX() + Math.round(this.alignX * (float)(this.width - font.m_92852_((FormattedText)this.message)));
        int yPos = this.getY();
        int height = this.height;
        int offsetY = yPos + (height - 9) / 2;
        if (this.shadow) {
            theme.drawString(graphics, (Object)this.message, offsetX, offsetY, 2);
        } else {
            theme.drawString(graphics, (Object)this.message, offsetX, offsetY);
        }
    }
}

